/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.fabric.controller;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1268;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2824;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface FabricActionControllerEvents {
    public static final Event<ServerPlayerLevelChange> SERVER_PLAYER_LEVEL_CHANGE = EventFactory.createArrayBacked(ServerPlayerLevelChange.class, callbacks -> (player, oldLevel, newLevel) -> {
        for (ServerPlayerLevelChange callback : callbacks) {
            callback.levelChange(player, oldLevel, newLevel);
        }
    });
    public static final Event<ServerPlayerToggleSneak> SERVER_PLAYER_TOGGLE_SNEAK = EventFactory.createArrayBacked(ServerPlayerToggleSneak.class, callbacks -> (player, sneak) -> {
        for (ServerPlayerToggleSneak callback : callbacks) {
            callback.toggleSneak(player, sneak);
        }
    });
    public static final Event<ServerPlayerHandSwing> SERVER_PLAYER_HAND_SWING = EventFactory.createArrayBacked(ServerPlayerHandSwing.class, callbacks -> player -> {
        for (ServerPlayerHandSwing callback : callbacks) {
            callback.swingHand(player);
        }
    });
    public static final Event<ServerPlayerDisconnect> SERVER_PLAYER_DISCONNECT = EventFactory.createArrayBacked(ServerPlayerDisconnect.class, callbacks -> player -> {
        for (ServerPlayerDisconnect callback : callbacks) {
            callback.disconnect(player);
        }
    });
    public static final Event<ServerPlayerMove> SERVER_PLAYER_MOVE = EventFactory.createArrayBacked(ServerPlayerMove.class, callbacks -> (player, posTo, rotTo) -> {
        for (ServerPlayerMove callback : callbacks) {
            callback.move(player, posTo, rotTo);
        }
    });
    public static final Event<ServerPlayerEntityInteract> SERVER_PLAYER_ENTITY_INTERACT = EventFactory.createArrayBacked(ServerPlayerEntityInteract.class, callbacks -> (entityId, player, actionType, hand) -> {
        for (ServerPlayerEntityInteract callback : callbacks) {
            if (!callback.interact(entityId, player, actionType, hand)) continue;
            return true;
        }
        return false;
    });

    @FunctionalInterface
    public static interface ServerPlayerEntityInteract {
        public boolean interact(int var1, @NotNull class_3222 var2, @NotNull class_2824.class_5907 var3, @NotNull class_1268 var4);
    }

    @FunctionalInterface
    public static interface ServerPlayerMove {
        public void move(@NotNull class_3222 var1, @Nullable class_243 var2, @Nullable class_241 var3);
    }

    @FunctionalInterface
    public static interface ServerPlayerDisconnect {
        public void disconnect(@NotNull class_3222 var1);
    }

    @FunctionalInterface
    public static interface ServerPlayerHandSwing {
        public void swingHand(@NotNull class_3222 var1);
    }

    @FunctionalInterface
    public static interface ServerPlayerToggleSneak {
        public void toggleSneak(@NotNull class_3222 var1, boolean var2);
    }

    @FunctionalInterface
    public static interface ServerPlayerLevelChange {
        public void levelChange(@NotNull class_3222 var1, @Nullable class_3218 var2, @NotNull class_3218 var3);
    }
}

