/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.fabric.mixins;

import com.github.juliarn.npclib.fabric.controller.FabricActionControllerEvents;
import net.minecraft.class_10185;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2824;
import net.minecraft.class_2828;
import net.minecraft.class_2833;
import net.minecraft.class_2851;
import net.minecraft.class_2879;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3244.class})
public abstract class ServerGamePacketListenerImplMixin {
    @Shadow
    public abstract class_3222 getPlayer();

    @Inject(method={"handlePlayerInput"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/server/level/ServerLevel;)V")})
    public void npc_lib$handlePlayerInput(class_2851 packet, CallbackInfo ci) {
        class_3222 player = this.getPlayer();
        class_10185 sentInput = packet.comp_3139();
        class_10185 lastInput = player.method_63562();
        if (lastInput.comp_3164() != sentInput.comp_3164()) {
            FabricActionControllerEvents.ServerPlayerToggleSneak invoker = (FabricActionControllerEvents.ServerPlayerToggleSneak)FabricActionControllerEvents.SERVER_PLAYER_TOGGLE_SNEAK.invoker();
            invoker.toggleSneak(player, sentInput.comp_3164());
        }
    }

    @Inject(method={"handleAnimate"}, at={@At(value="TAIL")})
    public void npc_lib$handleAnimate(class_2879 packet, CallbackInfo ci) {
        class_3222 player = this.getPlayer();
        FabricActionControllerEvents.ServerPlayerHandSwing invoker = (FabricActionControllerEvents.ServerPlayerHandSwing)FabricActionControllerEvents.SERVER_PLAYER_HAND_SWING.invoker();
        invoker.swingHand(player);
    }

    @Inject(method={"handleMovePlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/game/ServerboundMovePlayerPacket;getYRot(F)F")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;hasClientLoaded()Z"), to=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;updateAwaitingTeleport()Z"))})
    public void npc_lib$handleMovePlayer(class_2828 packet, CallbackInfo ci) {
        boolean hasPos = packet.method_36171();
        boolean hasRot = packet.method_36172();
        if (!hasPos && !hasRot) {
            return;
        }
        class_3222 player = this.getPlayer();
        double posToX = packet.method_12269(player.method_23317());
        double posToY = packet.method_12268(player.method_23318());
        double posToZ = packet.method_12274(player.method_23321());
        class_243 posTo = hasPos ? new class_243(posToX, posToY, posToZ) : null;
        float rotToX = packet.method_12270(player.method_36455());
        float rotToY = packet.method_12271(player.method_36454());
        class_241 rotTo = hasRot ? new class_241(rotToX, rotToY) : null;
        FabricActionControllerEvents.ServerPlayerMove invoker = (FabricActionControllerEvents.ServerPlayerMove)FabricActionControllerEvents.SERVER_PLAYER_MOVE.invoker();
        invoker.move(player, posTo, rotTo);
    }

    @Inject(method={"handleMoveVehicle"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getControllingPassenger()Lnet/minecraft/world/entity/LivingEntity;")})
    public void npc_lib$handleMoveVehicle(class_2833 packet, CallbackInfo ci) {
        class_3222 player = this.getPlayer();
        class_1297 rootVehicle = player.method_5668();
        class_243 posFrom = rootVehicle.method_73189();
        class_243 posTo = packet.comp_3350();
        if (posTo.equals((Object)posFrom)) {
            posTo = null;
        }
        class_241 rotFrom = rootVehicle.method_5802();
        class_241 rotTo = new class_241(packet.comp_3352(), packet.comp_3351());
        if (rotTo.method_1016(rotFrom)) {
            rotTo = null;
        }
        if (posTo != null || rotTo != null) {
            FabricActionControllerEvents.ServerPlayerMove invoker = (FabricActionControllerEvents.ServerPlayerMove)FabricActionControllerEvents.SERVER_PLAYER_MOVE.invoker();
            invoker.move(player, posTo, rotTo);
        }
    }

    @Inject(method={"handleInteract"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/server/level/ServerPlayer;setShiftKeyDown(Z)V")}, cancellable=true)
    public void npc_lib$handleInteract(class_2824 packet, CallbackInfo ci) {
        class_1268 hand;
        class_3222 player = this.getPlayer();
        FabricActionControllerEvents.ServerPlayerEntityInteract invoker = (FabricActionControllerEvents.ServerPlayerEntityInteract)FabricActionControllerEvents.SERVER_PLAYER_ENTITY_INTERACT.invoker();
        class_2824.class_5906 action = packet.field_12871;
        class_2824.class_5907 actionType = action.method_34211();
        if (action instanceof class_2824.class_5909) {
            class_2824.class_5909 interactionAction = (class_2824.class_5909)action;
            class_1268 hand2 = interactionAction.field_29176;
            if (invoker.interact(packet.field_12870, player, class_2824.class_5907.field_29171, hand2)) {
                ci.cancel();
            }
        } else if (actionType == class_2824.class_5907.field_29172 && invoker.interact(packet.field_12870, player, class_2824.class_5907.field_29172, hand = class_1268.field_5808)) {
            ci.cancel();
        }
    }
}

