/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.fabric.protocol;

import com.github.juliarn.npclib.api.Npc;
import com.github.juliarn.npclib.api.Platform;
import com.github.juliarn.npclib.api.PlatformVersionAccessor;
import com.github.juliarn.npclib.api.Position;
import com.github.juliarn.npclib.api.event.InteractNpcEvent;
import com.github.juliarn.npclib.api.profile.Profile;
import com.github.juliarn.npclib.api.profile.ProfileProperty;
import com.github.juliarn.npclib.api.protocol.OutboundPacket;
import com.github.juliarn.npclib.api.protocol.PlatformPacketAdapter;
import com.github.juliarn.npclib.api.protocol.chat.Component;
import com.github.juliarn.npclib.api.protocol.enums.EntityAnimation;
import com.github.juliarn.npclib.api.protocol.enums.EntityPose;
import com.github.juliarn.npclib.api.protocol.enums.ItemSlot;
import com.github.juliarn.npclib.api.protocol.enums.PlayerInfoAction;
import com.github.juliarn.npclib.api.protocol.meta.EntityMetadata;
import com.github.juliarn.npclib.api.protocol.meta.EntityMetadataFactory;
import com.github.juliarn.npclib.common.event.DefaultAttackNpcEvent;
import com.github.juliarn.npclib.common.event.DefaultInteractNpcEvent;
import com.github.juliarn.npclib.fabric.controller.FabricActionControllerEvents;
import com.github.juliarn.npclib.fabric.protocol.ByteArrayCustomPayload;
import com.github.juliarn.npclib.fabric.protocol.EntityDataFactory;
import com.github.juliarn.npclib.fabric.util.FabricUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.leangen.geantyref.TypeFactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.impl.networking.PayloadTypeRegistryImpl;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2616;
import net.minecraft.class_2684;
import net.minecraft.class_2703;
import net.minecraft.class_2716;
import net.minecraft.class_2726;
import net.minecraft.class_2739;
import net.minecraft.class_2744;
import net.minecraft.class_2824;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_6903;
import net.minecraft.class_7828;
import net.minecraft.class_8710;
import net.minecraft.class_8824;
import org.jetbrains.annotations.NotNull;

public final class FabricProtocolAdapter
implements PlatformPacketAdapter<class_3218, class_3222, class_1799, Object> {
    private static final FabricProtocolAdapter INSTANCE = new FabricProtocolAdapter();
    private static final Type OPTIONAL_CHAT_COMPONENT_TYPE = TypeFactory.parameterizedClass(Optional.class, new Type[]{class_2561.class});
    private static final EnumMap<EntityPose, class_4050> ENTITY_POSE_CONVERTER;
    private static final EnumMap<ItemSlot, class_1304> ITEM_SLOT_CONVERTER;
    private static final EnumMap<class_1268, InteractNpcEvent.Hand> HAND_CONVERTER;
    private static final Map<Type, EntityDataFactory> META_ENTRY_FACTORY;
    private static final Map<Type, Map.Entry<Type, UnaryOperator<Object>>> SERIALIZER_CONVERTERS;
    private static final EnumSet<class_2703.class_5893> ADD_ACTIONS;

    private FabricProtocolAdapter() {
    }

    @NotNull
    public static PlatformPacketAdapter<class_3218, class_3222, class_1799, Object> fabricProtocolAdapter() {
        return INSTANCE;
    }

    @NotNull
    private static class_2945.class_7834<?> createDataValue(@NotNull Type type, @NotNull Object value, int index) {
        EntityDataFactory metaFactory;
        Map.Entry<Type, UnaryOperator<Object>> converter = SERIALIZER_CONVERTERS.get(type);
        if (converter != null) {
            type = converter.getKey();
            value = converter.getValue().apply(value);
        }
        if ((metaFactory = META_ENTRY_FACTORY.get(type)) == null) {
            throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
        }
        return metaFactory.create(index, value);
    }

    @Override
    @NotNull
    public OutboundPacket<class_3218, class_3222, class_1799, Object> createEntitySpawnPacket() {
        return (player, npc) -> {
            Position pos = npc.position();
            class_2604 packet = new class_2604(npc.entityId(), npc.profile().uniqueId(), pos.x(), pos.y(), pos.z(), pos.pitch(), pos.yaw(), class_1299.field_6097, 0, class_243.field_1353, (double)pos.yaw());
            player.field_13987.method_14364((class_2596)packet);
        };
    }

    @Override
    @NotNull
    public OutboundPacket<class_3218, class_3222, class_1799, Object> createEntityRemovePacket() {
        return (player, npc) -> {
            class_2716 packet = new class_2716(new int[]{npc.entityId()});
            player.field_13987.method_14364((class_2596)packet);
        };
    }

    @Override
    @NotNull
    public OutboundPacket<class_3218, class_3222, class_1799, Object> createPlayerInfoPacket(@NotNull PlayerInfoAction action) {
        return (player, npc) -> {
            class_7828 packet = switch (action) {
                default -> throw new MatchException(null, null);
                case PlayerInfoAction.REMOVE_PLAYER -> new class_7828(List.of(npc.profile().uniqueId()));
                case PlayerInfoAction.ADD_PLAYER -> {
                    Profile.Resolved profile = npc.profile();
                    PropertyMap gameProfileProperties = profile.properties().stream().collect(Collectors.collectingAndThen(Multimaps.toMultimap(ProfileProperty::name, pp -> new Property(pp.name(), pp.value(), pp.signature()), HashMultimap::create), PropertyMap::new));
                    GameProfile gameProfile = new GameProfile(profile.uniqueId(), profile.name(), gameProfileProperties);
                    class_2703 updatePacket = new class_2703(ADD_ACTIONS, List.of());
                    updatePacket.field_12369 = List.of(new class_2703.class_2705(npc.profile().uniqueId(), gameProfile, false, 20, class_1934.field_9220, null, true, 0, null));
                    yield updatePacket;
                }
            };
            player.field_13987.method_14364((class_2596)packet);
        };
    }

    @Override
    @NotNull
    public OutboundPacket<class_3218, class_3222, class_1799, Object> createRotationPacket(float yaw, float pitch) {
        return (player, npc) -> {
            class_2726 headLookPacket = new class_2726((class_1297)player, class_3532.method_62995((float)yaw));
            headLookPacket.field_12437 = npc.entityId();
            player.field_13987.method_14364((class_2596)headLookPacket);
            class_2684.class_2687 rotationPacket = new class_2684.class_2687(npc.entityId(), class_3532.method_62995((float)yaw), class_3532.method_62995((float)pitch), true);
            player.field_13987.method_14364((class_2596)rotationPacket);
        };
    }

    @Override
    @NotNull
    public OutboundPacket<class_3218, class_3222, class_1799, Object> createAnimationPacket(@NotNull EntityAnimation animation) {
        return (player, npc) -> {
            class_2616 packet = new class_2616((class_1297)player, animation.id());
            packet.field_12029 = npc.entityId();
            player.field_13987.method_14364((class_2596)packet);
        };
    }

    @Override
    @NotNull
    public OutboundPacket<class_3218, class_3222, class_1799, Object> createEquipmentPacket(@NotNull ItemSlot slot, @NotNull class_1799 item) {
        return (player, npc) -> {
            class_1304 equipmentSlot = ITEM_SLOT_CONVERTER.get((Object)slot);
            List<Pair> items = List.of(Pair.of((Object)equipmentSlot, (Object)item));
            class_2744 packet = new class_2744(npc.entityId(), items);
            player.field_13987.method_14364((class_2596)packet);
        };
    }

    @Override
    @NotNull
    public OutboundPacket<class_3218, class_3222, class_1799, Object> createCustomPayloadPacket(@NotNull String channelId, byte[] payload) {
        return (player, npc) -> {
            class_2960 channelLocation = class_2960.method_60654((String)channelId);
            class_8710.class_9154 payloadType = new class_8710.class_9154(channelLocation);
            ByteArrayCustomPayload customPayload = new ByteArrayCustomPayload((class_8710.class_9154<ByteArrayCustomPayload>)payloadType, payload);
            PayloadTypeRegistryImpl payloadTypeRegistry = PayloadTypeRegistryImpl.PLAY_S2C;
            class_8710.class_9155 registered = payloadTypeRegistry.get(channelLocation);
            if (registered == null) {
                payloadTypeRegistry.register(payloadType, ByteArrayCustomPayload.CODEC);
            }
            ServerPlayNetworking.send((class_3222)player, (class_8710)customPayload);
        };
    }

    @Override
    @NotNull
    public <T, O> OutboundPacket<class_3218, class_3222, class_1799, Object> createEntityMetaPacket(@NotNull EntityMetadataFactory<T, O> metadata, @NotNull T value) {
        return (player, npc) -> {
            PlatformVersionAccessor versionAccessor = npc.platform().versionAccessor();
            EntityMetadata entityMetadata = metadata.create(value, versionAccessor);
            if (!entityMetadata.available()) {
                return;
            }
            ArrayList entries = new ArrayList();
            entries.add(FabricProtocolAdapter.createDataValue(entityMetadata.type(), entityMetadata.value(), entityMetadata.index()));
            for (EntityMetadataFactory<Object, Object> entityMetadataFactory : metadata.relatedMetadata()) {
                EntityMetadata<Object> related = entityMetadataFactory.create(value, versionAccessor);
                if (!related.available()) continue;
                entries.add(FabricProtocolAdapter.createDataValue(related.type(), related.value(), related.index()));
            }
            class_2739 packet = new class_2739(npc.entityId(), entries);
            player.field_13987.method_14364((class_2596)packet);
        };
    }

    @Override
    public void initialize(@NotNull Platform<class_3218, class_3222, class_1799, Object> platform) {
        FabricActionControllerEvents.SERVER_PLAYER_ENTITY_INTERACT.register((entityId, player, actionType, hand) -> {
            Npc npc = platform.npcTracker().npcById(entityId);
            if (npc != null) {
                return switch (actionType) {
                    case class_2824.class_5907.field_29172 -> {
                        platform.eventManager().post(DefaultAttackNpcEvent.attackNpc(npc, player));
                        yield true;
                    }
                    case class_2824.class_5907.field_29171 -> {
                        InteractNpcEvent.Hand convertedHand = HAND_CONVERTER.get(hand);
                        platform.eventManager().post(DefaultInteractNpcEvent.interactNpc(npc, player, convertedHand));
                        yield true;
                    }
                    default -> false;
                };
            }
            return false;
        });
    }

    static {
        ADD_ACTIONS = EnumSet.of(class_2703.class_5893.field_29136, new class_2703.class_5893[]{class_2703.class_5893.field_54981, class_2703.class_5893.field_40700, class_2703.class_5893.field_29138, class_2703.class_5893.field_29137, class_2703.class_5893.field_29139});
        ITEM_SLOT_CONVERTER = new EnumMap(ItemSlot.class);
        ITEM_SLOT_CONVERTER.put(ItemSlot.MAIN_HAND, class_1304.field_6173);
        ITEM_SLOT_CONVERTER.put(ItemSlot.OFF_HAND, class_1304.field_6171);
        ITEM_SLOT_CONVERTER.put(ItemSlot.FEET, class_1304.field_6166);
        ITEM_SLOT_CONVERTER.put(ItemSlot.LEGS, class_1304.field_6172);
        ITEM_SLOT_CONVERTER.put(ItemSlot.CHEST, class_1304.field_6174);
        ITEM_SLOT_CONVERTER.put(ItemSlot.HEAD, class_1304.field_6169);
        ENTITY_POSE_CONVERTER = new EnumMap(EntityPose.class);
        ENTITY_POSE_CONVERTER.put(EntityPose.STANDING, class_4050.field_18076);
        ENTITY_POSE_CONVERTER.put(EntityPose.FALL_FLYING, class_4050.field_18077);
        ENTITY_POSE_CONVERTER.put(EntityPose.SLEEPING, class_4050.field_18078);
        ENTITY_POSE_CONVERTER.put(EntityPose.SWIMMING, class_4050.field_18079);
        ENTITY_POSE_CONVERTER.put(EntityPose.SPIN_ATTACK, class_4050.field_18080);
        ENTITY_POSE_CONVERTER.put(EntityPose.CROUCHING, class_4050.field_18081);
        ENTITY_POSE_CONVERTER.put(EntityPose.LONG_JUMPING, class_4050.field_30095);
        ENTITY_POSE_CONVERTER.put(EntityPose.DYING, class_4050.field_18082);
        ENTITY_POSE_CONVERTER.put(EntityPose.CROAKING, class_4050.field_37422);
        ENTITY_POSE_CONVERTER.put(EntityPose.USING_TONGUE, class_4050.field_37423);
        ENTITY_POSE_CONVERTER.put(EntityPose.ROARING, class_4050.field_38097);
        ENTITY_POSE_CONVERTER.put(EntityPose.SNIFFING, class_4050.field_38098);
        ENTITY_POSE_CONVERTER.put(EntityPose.EMERGING, class_4050.field_38099);
        ENTITY_POSE_CONVERTER.put(EntityPose.DIGGING, class_4050.field_38100);
        ENTITY_POSE_CONVERTER.put(EntityPose.SLIDING, class_4050.field_47246);
        ENTITY_POSE_CONVERTER.put(EntityPose.SHOOTING, class_4050.field_47247);
        ENTITY_POSE_CONVERTER.put(EntityPose.INHALING, class_4050.field_47248);
        HAND_CONVERTER = new EnumMap(class_1268.class);
        HAND_CONVERTER.put(class_1268.field_5808, InteractNpcEvent.Hand.MAIN_HAND);
        HAND_CONVERTER.put(class_1268.field_5810, InteractNpcEvent.Hand.OFF_HAND);
        SERIALIZER_CONVERTERS = HashMap.newHashMap(2);
        SERIALIZER_CONVERTERS.put((Type)((Object)EntityPose.class), (Map.Entry<Type, UnaryOperator<Object>>)Map.entry(class_4050.class, ENTITY_POSE_CONVERTER::get));
        SERIALIZER_CONVERTERS.put(TypeFactory.parameterizedClass(Optional.class, new Type[]{Component.class}), Map.entry(OPTIONAL_CHAT_COMPONENT_TYPE, value -> {
            Optional optionalComponent = (Optional)value;
            return optionalComponent.map(component -> {
                String rawMessage = component.rawMessage();
                if (rawMessage != null) {
                    return class_2561.method_43470((String)rawMessage);
                }
                String encodedJson = Objects.requireNonNull(component.encodedJsonMessage());
                JsonElement encodedJsonTree = JsonParser.parseString((String)encodedJson);
                class_6903 context = FabricUtil.getServer().method_30611().method_57093((DynamicOps)JsonOps.INSTANCE);
                return (class_2561)((Pair)class_8824.field_46597.decode((DynamicOps)context, (Object)encodedJsonTree).getOrThrow(IllegalArgumentException::new)).getFirst();
            });
        }));
        META_ENTRY_FACTORY = HashMap.newHashMap(7);
        META_ENTRY_FACTORY.put((Type)((Object)Byte.class), (index, value) -> new class_2945.class_7834(index, class_2943.field_13319, (Object)((Byte)value)));
        META_ENTRY_FACTORY.put((Type)((Object)Integer.class), (index, value) -> new class_2945.class_7834(index, class_2943.field_13327, (Object)((Integer)value)));
        META_ENTRY_FACTORY.put((Type)((Object)Float.class), (index, value) -> new class_2945.class_7834(index, class_2943.field_13320, (Object)Float.valueOf(((Float)value).floatValue())));
        META_ENTRY_FACTORY.put((Type)((Object)Boolean.class), (index, value) -> new class_2945.class_7834(index, class_2943.field_13323, (Object)((Boolean)value)));
        META_ENTRY_FACTORY.put((Type)((Object)String.class), (index, value) -> new class_2945.class_7834(index, class_2943.field_13326, (Object)((String)value)));
        META_ENTRY_FACTORY.put((Type)((Object)class_4050.class), (index, value) -> new class_2945.class_7834(index, class_2943.field_18238, (Object)((class_4050)value)));
        META_ENTRY_FACTORY.put(OPTIONAL_CHAT_COMPONENT_TYPE, (index, value) -> new class_2945.class_7834(index, class_2943.field_13325, (Object)((Optional)value)));
    }
}

