/*
 * Decompiled with CFR 0.152.
 */
package com.zack858.orbitalstrike;

import com.zack858.orbitalstrike.AuthManager;
import com.zack858.orbitalstrike.OrbitalStrikePlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class AuthCommand
implements CommandExecutor,
TabCompleter {
    private final OrbitalStrikePlugin plugin;

    public AuthCommand(OrbitalStrikePlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int seconds;
        if (sender instanceof Player && !sender.isOp()) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /osauth <player> <seconds>");
            sender.sendMessage("\u00a77Grant temporary access to a player");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer '" + args[0] + "' not found!");
            return true;
        }
        try {
            seconds = Integer.parseInt(args[1]);
            if (seconds < 1) {
                sender.sendMessage("\u00a7cDuration must be at least 1 second!");
                return true;
            }
            if (seconds > 86400) {
                sender.sendMessage("\u00a7cDuration cannot exceed 86400 seconds (24 hours)!");
                return true;
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid duration! Must be a number.");
            return true;
        }
        AuthManager.authorize(target, seconds);
        String timeFormatted = AuthManager.formatTime(seconds);
        sender.sendMessage("\u00a7aDEBUG to \u00a7e" + target.getName() + "\u00a7a for \u00a7e" + timeFormatted);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player && !sender.isOp()) {
            return new ArrayList<String>();
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            completions.addAll(Arrays.asList("60", "300", "600", "1800", "3600"));
        }
        String current = args[args.length - 1].toLowerCase();
        return completions.stream().filter(s -> s.toLowerCase().startsWith(current)).collect(Collectors.toList());
    }
}

