/*
 * Decompiled with CFR 0.152.
 */
package com.zack858.orbitalstrike;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class AuthManager {
    private static final Map<UUID, Long> authorizations = new HashMap<UUID, Long>();

    public static void authorize(Player player, int seconds) {
        long expiryTime = System.currentTimeMillis() + (long)seconds * 1000L;
        authorizations.put(player.getUniqueId(), expiryTime);
    }

    public static boolean isAuthorized(Player player) {
        if (player.isOp()) {
            return true;
        }
        UUID playerId = player.getUniqueId();
        if (!authorizations.containsKey(playerId)) {
            return false;
        }
        long expiryTime = authorizations.get(playerId);
        long currentTime = System.currentTimeMillis();
        if (currentTime >= expiryTime) {
            authorizations.remove(playerId);
            return false;
        }
        return true;
    }

    public static long getRemainingTime(Player player) {
        long currentTime;
        if (player.isOp()) {
            return Long.MAX_VALUE;
        }
        UUID playerId = player.getUniqueId();
        if (!authorizations.containsKey(playerId)) {
            return 0L;
        }
        long expiryTime = authorizations.get(playerId);
        long remaining = expiryTime - (currentTime = System.currentTimeMillis());
        if (remaining <= 0L) {
            authorizations.remove(playerId);
            return 0L;
        }
        return remaining / 1000L;
    }

    public static void revoke(Player player) {
        authorizations.remove(player.getUniqueId());
    }

    public static void clearAll() {
        authorizations.clear();
    }

    public static String formatTime(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        if (hours > 0L) {
            return String.format("%d:%02d:%02d", hours, minutes, secs);
        }
        return String.format("%d:%02d", minutes, secs);
    }
}

