/*
 * Decompiled with CFR 0.152.
 */
package com.zack858.orbitalstrike;

import com.zack858.orbitalstrike.AuthManager;
import com.zack858.orbitalstrike.CooldownManager;
import com.zack858.orbitalstrike.OrbitalStrikeLogic;
import com.zack858.orbitalstrike.OrbitalStrikePlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;

public class OrbitalStrikeCommand
implements CommandExecutor,
TabCompleter {
    private final OrbitalStrikePlugin plugin;

    public OrbitalStrikeCommand(OrbitalStrikePlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        if (sender instanceof Player) {
            player = (Player)sender;
            if (!AuthManager.isAuthorized(player)) {
                sender.sendMessage("\u00a7cYou don't have permission to use this command!");
                return true;
            }
        } else if (!sender.isOp()) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7cUsage: /orbitalstrike <payload> <pos> [world] [size]");
            sender.sendMessage("\u00a7cUsage: /orbitalstrike crosshair <payload> [size]");
            return true;
        }
        if (sender instanceof Player && CooldownManager.isOnCooldown(player = (Player)sender)) {
            long remaining = CooldownManager.getRemainingCooldown(player);
            sender.sendMessage("\u00a7cYou must wait " + CooldownManager.formatTime(remaining) + " before using this command again!");
            return true;
        }
        if (args[0].equalsIgnoreCase("crosshair")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("\u00a7cOnly players can use crosshair targeting!");
                return true;
            }
            player = (Player)sender;
            if (args.length < 2) {
                sender.sendMessage("\u00a7cUsage: /orbitalstrike crosshair <payload> [size]");
                return true;
            }
            String payload = args[1];
            RayTraceResult result = player.rayTraceBlocks(300.0);
            if (result == null || result.getHitBlock() == null) {
                sender.sendMessage("\u00a7cNo block in crosshair within 300 blocks.");
                return true;
            }
            Location target = result.getHitBlock().getLocation();
            int x = target.getBlockX();
            int z = target.getBlockZ();
            int groundY = target.getBlockY();
            if (payload.equalsIgnoreCase("nuke")) {
                if (args.length >= 3) {
                    try {
                        int size = Integer.parseInt(args[2]);
                        if (size < 1 || size > OrbitalStrikePlugin.getMaxRings()) {
                            sender.sendMessage("\u00a7cSize must be between 1 and " + OrbitalStrikePlugin.getMaxRings());
                            return true;
                        }
                        OrbitalStrikeLogic.summonNuke(target.getWorld(), x, groundY + 72, z, size);
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage("\u00a7cInvalid size number!");
                        return true;
                    }
                } else {
                    OrbitalStrikeLogic.summonNuke(target.getWorld(), x, groundY + 72, z, OrbitalStrikePlugin.getDefaultRings());
                }
            } else if (payload.equalsIgnoreCase("stab")) {
                OrbitalStrikeLogic.summonStab(target.getWorld(), x, z, groundY);
            } else {
                sender.sendMessage("\u00a7cUnknown payload: " + payload);
                return true;
            }
            if (sender instanceof Player) {
                CooldownManager.setCooldown((Player)sender);
            }
            return true;
        }
        String payload = args[0];
        if (args.length < 4) {
            sender.sendMessage("\u00a7cUsage: /orbitalstrike <payload> <pos> [world] [size]");
            return true;
        }
        try {
            World world;
            int x = this.parseCoordinate(args[1], sender instanceof Player ? ((Player)sender).getLocation().getBlockX() : 0);
            int y = this.parseCoordinate(args[2], sender instanceof Player ? ((Player)sender).getLocation().getBlockY() : 0);
            int z = this.parseCoordinate(args[3], sender instanceof Player ? ((Player)sender).getLocation().getBlockZ() : 0);
            int sizeArgIndex = 4;
            if (args.length >= 5) {
                String possibleWorld = args[4];
                World parsedWorld = this.parseWorld(possibleWorld);
                if (parsedWorld != null) {
                    world = parsedWorld;
                    sizeArgIndex = 5;
                } else {
                    try {
                        Integer.parseInt(possibleWorld);
                        world = sender instanceof Player ? ((Player)sender).getWorld() : Bukkit.getWorld((String)"world");
                        sizeArgIndex = 4;
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage("\u00a7cInvalid world or size: " + possibleWorld);
                        return true;
                    }
                }
            } else {
                world = sender instanceof Player ? ((Player)sender).getWorld() : Bukkit.getWorld((String)"world");
            }
            if (world == null) {
                sender.sendMessage("\u00a7cWorld not found!");
                return true;
            }
            if (payload.equalsIgnoreCase("nuke")) {
                if (args.length > sizeArgIndex) {
                    try {
                        int size = Integer.parseInt(args[sizeArgIndex]);
                        if (size < 1 || size > OrbitalStrikePlugin.getMaxRings()) {
                            sender.sendMessage("\u00a7cSize must be between 1 and " + OrbitalStrikePlugin.getMaxRings());
                            return true;
                        }
                        OrbitalStrikeLogic.summonNuke(world, x, y + 72, z, size);
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage("\u00a7cInvalid size number!");
                        return true;
                    }
                } else {
                    OrbitalStrikeLogic.summonNuke(world, x, y + 72, z, OrbitalStrikePlugin.getDefaultRings());
                }
            } else if (payload.equalsIgnoreCase("stab")) {
                OrbitalStrikeLogic.summonStab(world, x, z, y);
            } else {
                sender.sendMessage("\u00a7cUnknown payload: " + payload);
                return true;
            }
            if (sender instanceof Player) {
                CooldownManager.setCooldown((Player)sender);
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid coordinates!");
            return true;
        }
        return true;
    }

    private int parseCoordinate(String input, int current) throws NumberFormatException {
        if (input.equals("~")) {
            return current;
        }
        if (input.startsWith("~")) {
            return current + Integer.parseInt(input.substring(1));
        }
        return Integer.parseInt(input);
    }

    private World parseWorld(String worldName) {
        switch (worldName.toLowerCase()) {
            case "overworld": 
            case "world": {
                return Bukkit.getWorld((String)"world");
            }
            case "nether": 
            case "the_nether": {
                return Bukkit.getWorld((String)"world_nether");
            }
            case "end": 
            case "the_end": {
                return Bukkit.getWorld((String)"world_the_end");
            }
        }
        return Bukkit.getWorld((String)worldName);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        if (sender instanceof Player ? !AuthManager.isAuthorized(player = (Player)sender) : !sender.isOp()) {
            return new ArrayList<String>();
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.addAll(Arrays.asList("nuke", "stab", "crosshair"));
        } else if (args.length == 2) {
            if (args[0].equalsIgnoreCase("crosshair")) {
                completions.addAll(Arrays.asList("nuke", "stab"));
            } else if (sender instanceof Player) {
                player = (Player)sender;
                completions.add("~");
                completions.add(String.valueOf(player.getLocation().getBlockX()));
            }
        } else if (args.length == 3) {
            if (args[0].equalsIgnoreCase("crosshair")) {
                completions.addAll(Arrays.asList("16", "24", "32"));
            } else if (sender instanceof Player) {
                player = (Player)sender;
                completions.add("~");
                completions.add(String.valueOf(player.getLocation().getBlockY()));
            }
        } else if (args.length == 4) {
            if (sender instanceof Player) {
                player = (Player)sender;
                completions.add("~");
                completions.add(String.valueOf(player.getLocation().getBlockZ()));
            }
        } else if (args.length == 5) {
            completions.addAll(Arrays.asList("overworld", "nether", "end"));
            if (args[0].equalsIgnoreCase("nuke")) {
                completions.addAll(Arrays.asList("16", "24", "32"));
            }
        } else if (args.length == 6 && args[0].equalsIgnoreCase("nuke")) {
            completions.addAll(Arrays.asList("16", "24", "32"));
        }
        ArrayList<String> filtered = new ArrayList<String>();
        String current = args[args.length - 1].toLowerCase();
        for (String completion : completions) {
            if (!completion.toLowerCase().startsWith(current)) continue;
            filtered.add(completion);
        }
        return filtered;
    }
}

