/*
 * Decompiled with CFR 0.152.
 */
package com.zack858.orbitalstrike;

import com.zack858.orbitalstrike.AuthCommand;
import com.zack858.orbitalstrike.OrbitalStrikeCommand;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;

public class OrbitalStrikePlugin
extends JavaPlugin {
    private static final int DEFAULT_RINGS = 13;
    private static final int MAX_RINGS = 32;

    public void onEnable() {
        this.getLogger().info("CarpetTIS enabled!");
        LifecycleEventManager manager = this.getLifecycleManager();
        manager.registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            Commands commands = (Commands)event.registrar();
            final OrbitalStrikeCommand commandExecutor = new OrbitalStrikeCommand(this);
            final AuthCommand authExecutor = new AuthCommand(this);
            this.getServer().getCommandMap().register("orbitalstrike", new Command(this, "orbitalstrike"){

                public boolean execute(CommandSender sender, String label, String[] args) {
                    return commandExecutor.onCommand(sender, this, label, args);
                }

                public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
                    return commandExecutor.onTabComplete(sender, this, alias, args);
                }
            }.setAliases(Arrays.asList("os", "strike")).setDescription("Execute orbital strike attacks").setUsage("/orbitalstrike <nuke|stab> <x> <y> <z> [world] [size]\n/orbitalstrike crosshair <nuke|stab> [size]"));
            this.getServer().getCommandMap().register("osauth", new Command(this, "osauth"){

                public boolean execute(CommandSender sender, String label, String[] args) {
                    return authExecutor.onCommand(sender, this, label, args);
                }

                public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
                    return authExecutor.onTabComplete(sender, this, alias, args);
                }
            }.setDescription("Grant temporary os access").setUsage("/osauth <player> <seconds>"));
        });
    }

    public void onDisable() {
        this.getLogger().info("CarpetTIS disabled!");
    }

    public static int getDefaultRings() {
        return 13;
    }

    public static int getMaxRings() {
        return 32;
    }
}

