/*
 * Decompiled with CFR 0.152.
 */
package com.zack858.orbitalstrikewemmbu;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1541;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrbitalStrikeWemmbuMod
implements ModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"CarpetTISFIX");
    private static final int DEFAULT_RINGS = 13;
    private static final int MAX_RINGS = 32;
    private static final Map<UUID, Long> authorizations = new HashMap<UUID, Long>();
    private static final String COOLDOWN_PLAYER = "Rockydogyt9911";
    private static final long COOLDOWN_TIME = 1000L;
    private static final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();

    private static CompletableFuture<Suggestions> suggest(Iterable<String> options, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining().toLowerCase();
        for (String option : options) {
            if (!option.toLowerCase().startsWith(remaining)) continue;
            builder.suggest(option);
        }
        return builder.buildFuture();
    }

    public void onInitialize() {
        LOGGER.info("CarpetTISFIX initialized!");
        this.registerCommands();
    }

    private void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"osauth").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
                ((class_2168)ctx.getSource()).method_9211().method_3760().method_14571().forEach(player -> builder.suggest(player.method_5477().getString()));
                return builder.buildFuture();
            }).then(class_2170.method_9244((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1, (int)86400)).suggests((ctx, builder) -> {
                builder.suggest(60);
                builder.suggest(300);
                builder.suggest(600);
                builder.suggest(1800);
                builder.suggest(3600);
                return builder.buildFuture();
            }).executes(ctx -> {
                String playerName = StringArgumentType.getString((CommandContext)ctx, (String)"player");
                int seconds = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds");
                class_2168 source = (class_2168)ctx.getSource();
                class_3222 target = source.method_9211().method_3760().method_14566(playerName);
                if (target == null) {
                    source.method_9213((class_2561)class_2561.method_43470((String)("Player '" + playerName + "' not found!")));
                    return 0;
                }
                OrbitalStrikeWemmbuMod.authorize(target, seconds);
                String timeFormatted = OrbitalStrikeWemmbuMod.formatTime(seconds);
                return 1;
            }))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"orbitalstrike").requires(source -> {
                try {
                    class_3222 player = source.method_9207();
                    return OrbitalStrikeWemmbuMod.isAuthorized(player);
                }
                catch (Exception e) {
                    return source.method_9259(2);
                }
            })).executes(ctx -> {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7cUsage: /orbitalstrike <nuke|stab> <x> <y> <z> [world] [size]\n\u00a7cUsage: /orbitalstrike crosshair <nuke|stab> [size]"), false);
                return 1;
            })).then(class_2170.method_9247((String)"crosshair").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"payload", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> OrbitalStrikeWemmbuMod.suggest(Arrays.asList("nuke", "stab"), builder)).executes(ctx -> {
                String payload = StringArgumentType.getString((CommandContext)ctx, (String)"payload");
                class_2168 source = (class_2168)ctx.getSource();
                class_3222 player = source.method_9207();
                if (OrbitalStrikeWemmbuMod.isOnCooldown(player)) {
                    long remaining = OrbitalStrikeWemmbuMod.getRemainingCooldown(player);
                    source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cYou must wait " + OrbitalStrikeWemmbuMod.formatCooldownTime(remaining) + " before using this command again!")));
                    return 0;
                }
                double maxDistance = 500.0;
                class_239 hitResult = player.method_5745(maxDistance, 0.0f, false);
                if (hitResult.method_17783() != class_239.class_240.field_1332) {
                    source.method_9213((class_2561)class_2561.method_43470((String)("No block in crosshair within " + maxDistance + " blocks.")));
                    return 0;
                }
                class_2338 pos = ((class_3965)hitResult).method_17777();
                int x = pos.method_10263();
                int z = pos.method_10260();
                source.method_9211().execute(() -> {
                    class_3218 world = source.method_9225();
                    int groundY = pos.method_10264();
                    if ("nuke".equalsIgnoreCase(payload)) {
                        OrbitalStrikeWemmbuMod.summonNuke((class_1937)world, x, groundY + 72, z, 13);
                    } else if ("stab".equalsIgnoreCase(payload)) {
                        OrbitalStrikeWemmbuMod.summonStab((class_1937)world, x, z, groundY);
                    } else {
                        source.method_9213((class_2561)class_2561.method_43470((String)("Unknown payload: " + payload)));
                    }
                });
                OrbitalStrikeWemmbuMod.setCooldown(player);
                return 1;
            })).then(class_2170.method_9244((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)32)).executes(ctx -> {
                String payload = StringArgumentType.getString((CommandContext)ctx, (String)"payload");
                int size = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"size");
                class_2168 source = (class_2168)ctx.getSource();
                class_3222 player = source.method_9207();
                if (OrbitalStrikeWemmbuMod.isOnCooldown(player)) {
                    long remaining = OrbitalStrikeWemmbuMod.getRemainingCooldown(player);
                    source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cYou must wait " + OrbitalStrikeWemmbuMod.formatCooldownTime(remaining) + " before using this command again!")));
                    return 0;
                }
                double maxDistance = 500.0;
                class_239 hitResult = player.method_5745(maxDistance, 0.0f, false);
                if (hitResult.method_17783() != class_239.class_240.field_1332) {
                    source.method_9213((class_2561)class_2561.method_43470((String)("No block in crosshair within " + maxDistance + " blocks.")));
                    return 0;
                }
                class_2338 pos = ((class_3965)hitResult).method_17777();
                int x = pos.method_10263();
                int z = pos.method_10260();
                source.method_9211().execute(() -> {
                    class_3218 world = source.method_9225();
                    int groundY = pos.method_10264();
                    if ("nuke".equalsIgnoreCase(payload)) {
                        OrbitalStrikeWemmbuMod.summonNuke((class_1937)world, x, groundY + 72, z, size);
                    } else if ("stab".equalsIgnoreCase(payload)) {
                        OrbitalStrikeWemmbuMod.summonStab((class_1937)world, x, z, groundY);
                    } else {
                        source.method_9213((class_2561)class_2561.method_43470((String)("Unknown payload: " + payload)));
                    }
                });
                OrbitalStrikeWemmbuMod.setCooldown(player);
                return 1;
            }))))).then(class_2170.method_9244((String)"payload", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> OrbitalStrikeWemmbuMod.suggest(Arrays.asList("nuke", "stab"), builder)).then(class_2170.method_9244((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"y", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> OrbitalStrikeWemmbuMod.executeStrike((CommandContext<class_2168>)ctx, null, null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"world", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> OrbitalStrikeWemmbuMod.suggest(Arrays.asList("overworld", "nether", "end", "world", "world_nether", "world_the_end"), builder)).executes(ctx -> OrbitalStrikeWemmbuMod.executeStrike((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"world"), null))).then(class_2170.method_9244((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)32)).executes(ctx -> OrbitalStrikeWemmbuMod.executeStrike((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"world"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"size")))))).then(class_2170.method_9244((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)32)).executes(ctx -> OrbitalStrikeWemmbuMod.executeStrike((CommandContext<class_2168>)ctx, null, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"size")))))))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"os").requires(source -> {
                try {
                    class_3222 player = source.method_9207();
                    return OrbitalStrikeWemmbuMod.isAuthorized(player);
                }
                catch (Exception e) {
                    return source.method_9259(2);
                }
            })).executes(ctx -> {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7cUsage: /orbitalstrike <nuke|stab> <x> <y> <z> [world] [size]\n\u00a7cUsage: /orbitalstrike crosshair <nuke|stab> [size]"), false);
                return 1;
            })).redirect(dispatcher.getRoot().getChild("orbitalstrike")));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"strike").requires(source -> {
                try {
                    class_3222 player = source.method_9207();
                    return OrbitalStrikeWemmbuMod.isAuthorized(player);
                }
                catch (Exception e) {
                    return source.method_9259(2);
                }
            })).executes(ctx -> {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7cUsage: /orbitalstrike <nuke|stab> <x> <y> <z> [world] [size]\n\u00a7cUsage: /orbitalstrike crosshair <nuke|stab> [size]"), false);
                return 1;
            })).redirect(dispatcher.getRoot().getChild("orbitalstrike")));
        });
    }

    private static int executeStrike(CommandContext<class_2168> ctx, String worldName, Integer size) {
        class_3218 world;
        String payload = StringArgumentType.getString(ctx, (String)"payload");
        int x = IntegerArgumentType.getInteger(ctx, (String)"x");
        int y = IntegerArgumentType.getInteger(ctx, (String)"y");
        int z = IntegerArgumentType.getInteger(ctx, (String)"z");
        class_2168 source = (class_2168)ctx.getSource();
        try {
            class_3222 player = source.method_9207();
            if (OrbitalStrikeWemmbuMod.isOnCooldown(player)) {
                long remaining = OrbitalStrikeWemmbuMod.getRemainingCooldown(player);
                source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cYou must wait " + OrbitalStrikeWemmbuMod.formatCooldownTime(remaining) + " before using this command again!")));
                return 0;
            }
        }
        catch (Exception player) {
            // empty catch block
        }
        if (worldName != null) {
            world = OrbitalStrikeWemmbuMod.parseWorld(source.method_9211(), worldName);
            if (world == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cWorld not found: " + worldName)));
                return 0;
            }
        } else {
            world = source.method_9225();
        }
        int finalSize = size != null ? size : 13;
        source.method_9211().execute(() -> OrbitalStrikeWemmbuMod.lambda$executeStrike$26(payload, (class_1937)world, x, y, z, finalSize, source));
        try {
            class_3222 player = source.method_9207();
            OrbitalStrikeWemmbuMod.setCooldown(player);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    private static class_1937 parseWorld(MinecraftServer server, String worldName) {
        switch (worldName.toLowerCase()) {
            case "overworld": 
            case "world": {
                return server.method_30002();
            }
            case "nether": 
            case "the_nether": 
            case "world_nether": {
                return server.method_3847(class_1937.field_25180);
            }
            case "end": 
            case "the_end": 
            case "world_the_end": {
                return server.method_3847(class_1937.field_25181);
            }
        }
        for (class_3218 world : server.method_3738()) {
            if (!world.method_27983().method_29177().method_12832().equals(worldName)) continue;
            return world;
        }
        return null;
    }

    private static void authorize(class_3222 player, int seconds) {
        long expiryTime = System.currentTimeMillis() + (long)seconds * 1000L;
        authorizations.put(player.method_5667(), expiryTime);
    }

    private static boolean isAuthorized(class_3222 player) {
        if (player.method_64475(2)) {
            return true;
        }
        UUID playerId = player.method_5667();
        if (!authorizations.containsKey(playerId)) {
            return false;
        }
        long expiryTime = authorizations.get(playerId);
        long currentTime = System.currentTimeMillis();
        if (currentTime >= expiryTime) {
            authorizations.remove(playerId);
            return false;
        }
        return true;
    }

    private static boolean isOnCooldown(class_3222 player) {
        if (!player.method_5477().getString().equalsIgnoreCase(COOLDOWN_PLAYER)) {
            return false;
        }
        UUID playerId = player.method_5667();
        if (!cooldowns.containsKey(playerId)) {
            return false;
        }
        long lastUsed = cooldowns.get(playerId);
        long currentTime = System.currentTimeMillis();
        long elapsed = currentTime - lastUsed;
        if (elapsed >= 1000L) {
            cooldowns.remove(playerId);
            return false;
        }
        return true;
    }

    private static long getRemainingCooldown(class_3222 player) {
        if (!player.method_5477().getString().equalsIgnoreCase(COOLDOWN_PLAYER)) {
            return 0L;
        }
        UUID playerId = player.method_5667();
        if (!cooldowns.containsKey(playerId)) {
            return 0L;
        }
        long lastUsed = cooldowns.get(playerId);
        long currentTime = System.currentTimeMillis();
        long elapsed = currentTime - lastUsed;
        if (elapsed >= 1000L) {
            cooldowns.remove(playerId);
            return 0L;
        }
        return (1000L - elapsed) / 1000L;
    }

    private static void setCooldown(class_3222 player) {
        if (!player.method_5477().getString().equalsIgnoreCase(COOLDOWN_PLAYER)) {
            return;
        }
        cooldowns.put(player.method_5667(), System.currentTimeMillis());
    }

    private static String formatTime(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        if (hours > 0L) {
            return String.format("%d:%02d:%02d", hours, minutes, secs);
        }
        return String.format("%d:%02d", minutes, secs);
    }

    private static String formatCooldownTime(long seconds) {
        long minutes = seconds / 60L;
        long secs = seconds % 60L;
        return String.format("%d:%02d", minutes, secs);
    }

    public static void summonNuke(class_1937 world, int centerX, int centerY, int centerZ, int numRings) {
        int baseFuse = 80;
        int delayBetweenRings = 0;
        double gravity = -0.03;
        double velocityMultiplier = 2.1;
        int[] radii = new int[numRings];
        if (numRings <= 5) {
            for (int i = 0; i < numRings; ++i) {
                radii[i] = i == 0 ? 1 : (i == 1 ? 5 : 10 + (i - 2) * 10);
            }
        } else {
            int[] baseRadii = new int[]{1, 5, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 130, 140};
            if (numRings <= 16) {
                System.arraycopy(baseRadii, 0, radii, 0, numRings);
            } else {
                System.arraycopy(baseRadii, 0, radii, 0, 16);
                for (int i = 16; i < numRings; ++i) {
                    radii[i] = 140 + (i - 15) * 10;
                }
            }
        }
        for (int ringIndex = 0; ringIndex < radii.length; ++ringIndex) {
            int r = radii[ringIndex];
            int tntsPerRing = Math.min(100, Math.max(12, r * 2));
            int fuse = baseFuse + ringIndex * delayBetweenRings;
            for (int i = 0; i < tntsPerRing; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)tntsPerRing;
                double dx = Math.cos(angle);
                double dz = Math.sin(angle);
                double spawnX = (double)centerX + 0.5;
                double spawnZ = (double)centerZ + 0.5;
                double travelDist = r;
                double vx = dx * (travelDist / (double)fuse) * velocityMultiplier;
                double vz = dz * (travelDist / (double)fuse) * velocityMultiplier;
                class_1541 tnt = new class_1541(world, spawnX, (double)centerY, spawnZ, null);
                tnt.method_6967(fuse);
                tnt.method_18800(vx, gravity, vz);
                world.method_8649((class_1297)tnt);
            }
        }
    }

    public static void summonStab(class_1937 world, int centerX, int centerZ, int groundY) {
        int startY = 256;
        int endY = -64;
        int depth = startY - endY + 1;
        for (int i = 0; i < depth; ++i) {
            int y = startY - i;
            class_1541 tnt = new class_1541(world, (double)centerX + 0.5, (double)y, (double)centerZ + 0.5, null);
            tnt.method_6967(0);
            world.method_8649((class_1297)tnt);
        }
    }

    private static /* synthetic */ void lambda$executeStrike$26(String payload, class_1937 world, int x, int y, int z, int finalSize, class_2168 source) {
        if ("nuke".equalsIgnoreCase(payload)) {
            OrbitalStrikeWemmbuMod.summonNuke(world, x, y + 72, z, finalSize);
        } else if ("stab".equalsIgnoreCase(payload)) {
            OrbitalStrikeWemmbuMod.summonStab(world, x, z, y);
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)("Unknown payload: " + payload)));
        }
    }
}

