/*
 * Decompiled with CFR 0.152.
 */
package com.zack858.orbitalstrike;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class CooldownManager {
    private static final String COOLDOWN_PLAYER = "Rockydogyt9911";
    private static final long COOLDOWN_TIME = 1000L;
    private static final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();

    public static void clearAllCooldowns() {
        cooldowns.clear();
    }

    public static boolean isOnCooldown(Player player) {
        if (!player.getName().equalsIgnoreCase(COOLDOWN_PLAYER)) {
            return false;
        }
        UUID playerId = player.getUniqueId();
        if (!cooldowns.containsKey(playerId)) {
            return false;
        }
        long lastUsed = cooldowns.get(playerId);
        long currentTime = System.currentTimeMillis();
        long elapsed = currentTime - lastUsed;
        if (elapsed >= 1000L) {
            cooldowns.remove(playerId);
            return false;
        }
        return true;
    }

    public static long getRemainingCooldown(Player player) {
        if (!player.getName().equalsIgnoreCase(COOLDOWN_PLAYER)) {
            return 0L;
        }
        UUID playerId = player.getUniqueId();
        if (!cooldowns.containsKey(playerId)) {
            return 0L;
        }
        long lastUsed = cooldowns.get(playerId);
        long currentTime = System.currentTimeMillis();
        long elapsed = currentTime - lastUsed;
        if (elapsed >= 1000L) {
            cooldowns.remove(playerId);
            return 0L;
        }
        return (1000L - elapsed) / 1000L;
    }

    public static void setCooldown(Player player) {
        if (!player.getName().equalsIgnoreCase(COOLDOWN_PLAYER)) {
            return;
        }
        cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
    }

    public static String formatTime(long seconds) {
        long minutes = seconds / 60L;
        long secs = seconds % 60L;
        return String.format("%d:%02d", minutes, secs);
    }
}

