/*
 * Decompiled with CFR 0.152.
 */
package com.zack858.orbitalstrike;

import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.util.Vector;

public class OrbitalStrikeLogic {
    public static void summonNuke(World world, int centerX, int centerY, int centerZ, int numRings) {
        int baseFuse = 100;
        int delayBetweenRings = 0;
        double gravity = -0.03;
        double velocityMultiplier = 2.1;
        int[] radii = new int[numRings];
        if (numRings <= 5) {
            for (int i = 0; i < numRings; ++i) {
                radii[i] = i == 0 ? 1 : (i == 1 ? 5 : 10 + (i - 2) * 10);
            }
        } else {
            int[] baseRadii = new int[]{1, 5, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 130, 140};
            if (numRings <= 16) {
                System.arraycopy(baseRadii, 0, radii, 0, numRings);
            } else {
                System.arraycopy(baseRadii, 0, radii, 0, 16);
                for (int i = 16; i < numRings; ++i) {
                    radii[i] = 140 + (i - 15) * 10;
                }
            }
        }
        for (int ringIndex = 0; ringIndex < radii.length; ++ringIndex) {
            int r = radii[ringIndex];
            int tntsPerRing = Math.min(100, Math.max(12, r * 2));
            int fuse = baseFuse + ringIndex * delayBetweenRings;
            for (int i = 0; i < tntsPerRing; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)tntsPerRing;
                double dx = Math.cos(angle);
                double dz = Math.sin(angle);
                double spawnX = (double)centerX + 0.5;
                double spawnZ = (double)centerZ + 0.5;
                double travelDist = r;
                double vx = dx * (travelDist / (double)fuse) * velocityMultiplier;
                double vz = dz * (travelDist / (double)fuse) * velocityMultiplier;
                Location spawnLoc = new Location(world, spawnX, (double)centerY, spawnZ);
                TNTPrimed tnt = (TNTPrimed)world.spawn(spawnLoc, TNTPrimed.class);
                tnt.setFuseTicks(fuse);
                tnt.setVelocity(new Vector(vx, gravity, vz));
            }
        }
    }

    public static void summonStab(World world, int centerX, int centerZ, int groundY) {
        int startY = 135;
        int endY = -64;
        int depth = startY - endY + 1;
        for (int i = 0; i < depth; ++i) {
            int y = startY - i;
            Location spawnLoc = new Location(world, (double)centerX + 0.5, (double)y, (double)centerZ + 0.5);
            TNTPrimed tnt = (TNTPrimed)world.spawn(spawnLoc, TNTPrimed.class);
            tnt.setFuseTicks(0);
        }
    }
}

