/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.processor;

import com.bawnorton.configurable.io.FileType;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public record ConfigurableSettings(String name, FileType fileType, NamingPolicy namingPolicy) {
    public static ConfigurableSettings fromProperties(Properties properties) {
        String name = properties.getProperty("name");
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Property 'name' must be specified and cannot be empty.");
        }
        FileType type = ConfigurableSettings.getEnumProperty(properties, "type", FileType.class, FileType.JSON);
        NamingPolicy namingPolicy = ConfigurableSettings.getEnumProperty(properties, "naming_policy", NamingPolicy.class, NamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        Set<String> knownProperties = Set.of("name", "type", "naming_policy");
        for (String key : properties.stringPropertyNames()) {
            if (knownProperties.contains(key)) continue;
            throw new IllegalArgumentException("Unknown property '" + key + "' in configurable.properties. Known properties are: " + String.valueOf(knownProperties));
        }
        return new ConfigurableSettings(name, type, namingPolicy);
    }

    @NotNull
    private static <T extends Enum<T>> T getEnumProperty(Properties properties, String name, Class<T> enumClass, T defaultValue) {
        T enumValue;
        String enumStr = properties.getProperty(name);
        if (enumStr == null) {
            return defaultValue;
        }
        try {
            enumValue = Enum.valueOf(enumClass, enumStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            StringBuilder validTypes = new StringBuilder();
            for (Enum policy : (Enum[])enumClass.getEnumConstants()) {
                validTypes.append(policy.name()).append(", ");
            }
            validTypes.setLength(validTypes.length() - 2);
            throw new IllegalArgumentException("Invalid " + name + " '" + enumStr + "'. Valid values are \"" + String.valueOf(validTypes) + "\".", e);
        }
        return enumValue;
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.setProperty("name", this.name);
        properties.setProperty("type", this.fileType.name());
        properties.setProperty("naming_policy", this.namingPolicy.name());
        return properties;
    }

    public static enum NamingPolicy {
        IDENTITY(UnaryOperator.identity()),
        UPPER_CASE_WITH_UNDERSCORES(s -> NamingPolicy.separateCamelCase(s, '_').toUpperCase(Locale.ENGLISH)),
        LOWER_CASE_WITH_UNDERSCORES(s -> NamingPolicy.separateCamelCase(s, '_').toLowerCase(Locale.ENGLISH)),
        LOWER_CASE_WITH_DASHES(s -> NamingPolicy.separateCamelCase(s, '-').toLowerCase(Locale.ENGLISH)),
        LOWER_CASE_WITH_DOTS(s -> NamingPolicy.separateCamelCase(s, '.').toLowerCase(Locale.ENGLISH));

        private final UnaryOperator<String> formatter;

        private NamingPolicy(UnaryOperator<String> formatter) {
            this.formatter = formatter;
        }

        public String format(String name) {
            return (String)this.formatter.apply(name);
        }

        private static String separateCamelCase(String name, char separator) {
            StringBuilder result = new StringBuilder();
            int length = name.length();
            for (int i = 0; i < length; ++i) {
                char character = name.charAt(i);
                if (Character.isUpperCase(character) && !result.isEmpty()) {
                    result.append(separator);
                }
                result.append(character);
            }
            return result.toString();
        }
    }
}

