/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.io;

import com.bawnorton.configurable.ConfigurableMain;
import com.bawnorton.configurable.io.FileType;
import com.bawnorton.configurable.io.IllegalConfigException;
import com.bawnorton.configurable.io.SerialisationHelper;
import com.bawnorton.configurable.reference.FieldReference;
import com.bawnorton.configurable.reference.validator.FieldValidator;
import com.bawnorton.configurable.util.GenericType;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.core.io.IndentStyle;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.electronwill.nightconfig.toml.TomlParser;
import com.electronwill.nightconfig.toml.TomlWriter;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import org.quiltmc.parsers.json.JsonWriter;
import org.quiltmc.parsers.json.gson.GsonReader;

public class SaveLoader {
    private final Path configPath;
    private final FileType fileType;

    public SaveLoader(Path configPath, FileType fileType) {
        this.configPath = configPath;
        this.fileType = fileType;
    }

    public void load(List<FieldReference<?>> references) {
        if (!Files.exists(this.configPath, new LinkOption[0]) || references.isEmpty()) {
            return;
        }
        List<FieldReference<Object>> castedReferences = references.stream().map(ref -> ref).toList();
        switch (this.fileType) {
            case JSON: {
                this.loadJson(castedReferences);
                break;
            }
            case TOML: {
                this.loadToml(castedReferences);
            }
        }
    }

    public void save(List<FieldReference<?>> references) {
        if (references.isEmpty()) {
            return;
        }
        List<FieldReference<Object>> castedReferences = references.stream().map(ref -> ref).toList();
        switch (this.fileType) {
            case JSON: {
                this.saveJson(castedReferences);
                break;
            }
            case TOML: {
                this.saveToml(castedReferences);
            }
        }
    }

    private void loadJson(List<FieldReference<Object>> references) {
        try (GsonReader reader = new GsonReader(org.quiltmc.parsers.json.JsonReader.json5((Path)this.configPath));){
            JsonElement tree = JsonParser.parseReader((JsonReader)reader);
            for (FieldReference<Object> ref : references) {
                Object value;
                JsonElement element = this.extractFieldFromJsonTree(tree, ref.group(), ref.name());
                if (element == null) {
                    this.handleMissingValue(ref);
                    continue;
                }
                try {
                    value = SerialisationHelper.interpret(element, ref.genericType());
                }
                catch (Exception e) {
                    ConfigurableMain.LOGGER.error("Failed to interpret value for JSON field '{}'", (Object)ref.fullName());
                    ConfigurableMain.LOGGER.debug("Exception details:", (Throwable)e);
                    this.handleInvalidValue(ref, null);
                    continue;
                }
                if (value == null) {
                    this.handleInvalidValue(ref, null);
                    continue;
                }
                FieldValidator<Object> validator = ref.validator().fieldValidator();
                if (validator != null && !validator.isValid(value)) {
                    this.handleInvalidValue(ref, value);
                    continue;
                }
                ref.set(value);
            }
        }
        catch (IOException e) {
            ConfigurableMain.LOGGER.error("Failed to load JSON config from '{}'", (Object)this.configPath.getFileName(), (Object)e);
        }
    }

    private JsonElement extractFieldFromJsonTree(JsonElement current, String group, String name) {
        JsonElement leaf;
        JsonElement node = current;
        if (group != null) {
            for (String part : group.split("\\.")) {
                if ((node = node.getAsJsonObject().get(part)) != null && node.isJsonObject()) continue;
                return null;
            }
        }
        boolean exists = node != null && node.getAsJsonObject().has(name);
        JsonElement jsonElement = leaf = exists ? node.getAsJsonObject().get(name) : null;
        if (leaf == null || leaf.isJsonObject()) {
            return null;
        }
        return leaf;
    }

    private void loadToml(List<FieldReference<Object>> references) {
        try {
            TomlParser tomlParser = new TomlParser();
            CommentedConfig parsed = (CommentedConfig)tomlParser.parse(this.configPath, FileNotFoundAction.CREATE_EMPTY);
            for (FieldReference<Object> ref : references) {
                Object value;
                GenericType expectedType = ref.genericType();
                String coordinate = ref.group() == null ? ref.name() : "%s.%s".formatted(ref.group(), ref.name());
                try {
                    value = SerialisationHelper.interpret(parsed, coordinate, expectedType);
                }
                catch (Exception e) {
                    ConfigurableMain.LOGGER.error("Failed to interpret value for TOML field '{}'", (Object)ref.fullName());
                    ConfigurableMain.LOGGER.debug("Exception details:", (Throwable)e);
                    this.handleInvalidValue(ref, null);
                    continue;
                }
                if (value == null) {
                    this.handleMissingValue(ref);
                    continue;
                }
                FieldValidator<Object> validator = ref.validator().fieldValidator();
                if (validator != null && !validator.isValid(value)) {
                    this.handleInvalidValue(ref, value);
                    continue;
                }
                ref.set(value);
            }
        }
        catch (ParsingException | ClassCastException e) {
            ConfigurableMain.LOGGER.error("Failed to load TOML config from '{}'", (Object)this.configPath.getFileName(), (Object)e);
        }
    }

    private void handleMissingValue(FieldReference<Object> ref) {
        if (!ref.validator().fallback()) {
            String message = "Field '%s' was expected but was not found.".formatted(ref.fullName());
            throw new IllegalConfigException(this.configPath.getFileName().toString(), message);
        }
        ConfigurableMain.LOGGER.warn(ref.validator().messageProvider().getMessage(null));
        ref.set(ref.validator().defaultSupplier().get());
    }

    private void handleInvalidValue(FieldReference<Object> ref, Object value) {
        String message = ref.validator().messageProvider().getMessage(value);
        if (!ref.validator().fallback()) {
            throw new IllegalConfigException(this.configPath.getFileName().toString(), message);
        }
        ConfigurableMain.LOGGER.warn(message);
        ref.set(ref.validator().defaultSupplier().get());
    }

    private void saveJson(List<FieldReference<Object>> references) {
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            try {
                Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
                Files.createFile(this.configPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                ConfigurableMain.LOGGER.error("Failed to create JSON config file '{}'", (Object)this.configPath.getFileName(), (Object)e);
                return;
            }
        }
        try (JsonWriter writer = JsonWriter.json5((Path)this.configPath);){
            writer.beginObject();
            String currentGroup = null;
            for (FieldReference<Object> ref : references) {
                if (ref.comment() != null) {
                    writer.comment(ref.comment());
                }
                currentGroup = this.changeGroupPath(writer, ref.group(), currentGroup);
                writer.name(ref.name());
                this.writeValue(writer, ref.get());
            }
            if (currentGroup != null) {
                for (String ignored : currentGroup.split("\\.")) {
                    writer.endObject();
                }
            }
            writer.endObject();
            writer.flush();
        }
        catch (IOException e) {
            ConfigurableMain.LOGGER.error("Failed to save JSON config to '{}'", (Object)this.configPath.getFileName(), (Object)e);
        }
    }

    private void writeValue(JsonWriter writer, Object value) throws IOException {
        if (value == null) {
            writer.nullValue();
        } else if (value.getClass().isArray()) {
            writer.beginArray();
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                this.writeValue(writer, Array.get(value, i));
            }
            writer.endArray();
        } else if (value instanceof List) {
            List list = (List)value;
            writer.beginArray();
            for (Object item : list) {
                this.writeValue(writer, item);
            }
            writer.endArray();
        } else {
            Object object = value;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Number.class, Boolean.class, Character.class}, (Object)object2, n)) {
                case 0: {
                    String str = (String)object2;
                    writer.value(str);
                    break;
                }
                case 1: {
                    Number n2 = (Number)object2;
                    writer.value(n2);
                    break;
                }
                case 2: {
                    Boolean b = (Boolean)object2;
                    writer.value(b);
                    break;
                }
                case 3: {
                    Character c = (Character)object2;
                    writer.value(String.valueOf(c));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type: " + value.getClass().getName());
                }
            }
        }
    }

    private String changeGroupPath(JsonWriter writer, String newGroup, String currentGroup) throws IOException {
        String[] parts;
        if (Objects.equals(newGroup, currentGroup)) {
            return currentGroup;
        }
        if (newGroup == null) {
            String[] parts2 = currentGroup.split("\\.");
            for (int i = parts2.length - 1; i >= 0; --i) {
                writer.endObject();
            }
            return null;
        }
        if (currentGroup != null) {
            int i;
            int common;
            String[] currentParts = currentGroup.split("\\.");
            String[] newParts = newGroup.split("\\.");
            for (common = 0; common < currentParts.length && common < newParts.length && currentParts[common].equals(newParts[common]); ++common) {
            }
            for (i = currentParts.length - 1; i >= common; --i) {
                writer.endObject();
            }
            for (i = common; i < newParts.length; ++i) {
                writer.name(newParts[i]).beginObject();
            }
            return newGroup;
        }
        for (String part : parts = newGroup.split("\\.")) {
            writer.name(part).beginObject();
        }
        return newGroup;
    }

    private void saveToml(List<FieldReference<Object>> references) {
        try {
            TomlWriter tomlWriter = new TomlWriter();
            tomlWriter.setIndent(IndentStyle.TABS);
            CommentedConfig config = TomlFormat.newConfig();
            for (FieldReference<Object> ref : references) {
                Object value;
                String path;
                String string = path = ref.group() == null ? ref.name() : "%s.%s".formatted(ref.group(), ref.name());
                if (ref.comment() != null) {
                    config.setComment(path, " %s".formatted(ref.comment()));
                }
                if ((value = SerialisationHelper.safeForToml(ref.get())) == null) continue;
                config.set(path, value);
            }
            tomlWriter.write((UnmodifiableConfig)config.unmodifiable(), this.configPath, WritingMode.REPLACE);
        }
        catch (WritingException e) {
            ConfigurableMain.LOGGER.error("Failed to save TOML config to '{}'", (Object)this.configPath.getFileName(), (Object)e);
        }
    }
}

