/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.io;

import com.bawnorton.configurable.util.GenericType;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_9135;

public class SerialisationHelper {
    public static Object interpret(JsonElement element, GenericType genericHolder) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        Class<?> expectedType = genericHolder.type();
        if (genericHolder.isRaw()) {
            if (expectedType == String.class) {
                return element.getAsString();
            }
            if (expectedType == Integer.class || expectedType == Integer.TYPE) {
                return element.getAsInt();
            }
            if (expectedType == Long.class || expectedType == Long.TYPE) {
                return element.getAsLong();
            }
            if (expectedType == Double.class || expectedType == Double.TYPE) {
                return element.getAsDouble();
            }
            if (expectedType == Boolean.class || expectedType == Boolean.TYPE) {
                return element.getAsBoolean();
            }
            if (expectedType == Float.class || expectedType == Float.TYPE) {
                return Float.valueOf(element.getAsFloat());
            }
            if (expectedType == Byte.class || expectedType == Byte.TYPE) {
                return (byte)element.getAsInt();
            }
            if (expectedType == Short.class || expectedType == Short.TYPE) {
                return (short)element.getAsInt();
            }
            if (expectedType == Character.class || expectedType == Character.TYPE) {
                String str = element.getAsString();
                if (str.length() != 1) {
                    throw new IllegalArgumentException("Expected a single character for type char, but got: %s".formatted(str));
                }
                return Character.valueOf(str.charAt(0));
            }
            if (expectedType.isEnum()) {
                return Enum.valueOf(expectedType, element.getAsString());
            }
            if (expectedType.isArray()) {
                if (!element.isJsonArray()) {
                    throw new IllegalArgumentException("Expected a JSON array for type array, but got: %s".formatted(element));
                }
                JsonArray jsonArray = element.getAsJsonArray();
                int size = jsonArray.size();
                Class<?> componentType = expectedType.getComponentType();
                Object array = Array.newInstance(componentType, size);
                for (int i = 0; i < size; ++i) {
                    JsonElement jsonElement = jsonArray.get(i);
                    Object value = SerialisationHelper.interpret(jsonElement, new GenericType(componentType, new GenericType[0]));
                    Array.set(array, i, value);
                }
                return array;
            }
            throw new IllegalArgumentException("Unsupported type: %s".formatted(expectedType.getName()));
        }
        GenericType[] genericTypes = genericHolder.genericTypes();
        if (genericTypes.length == 1) {
            GenericType genericType = genericTypes[0];
            if (List.class.isAssignableFrom(expectedType)) {
                if (!element.isJsonArray()) {
                    throw new IllegalArgumentException("Expected a JSON array for type List, but got: %s".formatted(element));
                }
                return element.getAsJsonArray().asList().stream().map(item -> SerialisationHelper.interpret(item, genericType)).toList();
            }
            throw new IllegalArgumentException("Unsupported generic type: %s".formatted(expectedType.getName()));
        }
        throw new IllegalArgumentException("Generic types with more than one parameter are not supported.");
    }

    public static Object interpret(CommentedConfig toml, String path, GenericType genericHolder) {
        if (toml == null || !toml.contains(path)) {
            return null;
        }
        Class<?> expectedType = genericHolder.type();
        if (genericHolder.isRaw()) {
            if (expectedType == String.class) {
                return toml.get(path);
            }
            if (expectedType == Integer.class || expectedType == Integer.TYPE) {
                return ((Number)toml.get(path)).intValue();
            }
            if (expectedType == Long.class || expectedType == Long.TYPE) {
                return toml.getLong(path);
            }
            if (expectedType == Double.class || expectedType == Double.TYPE) {
                return ((Number)toml.get(path)).doubleValue();
            }
            if (expectedType == Boolean.class || expectedType == Boolean.TYPE) {
                return toml.get(path);
            }
            if (expectedType == Float.class || expectedType == Float.TYPE) {
                return Float.valueOf(((Number)toml.get(path)).floatValue());
            }
            if (expectedType == Byte.class || expectedType == Byte.TYPE) {
                return toml.getByte(path);
            }
            if (expectedType == Short.class || expectedType == Short.TYPE) {
                return toml.getShort(path);
            }
            if (expectedType == Character.class || expectedType == Character.TYPE) {
                return Character.valueOf(((String)toml.get(path)).charAt(0));
            }
            if (expectedType.isEnum()) {
                return toml.getEnum(path, expectedType);
            }
            if (expectedType.isArray()) {
                List list = (List)toml.get(path);
                if (list == null) {
                    return null;
                }
                Class<?> componentType = expectedType.getComponentType();
                int size = list.size();
                Object array = Array.newInstance(componentType, size);
                for (int i = 0; i < size; ++i) {
                    Object item = list.get(i);
                    Object value = SerialisationHelper.interpret(item, new GenericType(componentType, new GenericType[0]));
                    Array.set(array, i, value);
                }
                return array;
            }
            throw new IllegalArgumentException("Unsupported type: %s".formatted(expectedType.getName()));
        }
        GenericType[] genericTypes = genericHolder.genericTypes();
        if (genericTypes.length == 1) {
            GenericType genericType = genericTypes[0];
            if (List.class.isAssignableFrom(expectedType)) {
                List list = (List)toml.get(path);
                if (list == null) {
                    return null;
                }
                ArrayList<Object> interpretedList = new ArrayList<Object>(list.size());
                for (Object item : list) {
                    interpretedList.add(SerialisationHelper.interpret(item, genericType));
                }
                return interpretedList;
            }
            throw new IllegalArgumentException("Unsupported generic type: %s".formatted(expectedType.getName()));
        }
        throw new IllegalArgumentException("Generic types with more than one parameter are not supported.");
    }

    public static Object interpret(Object item, GenericType genericHolder) {
        if (item == null) {
            return null;
        }
        Class<?> expectedType = genericHolder.type();
        if (genericHolder.isRaw()) {
            if (expectedType == String.class) {
                return item.toString();
            }
            if (expectedType == Integer.class || expectedType == Integer.TYPE) {
                return ((Number)item).intValue();
            }
            if (expectedType == Long.class || expectedType == Long.TYPE) {
                return ((Number)item).longValue();
            }
            if (expectedType == Double.class || expectedType == Double.TYPE) {
                return ((Number)item).doubleValue();
            }
            if (expectedType == Boolean.class || expectedType == Boolean.TYPE) {
                return item;
            }
            if (expectedType == Float.class || expectedType == Float.TYPE) {
                return Float.valueOf(((Number)item).floatValue());
            }
            if (expectedType == Byte.class || expectedType == Byte.TYPE) {
                return ((Number)item).byteValue();
            }
            if (expectedType == Short.class || expectedType == Short.TYPE) {
                return ((Number)item).shortValue();
            }
            if (expectedType == Character.class || expectedType == Character.TYPE) {
                String str = item.toString();
                if (str.length() != 1) {
                    throw new IllegalArgumentException("Expected a single character for type char, but got: %s".formatted(str));
                }
                return Character.valueOf(str.charAt(0));
            }
            if (expectedType.isEnum()) {
                return Enum.valueOf(expectedType, item.toString());
            }
            if (expectedType.isArray()) {
                if (!(item instanceof List)) {
                    throw new IllegalArgumentException("Expected a List for type array, but got: %s".formatted(item));
                }
                List list = (List)item;
                Class<?> componentType = expectedType.getComponentType();
                int size = list.size();
                Object array = Array.newInstance(componentType, size);
                for (int i = 0; i < size; ++i) {
                    Object value = SerialisationHelper.interpret(list.get(i), new GenericType(componentType, new GenericType[0]));
                    Array.set(array, i, value);
                }
                return array;
            }
            throw new IllegalArgumentException("Unsupported type: %s".formatted(expectedType.getName()));
        }
        GenericType[] genericTypes = genericHolder.genericTypes();
        if (genericTypes.length == 1) {
            GenericType genericType = genericTypes[0];
            if (List.class.isAssignableFrom(expectedType)) {
                if (!(item instanceof List)) {
                    throw new IllegalArgumentException("Expected a List for type List, but got: %s".formatted(item));
                }
                List list = (List)item;
                ArrayList<Object> interpretedList = new ArrayList<Object>(list.size());
                for (Object listItem : list) {
                    interpretedList.add(SerialisationHelper.interpret(listItem, genericType));
                }
                return interpretedList;
            }
            throw new IllegalArgumentException("Unsupported generic type: %s".formatted(expectedType.getName()));
        }
        throw new IllegalArgumentException("Generic types with more than one parameter are not supported.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void encode(ByteBuf byteBuf, Object value, GenericType genericHolder) {
        if (value == null) {
            class_9135.field_48550.encode((Object)byteBuf, (Object)-1);
            return;
        }
        class_9135.field_48550.encode((Object)byteBuf, (Object)0);
        Class<?> type = genericHolder.type();
        if (genericHolder.isRaw()) {
            if (type == String.class) {
                class_9135.field_48554.encode((Object)byteBuf, (Object)((String)value));
                return;
            } else if (type == Integer.class || type == Integer.TYPE) {
                class_9135.field_48550.encode((Object)byteBuf, (Object)((Integer)value));
                return;
            } else if (type == Long.class || type == Long.TYPE) {
                class_9135.field_48551.encode((Object)byteBuf, (Object)((Long)value));
                return;
            } else if (type == Double.class || type == Double.TYPE) {
                class_9135.field_48553.encode((Object)byteBuf, (Object)((Double)value));
                return;
            } else if (type == Boolean.class || type == Boolean.TYPE) {
                class_9135.field_48547.encode((Object)byteBuf, (Object)((Boolean)value));
                return;
            } else if (type == Float.class || type == Float.TYPE) {
                class_9135.field_48552.encode((Object)byteBuf, (Object)((Float)value));
                return;
            } else if (type == Byte.class || type == Byte.TYPE) {
                class_9135.field_48548.encode((Object)byteBuf, (Object)((Byte)value));
                return;
            } else if (type == Short.class || type == Short.TYPE) {
                class_9135.field_48549.encode((Object)byteBuf, (Object)((Short)value));
                return;
            } else if (type == Character.class || type == Character.TYPE) {
                class_9135.field_48550.encode((Object)byteBuf, (Object)((Character)value).charValue());
                return;
            } else if (type.isEnum()) {
                class_9135.field_48554.encode((Object)byteBuf, (Object)((Enum)value).name());
                return;
            } else {
                if (!type.isArray()) throw new IllegalArgumentException("Unsupported type: %s".formatted(type.getName()));
                Class<?> componentType = type.getComponentType();
                int length = Array.getLength(value);
                class_9135.field_48550.encode((Object)byteBuf, (Object)length);
                for (int i = 0; i < length; ++i) {
                    Object item = Array.get(value, i);
                    SerialisationHelper.encode(byteBuf, item, new GenericType(componentType, new GenericType[0]));
                }
            }
            return;
        } else {
            GenericType[] genericTypes = genericHolder.genericTypes();
            if (genericTypes.length != 1) throw new IllegalArgumentException("Generic types with more than one parameter are not supported.");
            GenericType genericType = genericTypes[0];
            if (!List.class.isAssignableFrom(type)) throw new IllegalArgumentException("Unsupported generic type: %s".formatted(type.getName()));
            List list = (List)value;
            class_9135.field_48550.encode((Object)byteBuf, (Object)list.size());
            for (Object item : list) {
                SerialisationHelper.encode(byteBuf, item, genericType);
            }
        }
    }

    public static Object interpet(ByteBuf byteBuf, GenericType genericHolder) {
        int nullCheck = (Integer)class_9135.field_48550.decode((Object)byteBuf);
        if (nullCheck == -1) {
            return null;
        }
        if (nullCheck != 0) {
            throw new IllegalArgumentException("Expected a null check value of -1 or 0, but got: %d".formatted(nullCheck));
        }
        Class<?> type = genericHolder.type();
        if (genericHolder.isRaw()) {
            if (type == String.class) {
                return class_9135.field_48554.decode((Object)byteBuf);
            }
            if (type == Integer.class || type == Integer.TYPE) {
                return class_9135.field_48550.decode((Object)byteBuf);
            }
            if (type == Long.class || type == Long.TYPE) {
                return class_9135.field_48551.decode((Object)byteBuf);
            }
            if (type == Double.class || type == Double.TYPE) {
                return class_9135.field_48553.decode((Object)byteBuf);
            }
            if (type == Boolean.class || type == Boolean.TYPE) {
                return class_9135.field_48547.decode((Object)byteBuf);
            }
            if (type == Float.class || type == Float.TYPE) {
                return class_9135.field_48552.decode((Object)byteBuf);
            }
            if (type == Byte.class || type == Byte.TYPE) {
                return class_9135.field_48548.decode((Object)byteBuf);
            }
            if (type == Short.class || type == Short.TYPE) {
                return class_9135.field_48549.decode((Object)byteBuf);
            }
            if (type == Character.class || type == Character.TYPE) {
                int value = (Integer)class_9135.field_48550.decode((Object)byteBuf);
                return Character.valueOf((char)value);
            }
            if (type.isEnum()) {
                String enumName = (String)class_9135.field_48554.decode((Object)byteBuf);
                return Enum.valueOf(type, enumName);
            }
            if (type.isArray()) {
                int length = (Integer)class_9135.field_48550.decode((Object)byteBuf);
                Class<?> componentType = type.getComponentType();
                Object array = Array.newInstance(componentType, length);
                for (int i = 0; i < length; ++i) {
                    Object item = SerialisationHelper.interpet(byteBuf, new GenericType(componentType, new GenericType[0]));
                    Array.set(array, i, item);
                }
                return array;
            }
            throw new IllegalArgumentException("Unsupported type: %s".formatted(type.getName()));
        }
        GenericType[] genericTypes = genericHolder.genericTypes();
        if (genericTypes.length == 1) {
            GenericType genericType = genericTypes[0];
            if (List.class.isAssignableFrom(type)) {
                int size = (Integer)class_9135.field_48550.decode((Object)byteBuf);
                ArrayList<Object> list = new ArrayList<Object>(size);
                for (int i = 0; i < size; ++i) {
                    Object item = SerialisationHelper.interpet(byteBuf, genericType);
                    list.add(item);
                }
                return list;
            }
            throw new IllegalArgumentException("Unsupported generic type: %s".formatted(type.getName()));
        }
        throw new IllegalArgumentException("Generic types with more than one parameter are not supported.");
    }

    public static Object safeForToml(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (type.isArray()) {
            int length = Array.getLength(value);
            ArrayList<Object> asList = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                Object item = Array.get(value, i);
                asList.add(SerialisationHelper.safeForToml(item));
            }
            return asList;
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<Object> safeList = new ArrayList<Object>(list.size());
            for (Object item : list) {
                safeList.add(SerialisationHelper.safeForToml(item));
            }
            return safeList;
        }
        if (type == Character.class) {
            return value.toString();
        }
        return value;
    }
}

