/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.networking;

import com.bawnorton.configurable.ConfigurableLoader;
import com.bawnorton.configurable.ConfigurableMain;
import com.bawnorton.configurable.io.SerialisationHelper;
import com.bawnorton.configurable.reference.FieldReference;
import com.bawnorton.configurable.service.ConfigLoader;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public record SyncConfigPayload(String name, List<FieldReference<?>> fieldReferences) implements class_8710
{
    public static final class_2960 ID = ConfigurableMain.rl("sync_config_payload");
    public static final class_8710.class_9154<SyncConfigPayload> TYPE = new class_8710.class_9154(ID);
    public static final class_9139<ByteBuf, SyncConfigPayload> STREAM_CODEC = class_9139.method_56437(SyncConfigPayload::encode, SyncConfigPayload::decode);

    private static void encode(ByteBuf byteBuf, SyncConfigPayload payload) {
        class_9135.field_48554.encode((Object)byteBuf, (Object)payload.name());
        List<FieldReference> fieldReferences = payload.fieldReferences().stream().filter(FieldReference::doesSync).toList();
        class_9135.field_48550.encode((Object)byteBuf, (Object)fieldReferences.size());
        for (FieldReference fieldReference : fieldReferences) {
            class_9135.field_48554.encode((Object)byteBuf, (Object)fieldReference.fullName());
            Object value = fieldReference.get();
            SerialisationHelper.encode(byteBuf, value, fieldReference.genericType());
        }
    }

    private static SyncConfigPayload decode(ByteBuf byteBuf) {
        String name = (String)class_9135.field_48554.decode((Object)byteBuf);
        if (!ConfigurableLoader.isConfigLoaderPresent(name)) {
            return new SyncConfigPayload(name, List.of());
        }
        ConfigLoader configLoader = ConfigurableLoader.getConfigLoader(name);
        List<FieldReference> expectedFields = configLoader.getFields().stream().filter(FieldReference::doesSync).toList();
        int size = (Integer)class_9135.field_48550.decode((Object)byteBuf);
        if (size != expectedFields.size()) {
            throw new IllegalArgumentException("Expected %d fields, but got %d. There is likely a server-client version mismatch for '%s'".formatted(expectedFields.size(), size, name));
        }
        Map<String, FieldReference> fieldMap = expectedFields.stream().collect(Collectors.toMap(FieldReference::fullName, ref -> ref));
        ArrayList newFieldReferences = new ArrayList();
        for (int i = 0; i < size; ++i) {
            String fullName = (String)class_9135.field_48554.decode((Object)byteBuf);
            FieldReference fieldReference = fieldMap.get(fullName);
            if (fieldReference == null) {
                throw new IllegalArgumentException("Field '%s' not found in config '%s'".formatted(fullName, name));
            }
            Object value = SerialisationHelper.interpet(byteBuf, fieldReference.genericType());
            newFieldReferences.add(FieldReference.builder(ignored -> {
                throw new UnsupportedOperationException("Synthetic networking field reference '%s' for '%s' is read-only".formatted(fullName, name));
            }, () -> value, fieldReference.genericType(), fieldReference.name()).comment(fieldReference.comment()).group(fieldReference.group()).doesSync(fieldReference.doesSync()).validator(fieldReference.validator()).build());
        }
        return new SyncConfigPayload(name, newFieldReferences);
    }

    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public void applyToConfigLoader(ConfigLoader configLoader) {
        List<FieldReference<?>> fields = configLoader.getFields();
        Map<String, FieldReference> fieldMap = fields.stream().filter(FieldReference::doesSync).collect(Collectors.toMap(FieldReference::fullName, ref -> ref));
        for (FieldReference<?> fieldReference : this.fieldReferences) {
            String fieldName = fieldReference.fullName();
            FieldReference matchingField = fieldMap.get(fieldName);
            if (matchingField == null) continue;
            matchingField.set(fieldReference.get(), true);
        }
    }
}

