/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.reference;

import com.bawnorton.configurable.reference.OnSet;
import com.bawnorton.configurable.reference.validator.ValidatorReference;
import com.bawnorton.configurable.util.GenericType;
import java.util.function.Consumer;
import java.util.function.Supplier;

public record FieldReference<T>(Consumer<T> setter, Supplier<T> getter, GenericType genericType, String name, String group, String comment, boolean doesSync, OnSet<T> onSet, ValidatorReference<T> validator) {
    public void set(T value) {
        this.set(value, false);
    }

    public void set(T value, boolean fromSync) {
        this.setter.accept(value);
        if (this.onSet != null) {
            this.onSet.onSet(value, fromSync);
        }
    }

    public T get() {
        return this.getter.get();
    }

    public String fullName() {
        return this.group == null ? this.name : "%s.%s".formatted(this.group, this.name);
    }

    public static <T> Builder<T> builder(Consumer<T> setter, Supplier<T> getter, GenericType genericType, String name) {
        return new Builder<T>(setter, getter, genericType, name);
    }

    public static class Builder<T> {
        private final Consumer<T> setter;
        private final Supplier<T> getter;
        private final GenericType genericType;
        private final String name;
        private String group = null;
        private String comment = null;
        private boolean doesSync = false;
        private OnSet<T> onSet = null;
        private ValidatorReference<T> validator = null;

        public Builder(Consumer<T> setter, Supplier<T> getter, GenericType genericType, String name) {
            this.setter = setter;
            this.getter = getter;
            this.genericType = genericType;
            this.name = name;
        }

        public Builder<T> group(String group) {
            this.group = group;
            return this;
        }

        public Builder<T> comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder<T> doesSync(boolean doesSync) {
            this.doesSync = doesSync;
            return this;
        }

        public Builder<T> onSet(OnSet<T> onSet) {
            this.onSet = onSet;
            return this;
        }

        public Builder<T> validator(ValidatorReference<T> validator) {
            this.validator = validator;
            return this;
        }

        public FieldReference<T> build() {
            return new FieldReference<T>(this.setter, this.getter, this.genericType, this.name, this.group, this.comment, this.doesSync, this.onSet, this.validator);
        }
    }
}

