/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.networking;

import com.bawnorton.configurable.ConfigurableLoader;
import com.bawnorton.configurable.networking.HandshakePaylod;
import com.bawnorton.configurable.networking.SyncConfigPayload;
import com.bawnorton.configurable.service.ConfigLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class Networking {
    private static final Map<UUID, Set<String>> clientConfigs = new HashMap<UUID, Set<String>>();

    public static void init() {
        PayloadTypeRegistry.playS2C().register(SyncConfigPayload.TYPE, SyncConfigPayload.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(HandshakePaylod.TYPE, HandshakePaylod.STREAM_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(HandshakePaylod.TYPE, Networking::handleHandshake);
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> clientConfigs.remove(Networking.getPlayerId(handler.method_32311())));
    }

    private static void handleHandshake(HandshakePaylod handshakePaylod, ServerPlayNetworking.Context context) {
        clientConfigs.put(Networking.getPlayerId(context.player()), handshakePaylod.configs());
        Networking.syncConfigs(context.player());
    }

    public static void syncConfigs(class_3222 player) {
        Set configs = clientConfigs.getOrDefault(Networking.getPlayerId(player), Set.of());
        if (configs.isEmpty()) {
            return;
        }
        for (ConfigLoader loader : ConfigurableLoader.getConfigLoaders()) {
            if (!configs.contains(loader.getName())) continue;
            Networking.send(player, new SyncConfigPayload(loader.getName(), loader.getFields()));
        }
    }

    private static UUID getPlayerId(class_3222 player) {
        return player.method_7334().id();
    }

    public static <T extends class_8710> void send(class_3222 player, T payload) {
        ServerPlayNetworking.send((class_3222)player, payload);
    }
}

