/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.networking;

import com.bawnorton.configurable.ConfigurableLoader;
import com.bawnorton.configurable.networking.HandshakePaylod;
import com.bawnorton.configurable.networking.SyncConfigPayload;
import com.bawnorton.configurable.service.ConfigLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="configurable")
public class Networking {
    private static final Map<UUID, Set<String>> clientConfigs = new HashMap<UUID, Set<String>>();

    public static void init() {
    }

    @SubscribeEvent
    public static void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1").optional();
        registrar.playToClient(SyncConfigPayload.TYPE, SyncConfigPayload.STREAM_CODEC, Networking::handleSyncConfigPayload);
        registrar.playToServer(HandshakePaylod.TYPE, HandshakePaylod.STREAM_CODEC, Networking::handleHandshake);
    }

    @SubscribeEvent
    public static void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        Networking.syncConfigs((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerLeft(PlayerEvent.PlayerLoggedOutEvent event) {
        clientConfigs.remove(Networking.getPlayerId(event.getEntity()));
    }

    private static void handleHandshake(HandshakePaylod handshakePaylod, IPayloadContext context) {
        clientConfigs.put(Networking.getPlayerId(context.player()), handshakePaylod.configs());
        Networking.syncConfigs((ServerPlayer)context.player());
    }

    private static void handleSyncConfigPayload(SyncConfigPayload payload, IPayloadContext context) {
        ConfigLoader configLoader = ConfigurableLoader.getConfigLoader(payload.name());
        payload.applyToConfigLoader(configLoader);
    }

    public static void syncConfigs(ServerPlayer player) {
        Set configs = clientConfigs.getOrDefault(Networking.getPlayerId((Player)player), Set.of());
        if (configs.isEmpty()) {
            return;
        }
        for (ConfigLoader loader : ConfigurableLoader.getConfigLoaders()) {
            if (!configs.contains(loader.getName())) continue;
            Networking.send(player, new SyncConfigPayload(loader.getName(), loader.getFields()));
        }
    }

    private static UUID getPlayerId(Player player) {
        return player.getGameProfile().id();
    }

    public static <T extends CustomPacketPayload> void send(ServerPlayer player, T payload) {
        if (player.connection.hasChannel(payload)) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

