package com.bawnorton.configurable.networking;

import com.bawnorton.configurable.ConfigurableLoader;
import com.bawnorton.configurable.ConfigurableMain;
import com.bawnorton.configurable.io.SerialisationHelper;
import com.bawnorton.configurable.reference.FieldReference;
import com.bawnorton.configurable.service.ConfigLoader;
import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record SyncConfigPayload(String name, List<FieldReference<?>> fieldReferences) implements class_8710 {
    public static final class_2960 ID = ConfigurableMain.rl("sync_config_payload");
    public static final class_8710.class_9154<SyncConfigPayload> TYPE = new class_9154<>(ID);
    public static final class_9139<ByteBuf, SyncConfigPayload> STREAM_CODEC = class_9139.method_56437(
            SyncConfigPayload::encode,
            SyncConfigPayload::decode
    );

    private static void encode(ByteBuf byteBuf, SyncConfigPayload payload) {
        class_9135.field_48554.encode(byteBuf, payload.name());
        List<FieldReference<?>> fieldReferences = payload.fieldReferences()
                .stream()
                .filter(FieldReference::doesSync)
                .toList();
        class_9135.field_48550.encode(byteBuf, fieldReferences.size());
        for (FieldReference<?> fieldReference : fieldReferences) {
            class_9135.field_48554.encode(byteBuf, fieldReference.fullName());
            Object value = fieldReference.get();
            SerialisationHelper.encode(byteBuf, value, fieldReference.genericType());
        }
    }

    private static SyncConfigPayload decode(ByteBuf byteBuf) {
        String name = class_9135.field_48554.decode(byteBuf);
        ConfigLoader configLoader = ConfigurableLoader.getConfigLoader(name);
        List<FieldReference<?>> expectedFields = configLoader.getFields()
                .stream()
                .filter(FieldReference::doesSync)
                .toList();
        int size = class_9135.field_48550.decode(byteBuf);
        if (size != expectedFields.size()) {
            throw new IllegalArgumentException("Expected %d fields, but got %d".formatted(expectedFields.size(), size));
        }
        //noinspection unchecked
        Map<String, FieldReference<Object>> fieldMap = expectedFields.stream()
                .collect(Collectors.toMap(
                        FieldReference::fullName,
                        ref -> (FieldReference<Object>) ref
                ));
        List<FieldReference<?>> newFieldReferences = new ArrayList<>();
        for (int i = 0; i < size; i++) {
            String fullName = class_9135.field_48554.decode(byteBuf);
            FieldReference<Object> fieldReference = fieldMap.get(fullName);
            if (fieldReference == null) {
                throw new IllegalArgumentException("Field '%s' not found in config '%s'".formatted(fullName, name));
            }
            Object value = SerialisationHelper.interpet(byteBuf, fieldReference.genericType());
            newFieldReferences.add(
                    FieldReference.builder(
                                    ignored -> {
                                        throw new UnsupportedOperationException("Field '%s' is, read-only".formatted(fullName));
                                    },
                                    () -> value,
                                    fieldReference.genericType(),
                                    fieldReference.name()
                            )
                            .comment(fieldReference.comment())
                            .group(fieldReference.group())
                            .doesSync(fieldReference.doesSync())
                            .validator(fieldReference.validator())
                            .build()
            );
        }
        return new SyncConfigPayload(name, newFieldReferences);
    }

    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public void applyToConfigLoader(ConfigLoader configLoader) {
        List<FieldReference<?>> fields = configLoader.getFields();
        //noinspection unchecked
        Map<String, FieldReference<Object>> fieldMap = fields.stream()
                .filter(FieldReference::doesSync)
                .collect(Collectors.toMap(
                        FieldReference::fullName,
                        ref -> (FieldReference<Object>) ref
                ));
        for (FieldReference<?> fieldReference : fieldReferences) {
            String fieldName = fieldReference.fullName();
            FieldReference<Object> matchingField = fieldMap.get(fieldName);
            if (matchingField == null) {
                throw new IllegalArgumentException("Field '%s' not found in config loader '%s'".formatted(fieldName, configLoader.getName()));
            }
            matchingField.set(fieldReference.get(), true);
        }
    }
}
