/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat;

import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.onewholibs.util.UtilEntity;
import java.util.List;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)serverSpecPair.getRight();
        SERVER = (Server)serverSpecPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.DoubleValue mouseModeMaxRadius;
        public final ForgeConfigSpec.DoubleValue mouseYReturnRate;
        public final ForgeConfigSpec.DoubleValue mouseXReturnRate;
        public final ForgeConfigSpec.IntValue mouseYSteps;
        public final ForgeConfigSpec.IntValue mouseXSteps;
        public final ForgeConfigSpec.BooleanValue invertY;
        public final ForgeConfigSpec.BooleanValue cameraTurnRelativeToVehicle;
        public final ForgeConfigSpec.BooleanValue customDismount;
        public final ForgeConfigSpec.DoubleValue targetPosX;
        public final ForgeConfigSpec.DoubleValue targetPosY;
        public final ForgeConfigSpec.DoubleValue targetPosZ;
        public final ForgeConfigSpec.DoubleValue rwrWarningVol;
        public final ForgeConfigSpec.DoubleValue missileWarningVol;
        public final ForgeConfigSpec.DoubleValue irTargetToneVol;
        public final ForgeConfigSpec.DoubleValue cockpitVoiceLineVol;
        public final ForgeConfigSpec.ConfigValue<String> passengerSoundPack;
        public final ForgeConfigSpec.IntValue radarPingOverlaySize;
        public final ForgeConfigSpec.EnumValue<RadarStats.RadarMode> defaultRadarMode;
        public final ForgeConfigSpec.IntValue maxRenderRackMissileNum;
        public final ForgeConfigSpec.DoubleValue renderWeaponRackDistance;
        public final ForgeConfigSpec.DoubleValue renderTurretDistance;
        public final ForgeConfigSpec.DoubleValue renderEngineDistance;
        public final ForgeConfigSpec.DoubleValue renderRadarDistance;
        public final ForgeConfigSpec.DoubleValue renderOtherExternalPartDistance;
        public final ForgeConfigSpec.BooleanValue debugMode;
        public final ForgeConfigSpec.IntValue syncSeatPosRate;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("display");
            this.radarPingOverlaySize = builder.defineInRange("radarPingOverlaySize", 100, 10, 1000);
            this.defaultRadarMode = builder.defineEnum("defaultRadarMode", (Enum)RadarStats.RadarMode.ALL);
            builder.pop();
            builder.push("mouse-joystick-settings");
            this.mouseModeMaxRadius = builder.comment("Only for vehicles in Mouse Mode. How far your mouse must move from rest to get a maximum angle.").defineInRange("mouseModeMaxRadius", 400.0, 0.0, 10000.0);
            this.mouseYReturnRate = builder.comment("Speed the control stick vertically snaps back to rest when mouse isn't moving.").defineInRange("stickPitchReturnRate", 0.0, 0.0, 100.0);
            this.mouseXReturnRate = builder.comment("Speed the control stick horizontally snaps back to rest when mouse isn't moving.").defineInRange("stickRollReturnRate", 40.0, 0.0, 100.0);
            this.mouseYSteps = builder.defineInRange("stickPitchSteps", 5, 1, 100);
            this.mouseXSteps = builder.defineInRange("stickRollSteps", 5, 1, 100);
            builder.pop();
            builder.push("control");
            this.invertY = builder.comment("Invert vertical inputs.").define("invertY", false);
            this.cameraTurnRelativeToVehicle = builder.comment("If enabled, turning your player head may feel more natural.").define("cameraTurnRelativeToVehicle", true);
            this.customDismount = builder.comment("If enabled, your sneak key binding doesn't dismount you from DSC vehicles. You will have to you the diamond star combat dismount keybinding instead (H by default.)").define("customDismount", true);
            builder.push("targetPos");
            this.targetPosX = builder.defineInRange("targetPosX", 0.0, Double.MIN_VALUE, Double.MAX_VALUE);
            this.targetPosY = builder.defineInRange("targetPosY", 0.0, Double.MIN_VALUE, Double.MAX_VALUE);
            this.targetPosZ = builder.defineInRange("targetPosZ", 0.0, Double.MIN_VALUE, Double.MAX_VALUE);
            builder.pop();
            builder.pop();
            builder.push("sounds");
            this.rwrWarningVol = builder.comment("RWR Warning Sound Volume").defineInRange("rwrWarningVol", 1.0, 0.0, 1.0);
            this.missileWarningVol = builder.comment("Missile Warning Sound Volume").defineInRange("missileWarningVol", 1.0, 0.0, 1.0);
            this.irTargetToneVol = builder.comment("IR Target Found Sound Volume").defineInRange("irTargetToneVol", 0.5, 0.0, 1.0);
            this.cockpitVoiceLineVol = builder.comment("Cockpit Voicelines Volume").defineInRange("cockpitVoiceLineVol", 1.0, 0.0, 1.0);
            this.passengerSoundPack = builder.comment("The voice line pack your fighter jets use. You can use resource packs to add custom sound packs. The packs that come built into the mod are 'eng_non_binary_goober', 'eng_generic_male'.").define("passengerSoundPack", (Object)"eng_non_binary_goober");
            builder.pop();
            builder.push("performance");
            this.maxRenderRackMissileNum = builder.defineInRange("maxRenderRackMissileNum", 30, 0, 300);
            this.debugMode = builder.comment("Stats for nerds.").define("debugMode", false);
            this.syncSeatPosRate = builder.comment("Sometimes when the server lags, the server side position of the player's seat entity doesn't get updated. Eventually the server thinks the seat is outside of the player's render distance and sends a discard packet. This causes the player to randomly fall out of their plane. This is solved by having the client tell the server explicitly where the seat actually is on the client side. This config controls how often (in ticks) this sync packet is sent from the client to the server. This used to be set to 40 for everyone, but some have exceptionally poor connections and may need this value to be lowered.").defineInRange("syncSeatPosRate", 10, 0, 200);
            builder.push("entity-render-distance");
            this.renderWeaponRackDistance = builder.defineInRange("renderWeaponRackDistance", 256.0, 0.0, 1000.0);
            this.renderTurretDistance = builder.defineInRange("renderTurretDistance", 256.0, 0.0, 1000.0);
            this.renderEngineDistance = builder.defineInRange("renderEngineDistance", 256.0, 0.0, 1000.0);
            this.renderRadarDistance = builder.defineInRange("renderRadarDistance", 256.0, 0.0, 1000.0);
            this.renderOtherExternalPartDistance = builder.defineInRange("renderOtherExternalPartDistance", 192.0, 0.0, 1000.0);
            builder.pop();
            builder.pop();
        }

        public Vec3 getTargetPos() {
            return new Vec3(((Double)this.targetPosX.get()).doubleValue(), ((Double)this.targetPosY.get()).doubleValue(), ((Double)this.targetPosZ.get()).doubleValue());
        }
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue maxBlockCheckDepth;
        public final ForgeConfigSpec.DoubleValue gasCanXpRepairRate;
        public final ForgeConfigSpec.DoubleValue recoverPartWeight;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> radarMobs;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> dimensionSeaLevels;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("performance");
            this.maxBlockCheckDepth = builder.comment("The number of blocks between 2 entities to check if they can see eachother.").defineInRange("maxBlockCheckDepth", 250, 10, 400);
            builder.pop();
            builder.push("gameplay");
            this.gasCanXpRepairRate = builder.comment("The average durability repaired by mending per xp point.").defineInRange("gasCanXpRepairRate", 2.0, 2.0, 1000.0);
            this.recoverPartWeight = builder.comment("Roughly the randomly weighted percentage of vehicle recipe items recovered from crash site.").defineInRange("recoverPartWeight", 0.7, 0.0, 1.0);
            this.radarMobs = builder.defineList("radarMobs", List.of("net.minecraft.world.entity.Mob"), entry -> UtilEntity.getEntityClass((String)((String)entry)) != null);
            this.dimensionSeaLevels = builder.defineList("dimensionSeaLevels", List.of("minecraft:overworld!70!2500", "minecraft:the_nether!128!512", "minecraft:the_end!0!500"), entry -> ((String)entry).split("!").length == 3);
            builder.pop();
        }
    }

    public static class Server {
        public final ForgeConfigSpec.DoubleValue vehicleSpeedFactor;
        public final ForgeConfigSpec.DoubleValue planeSpeedFactor;
        public final ForgeConfigSpec.DoubleValue heliSpeedFactor;
        public final ForgeConfigSpec.DoubleValue carSpeedFactor;
        public final ForgeConfigSpec.DoubleValue boatSpeedFactor;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("speed_factors");
            this.vehicleSpeedFactor = builder.defineInRange("vehicleSpeedFactor", 1.0, 0.0, 10.0);
            this.planeSpeedFactor = builder.defineInRange("planeSpeedFactor", 1.0, 0.0, 10.0);
            this.heliSpeedFactor = builder.defineInRange("heliSpeedFactor", 1.0, 0.0, 10.0);
            this.carSpeedFactor = builder.defineInRange("carSpeedFactor", 1.0, 0.0, 10.0);
            this.boatSpeedFactor = builder.defineInRange("boatSpeedFactor", 1.0, 0.0, 10.0);
            builder.pop();
        }
    }
}

