/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.DependencySafety;
import com.onewhohears.dscombat.data.parts.PartPresetGenerator;
import com.onewhohears.dscombat.data.parts.client.PartClientPresetGenerator;
import com.onewhohears.dscombat.data.radar.RadarPresetGenerator;
import com.onewhohears.dscombat.data.recipe.DSCRecipeGenerator;
import com.onewhohears.dscombat.data.sound.DSCSoundDefinitionGen;
import com.onewhohears.dscombat.data.tag.BlockTagGen;
import com.onewhohears.dscombat.data.tag.EntityTypeTagGen;
import com.onewhohears.dscombat.data.tag.FluidTagGen;
import com.onewhohears.dscombat.data.tag.ItemTagGen;
import com.onewhohears.dscombat.data.vehicle.VehiclePresetGenerator;
import com.onewhohears.dscombat.data.vehicle.client.VehicleClientPresetGenerator;
import com.onewhohears.dscombat.data.weapon.WeaponPresetGenerator;
import com.onewhohears.dscombat.data.weapon.client.WeaponClientPresetGenerator;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.dscombat.init.ModArgumentTypes;
import com.onewhohears.dscombat.init.ModBlockEntities;
import com.onewhohears.dscombat.init.ModBlocks;
import com.onewhohears.dscombat.init.ModContainers;
import com.onewhohears.dscombat.init.ModEntities;
import com.onewhohears.dscombat.init.ModFluids;
import com.onewhohears.dscombat.init.ModItems;
import com.onewhohears.dscombat.init.ModParticles;
import com.onewhohears.dscombat.init.ModRecipes;
import com.onewhohears.dscombat.init.ModSounds;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.init.ModVillagers;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="dscombat")
public class DSCombatMod {
    public static final String MODID = "dscombat";
    public static boolean minigamesLoaded = false;
    public static boolean distantPlayersLoaded = false;

    public DSCombatMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBlocks.register(eventBus);
        ModFluids.register(eventBus);
        ModContainers.register(eventBus);
        ModEntities.register(eventBus);
        ModItems.register(eventBus);
        ModRecipes.register(eventBus);
        ModSounds.register(eventBus);
        ModBlockEntities.register(eventBus);
        DataSerializers.register(eventBus);
        ModVillagers.register(eventBus);
        ModParticles.register(eventBus);
        ModArgumentTypes.register(eventBus);
        ModTags.init();
        minigamesLoaded = ModList.get().isLoaded("minigames");
        distantPlayersLoaded = ModList.get().isLoaded("distant_players");
        eventBus.addListener(this::onGatherData);
    }

    private void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            generator.m_236039_(true, (DataProvider)new VehiclePresetGenerator(generator));
            generator.m_236039_(true, (DataProvider)new WeaponPresetGenerator(generator));
            generator.m_236039_(true, (DataProvider)new RadarPresetGenerator(generator));
            generator.m_236039_(true, (DataProvider)new PartPresetGenerator(generator));
            DependencySafety.serverDataGen(generator);
            generator.m_236039_(true, (DataProvider)new DSCRecipeGenerator(generator));
            generator.m_236039_(true, (DataProvider)new EntityTypeTagGen(generator, event.getExistingFileHelper()));
            BlockTagGen blockGen = new BlockTagGen(generator, event.getExistingFileHelper());
            generator.m_236039_(true, (DataProvider)blockGen);
            generator.m_236039_(true, (DataProvider)new ItemTagGen(generator, blockGen, event.getExistingFileHelper()));
            generator.m_236039_(true, (DataProvider)new FluidTagGen(generator, event.getExistingFileHelper()));
        }
        if (event.includeClient()) {
            generator.m_236039_(true, (DataProvider)new DSCSoundDefinitionGen(generator, event.getExistingFileHelper()));
            generator.m_236039_(true, (DataProvider)new VehicleClientPresetGenerator(generator));
            generator.m_236039_(true, (DataProvider)new PartClientPresetGenerator(generator));
            generator.m_236039_(true, (DataProvider)new WeaponClientPresetGenerator(generator));
        }
    }
}

