/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.entityscreen;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import com.onewhohears.dscombat.client.entityscreen.EntityScreenTypes;
import com.onewhohears.dscombat.data.vehicle.EntityScreenData;
import com.onewhohears.dscombat.mixin.CompositeRenderableAccess;
import com.onewhohears.dscombat.mixin.CompositeRenderableComponentAccess;
import com.onewhohears.dscombat.mixin.CompositeRenderableMeshAccess;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.renderable.CompositeRenderable;
import org.slf4j.Logger;

public class VehicleScreenMapReader {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static List<EntityScreenData> generateScreens(ResourceLocation screenMap, String modelId, Vec3 modelOffset) {
        List<VehicleScreenUV> vehicleScreenUVs = VehicleScreenMapReader.readVehicleScreenUVs(screenMap);
        return VehicleScreenMapReader.getVehicleScreenPos(modelId, vehicleScreenUVs, modelOffset);
    }

    private static List<VehicleScreenUV> readVehicleScreenUVs(ResourceLocation screenMap) {
        NativeImage image;
        Minecraft m = Minecraft.m_91087_();
        ArrayList<VehicleScreenUV> list = new ArrayList<VehicleScreenUV>();
        try {
            InputStream stream = ((Resource)m.m_91098_().m_213713_(screenMap).get()).m_215507_();
            image = NativeImage.m_85058_((InputStream)stream);
        }
        catch (NoSuchElementException e) {
            LOGGER.debug(screenMap.toString() + " does not exist. This vehicle won't have any screens.");
            return list;
        }
        catch (IOException e) {
            LOGGER.debug(screenMap.toString() + " not loaded. This vehicle won't have any screens.");
            return list;
        }
        for (int y = 0; y < image.m_85084_(); ++y) {
            for (int x = 0; x < image.m_84982_(); ++x) {
                int c;
                int screenType;
                int color = image.m_84985_(x, y);
                if (NativeImage.m_84983_((int)color) == 0 || (screenType = EntityScreenTypes.getScreenTypeIdByColor(color)) == -1 || x != 0 && image.m_84985_(x - 1, y) == color || y != 0 && image.m_84985_(x, y - 1) == color) continue;
                int u0 = x;
                int u1 = x;
                int v0 = y;
                int v1 = y;
                int u = u0 + 1;
                while (u < image.m_84982_() && (c = image.m_84985_(u, v0)) == color) {
                    u1 = u++;
                }
                int v = v0 + 1;
                while (v < image.m_85084_() && (c = image.m_84985_(u0, v)) == color) {
                    v1 = v++;
                }
                VehicleScreenUV vsuv = new VehicleScreenUV(screenType, (float)u0 / (float)image.m_84982_(), (float)(++u1) / (float)image.m_84982_(), (float)v0 / (float)image.m_85084_(), (float)(++v1) / (float)image.m_85084_());
                list.add(vsuv);
                x = u1;
                LOGGER.debug("Found screen " + vsuv.toString() + " in " + screenMap.toString());
            }
        }
        return list;
    }

    private static List<EntityScreenData> getVehicleScreenPos(String modelId, List<VehicleScreenUV> vehicleScreenUVs, Vec3 offset) {
        ArrayList<EntityScreenData> list = new ArrayList<EntityScreenData>();
        if (!ObjEntityModels.get().hasModel(modelId)) {
            LOGGER.warn("Obj Model " + modelId + " does not exist! No screens created.");
            return list;
        }
        CompositeRenderable model = ObjEntityModels.get().getBakedModel(modelId);
        for (VehicleScreenUV screenUV : vehicleScreenUVs) {
            VehicleScreenMapReader.findScreenPos(screenUV, model, list, offset);
        }
        return list;
    }

    private static void findScreenPos(VehicleScreenUV screenUV, CompositeRenderable model, List<EntityScreenData> list, Vec3 offset) {
        List<BakedQuad> middleQuads = VehicleScreenMapReader.findQuadsWithUV(model, screenUV.um, screenUV.vm);
        for (BakedQuad quad : middleQuads) {
            VehicleScreenMapReader.addScreenFromQuad(quad, list, screenUV, model, offset);
        }
    }

    private static void addScreenFromQuad(BakedQuad quad, List<EntityScreenData> list, VehicleScreenUV screenUV, CompositeRenderable model, Vec3 offset) {
        Vec2[] uvs = VehicleScreenMapReader.getUVs(quad);
        Vec3[] corners = VehicleScreenMapReader.getQuadPositions(quad);
        Vec3 pos = VehicleScreenMapReader.getWorldPos(screenUV.um, screenUV.vm, uvs, corners);
        float width = 0.05f;
        float height = 0.05f;
        float[] wh = VehicleScreenMapReader.getWidthHeight(uvs, corners, pos, screenUV);
        if (wh == null) {
            wh = VehicleScreenMapReader.getWidthHeightOtherQuad(pos, screenUV, model);
        }
        if (wh != null) {
            width = wh[0];
            height = wh[1];
        }
        Vec3 normal = corners[2].m_82546_(corners[0]).m_82537_(corners[1].m_82546_(corners[0])).m_82541_();
        pos = pos.m_82549_(offset).m_82546_(normal.m_82490_(0.001));
        LOGGER.debug("Found screen pos in model! Adding screen type " + screenUV.screenType + " at " + pos);
        list.add(new EntityScreenData(screenUV.screenType, pos, width, height, UtilAngles.getPitch((Vec3)normal), UtilAngles.getYaw((Vec3)normal), 0.0f));
    }

    private static float[] getWidthHeightOtherQuad(Vec3 pos, VehicleScreenUV screenUV, CompositeRenderable model) {
        List<BakedQuad> cornerQuads = VehicleScreenMapReader.findQuadsWithUV(model, screenUV.u0, screenUV.v0);
        for (BakedQuad quad : cornerQuads) {
            Vec3[] corners;
            Vec2[] uvs = VehicleScreenMapReader.getUVs(quad);
            Vec3 cornerPos = VehicleScreenMapReader.getWorldPos(screenUV.u0, screenUV.v0, uvs, corners = VehicleScreenMapReader.getQuadPositions(quad));
            if (cornerPos.m_82554_(pos) > 1.0) continue;
            Vec2 uvm = new Vec2(screenUV.um, screenUV.vm);
            Vec2 uvc = new Vec2(screenUV.u0, screenUV.v0);
            return VehicleScreenMapReader.getWidthHeight(pos, cornerPos, uvm, uvc);
        }
        return null;
    }

    private static float[] getWidthHeight(Vec2[] uvs, Vec3[] corners, Vec3 pos, VehicleScreenUV screenUV) {
        float[] wh = null;
        Vec2 uvm = new Vec2(screenUV.um, screenUV.vm);
        wh = VehicleScreenMapReader.getWidthHeight(uvs, corners, pos, uvm, new Vec2(screenUV.u0, screenUV.v0));
        if (wh == null) {
            wh = VehicleScreenMapReader.getWidthHeight(uvs, corners, pos, uvm, new Vec2(screenUV.u1, screenUV.v0));
        }
        if (wh == null) {
            wh = VehicleScreenMapReader.getWidthHeight(uvs, corners, pos, uvm, new Vec2(screenUV.u0, screenUV.v1));
        }
        if (wh == null) {
            wh = VehicleScreenMapReader.getWidthHeight(uvs, corners, pos, uvm, new Vec2(screenUV.u1, screenUV.v1));
        }
        return wh;
    }

    private static float[] getWidthHeight(Vec2[] uvs, Vec3[] corners, Vec3 pos, Vec2 uvm, Vec2 uvc) {
        if (!VehicleScreenMapReader.hasUV(uvs, uvc.f_82470_, uvc.f_82471_)) {
            return null;
        }
        Vec3 cornerPos = VehicleScreenMapReader.getWorldPos(uvc.f_82470_, uvc.f_82471_, uvs, corners);
        return VehicleScreenMapReader.getWidthHeight(pos, cornerPos, uvm, uvc);
    }

    private static float[] getWidthHeight(Vec3 middlePos, Vec3 cornerPos, Vec2 uvm, Vec2 uvc) {
        Vec3 posDiff = middlePos.m_82546_(cornerPos);
        Vec2 uvDiff = uvm.m_165910_(uvc.m_165913_());
        float posLength = (float)posDiff.m_82553_();
        float uvLength = uvDiff.m_165907_();
        float scale = posLength / uvLength;
        float width = Mth.m_14154_((float)uvDiff.f_82470_) * 2.0f * scale;
        float height = Mth.m_14154_((float)uvDiff.f_82471_) * 2.0f * scale;
        return new float[]{width, height};
    }

    private static List<BakedQuad> findQuadsWithUV(CompositeRenderable model, float u, float v) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (CompositeRenderableComponentAccess component : ((CompositeRenderableAccess)model).getComponents()) {
            VehicleScreenMapReader.searchComponent(component, quads, u, v);
        }
        return quads;
    }

    private static void searchComponent(CompositeRenderableComponentAccess component, List<BakedQuad> quads, float u, float v) {
        for (CompositeRenderableMeshAccess mesh : component.getMeshes()) {
            VehicleScreenMapReader.searchMesh(mesh, quads, u, v);
        }
        for (CompositeRenderableComponentAccess childComponent : component.getChildren()) {
            VehicleScreenMapReader.searchComponent(childComponent, quads, u, v);
        }
    }

    private static void searchMesh(CompositeRenderableMeshAccess mesh, List<BakedQuad> quads, float u, float v) {
        for (BakedQuad quad : mesh.getQuads()) {
            VehicleScreenMapReader.searchQuad(quad, quads, u, v);
        }
    }

    private static void searchQuad(BakedQuad quad, List<BakedQuad> quads, float u, float v) {
        if (VehicleScreenMapReader.hasUV(VehicleScreenMapReader.getUVs(quad), u, v)) {
            quads.add(quad);
        }
    }

    private static Vec3 getWorldPos(float u, float v, Vec2[] uvs, Vec3[] corners) {
        Vec2 uvg = new Vec2(u, v);
        if (VehicleScreenMapReader.isUVsTri(uvs)) {
            return VehicleScreenMapReader.getWorldPosFromTri(uvg, uvs, corners);
        }
        Vec2[] uvt1 = new Vec2[]{uvs[0], uvs[1], uvs[2]};
        if (UtilGeometry.isIn2DTriangle((Vec2)uvg, (Vec2[])uvt1)) {
            return VehicleScreenMapReader.getWorldPosFromTri(uvg, uvt1, new Vec3[]{corners[0], corners[1], corners[2]});
        }
        Vec2[] uvt2 = new Vec2[]{uvs[0], uvs[2], uvs[3]};
        return VehicleScreenMapReader.getWorldPosFromTri(uvg, uvt2, new Vec3[]{corners[0], corners[2], corners[3]});
    }

    private static Vec3 getWorldPosFromTri(Vec2 uvg, Vec2[] uvs, Vec3[] corners) {
        Vec2 Q = uvg;
        Vec2 A = uvs[0];
        Vec2 B = uvs[1];
        Vec2 C = uvs[2];
        Vec2 P = UtilGeometry.intersect((Vec2)C, (Vec2)Q, (Vec2)B, (Vec2)A);
        Vec2 v = B.m_165910_(A.m_165913_());
        float t = 0.0f;
        float s = 0.0f;
        if (v.f_82470_ != 0.0f) {
            t = P.m_165910_((Vec2)A.m_165913_()).f_82470_ / v.f_82470_;
        } else if (v.f_82471_ != 0.0f) {
            t = P.m_165910_((Vec2)A.m_165913_()).f_82471_ / v.f_82471_;
        }
        Vec2 u = P.m_165910_(C.m_165913_());
        if (u.f_82470_ != 0.0f) {
            s = Q.m_165910_((Vec2)C.m_165913_()).f_82470_ / u.f_82470_;
        } else if (u.f_82471_ != 0.0f) {
            s = Q.m_165910_((Vec2)C.m_165913_()).f_82471_ / u.f_82471_;
        }
        return corners[0].m_82490_((double)((1.0f - t) * s)).m_82549_(corners[1].m_82490_((double)(t * s))).m_82549_(corners[2].m_82490_((double)(1.0f - s)));
    }

    private static Vec3[] getQuadPositions(BakedQuad quad) {
        Vec3[] pos = new Vec3[4];
        for (int i = 0; i < 4; ++i) {
            pos[i] = new Vec3((double)Float.intBitsToFloat(quad.m_111303_()[i * 8]), (double)Float.intBitsToFloat(quad.m_111303_()[i * 8 + 1]), (double)Float.intBitsToFloat(quad.m_111303_()[i * 8 + 2]));
        }
        return pos;
    }

    private static Vec2[] getUVs(BakedQuad quad) {
        Vec2[] uvs = new Vec2[4];
        for (int i = 0; i < 4; ++i) {
            uvs[i] = new Vec2(Float.intBitsToFloat(quad.m_111303_()[i * 8 + 4]), Float.intBitsToFloat(quad.m_111303_()[i * 8 + 5]));
        }
        return uvs;
    }

    private static boolean hasUV(Vec2[] uvs, float u, float v) {
        Vec2 uv = new Vec2(u, v);
        if (VehicleScreenMapReader.isUVsTri(uvs)) {
            UtilGeometry.isIn2DTriangle((Vec2)uv, (Vec2[])uvs);
        }
        return UtilGeometry.isIn2DQuad((Vec2)uv, (Vec2[])uvs);
    }

    private static boolean isUVsTri(Vec2[] uvs) {
        for (int i = 0; i < uvs.length; ++i) {
            for (int j = 0; j < uvs.length; ++j) {
                if (j == i || uvs[i].f_82470_ != uvs[j].f_82470_ || uvs[i].f_82471_ != uvs[j].f_82471_) continue;
                return true;
            }
        }
        return false;
    }

    public static class VehicleScreenUV {
        public final int screenType;
        public final float u0;
        public final float u1;
        public final float um;
        public final float v0;
        public final float v1;
        public final float vm;

        public VehicleScreenUV(int screenType, float u0, float u1, float v0, float v1) {
            this.screenType = screenType;
            this.u0 = u0;
            this.u1 = u1;
            this.um = (u0 + u1) / 2.0f;
            this.v0 = v0;
            this.v1 = v1;
            this.vm = (v0 + v1) / 2.0f;
        }

        public String toString() {
            return "[VehicleScreenUV|type:" + this.screenType + "|u0,u1,v0,v1:" + this.u0 + "," + this.u1 + "," + this.v0 + "," + this.v1 + "]";
        }
    }
}

