/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.entityscreen.instance;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class EntityScreenInstance
implements AutoCloseable {
    @Nullable
    private final RenderType baseRenderType;

    public EntityScreenInstance(int id, @Nullable ResourceLocation baseTexture) {
        this.baseRenderType = baseTexture != null ? RenderType.m_110497_((ResourceLocation)baseTexture) : null;
    }

    public void draw(Entity entity, PoseStack poseStack, MultiBufferSource buffer, float partialTicks, int packedLight, float worldWidth, float worldHeight) {
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        this.draw(entity, matrix4f, buffer, partialTicks, packedLight, worldWidth, worldHeight);
    }

    public void draw(Entity entity, Matrix4f matrix4f, MultiBufferSource buffer, float partialTicks, int packedLight, float worldWidth, float worldHeight) {
        if (this.baseRenderType != null) {
            this.drawTextureCentered(this.baseRenderType, matrix4f, buffer, packedLight, 0.0f);
        }
    }

    protected void drawText(Component text, float xPos, float yPos, float maxWidth, PoseStack poseStack, MultiBufferSource buffer, int color, int packedLight) {
        Font font = Minecraft.m_91087_().f_91062_;
        float width = font.m_92852_((FormattedText)text);
        float scale = maxWidth / width;
        poseStack.m_85836_();
        poseStack.m_85837_((double)xPos, (double)yPos, (double)-0.005f);
        poseStack.m_85841_(scale, scale, 1.0f);
        font.m_92889_(poseStack, text, 0.0f, 0.0f, color);
        poseStack.m_85849_();
    }

    protected void drawTextureTopLeft(RenderType type, Matrix4f matrix4f, MultiBufferSource buffer, int packedLight, float z) {
        VertexConsumer vertexconsumer = buffer.m_6299_(type);
        vertexconsumer.m_85982_(matrix4f, 0.0f, 1.0f, z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_85969_(packedLight).m_5752_();
        vertexconsumer.m_85982_(matrix4f, 1.0f, 1.0f, z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_85969_(packedLight).m_5752_();
        vertexconsumer.m_85982_(matrix4f, 1.0f, 0.0f, z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_85969_(packedLight).m_5752_();
        vertexconsumer.m_85982_(matrix4f, 0.0f, 0.0f, z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(packedLight).m_5752_();
    }

    protected void drawTextureCentered(RenderType type, Matrix4f matrix4f, MultiBufferSource buffer, int packedLight, float z) {
        VertexConsumer vertexconsumer = buffer.m_6299_(type);
        vertexconsumer.m_85982_(matrix4f, -0.5f, 0.5f, z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_85969_(packedLight).m_5752_();
        vertexconsumer.m_85982_(matrix4f, 0.5f, 0.5f, z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_85969_(packedLight).m_5752_();
        vertexconsumer.m_85982_(matrix4f, 0.5f, -0.5f, z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_85969_(packedLight).m_5752_();
        vertexconsumer.m_85982_(matrix4f, -0.5f, -0.5f, z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(packedLight).m_5752_();
    }

    @Override
    public void close() {
    }
}

