/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.entityscreen.instance;

import com.onewhohears.dscombat.client.entityscreen.instance.EntityDynamicScreenInstance;
import com.onewhohears.dscombat.data.radar.RadarSystem;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class RWRScreenInstance
extends EntityDynamicScreenInstance {
    public static final ResourceLocation TEXTURE = new ResourceLocation("dscombat", "textures/ui/entity_screen/rwr_screen_bg.png");
    protected final int centerX;
    protected final int centerY;
    protected final int textureRadius;

    public RWRScreenInstance(int id) {
        super("rwr", id, TEXTURE, 512, 512);
        this.textureRadius = 230;
        this.centerX = this.pixelWidth / 2;
        this.centerY = this.pixelHeight / 2;
    }

    @Override
    public boolean shouldUpdateTexture(Entity entity) {
        EntityVehicle vehicle = (EntityVehicle)entity;
        if (entity.f_19797_ == this.prevUpdateTickCount) {
            return false;
        }
        if (entity.f_19797_ % 2 != 0) {
            return false;
        }
        return entity.f_19797_ - vehicle.radarSystem.clientRwrRefreshTime <= 100;
    }

    @Override
    protected void updateTexture(Entity entity) {
        this.clearDynamicPixels();
        EntityVehicle vehicle = (EntityVehicle)entity;
        if (!vehicle.radarSystem.clientHasRWRWarnings()) {
            return;
        }
        Collection<RadarSystem.RWRWarning> warnings = vehicle.radarSystem.getClientRWRWarnings();
        for (RadarSystem.RWRWarning warn : warnings) {
            this.drawWarning(warn, vehicle);
        }
    }

    protected void drawWarning(RadarSystem.RWRWarning warn, EntityVehicle vehicle) {
        Vec3 dp = warn.pos.m_82546_(vehicle.m_20182_());
        double dist = dp.m_165924_();
        double screen_dist = dist * 0.001;
        if (screen_dist > 1.0) {
            screen_dist = 1.0;
        } else if (screen_dist < 0.1) {
            screen_dist = 0.1;
        }
        float yaw = (UtilAngles.getYaw((Vec3)dp) - vehicle.m_146908_() + 180.0f) * ((float)Math.PI / 180);
        int x = Math.min(this.centerX + (int)((double)(-Mth.m_14031_((float)yaw) * (float)this.textureRadius) * screen_dist), this.pixelWidth - 1);
        int y = Math.min(this.centerY + (int)((double)(Mth.m_14089_((float)yaw) * (float)this.textureRadius) * screen_dist), this.pixelHeight - 1);
        this.drawWarningAtPos(warn, x, y);
    }

    protected void drawWarningAtPos(RadarSystem.RWRWarning warn, int x, int y) {
        int r = 32;
        int t = 5;
        if (warn.isMissile) {
            this.drawDiamond(x, y, r, t, -16776961);
            this.drawCross(x, y, r / 2, t, -16776961);
        } else if (warn.fromGround) {
            this.drawDiamond(x, y, r, t, -16711681);
            this.drawPlus(x, y, r, t, -16711681);
        } else {
            this.drawDiamond(x, y, r, t, -16711936);
        }
    }
}

