/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.event.forgebus;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.parts.EntityGimbal;
import com.onewhohears.dscombat.entity.parts.EntityRidablePart;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.mixin.CameraAccess;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;

@Mod.EventBusSubscriber(modid="dscombat", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientCameraEvents {
    private static Entity prevGimbal;
    private static float ptOld;
    public static final GLFWCursorPosCallbackI customMouseCallback;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void cameraSetup(ViewportEvent.ComputeCameraAngles event) {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer player = m.f_91074_;
        if (player == null) {
            return;
        }
        if (!player.m_20159_()) {
            if (m.m_91288_().equals((Object)prevGimbal)) {
                m.m_91118_((Entity)player);
            }
            prevGimbal = null;
            return;
        }
        Entity entity = player.m_20201_();
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle plane = (EntityVehicle)entity;
        float pt = (float)event.getPartialTick();
        boolean detached = !m.f_91066_.m_92176_().m_90612_();
        boolean mirrored = m.f_91066_.m_92176_().m_90613_();
        float camYOffset = 0.0f;
        boolean isPilot = false;
        boolean isCopilot = false;
        Entity entity2 = player.m_20202_();
        if (entity2 instanceof EntityRidablePart) {
            EntityRidablePart seat = (EntityRidablePart)entity2;
            isPilot = seat.isPilotSeat();
            isCopilot = seat.isCoPilotSeat();
            if (DSCClientInputs.isGimbalMode()) {
                camYOffset = seat.getCameraYOffset();
            }
        }
        if (prevGimbal != null && prevGimbal.m_213877_() || !DSCClientInputs.isGimbalMode() && !m.m_91288_().equals((Object)player)) {
            m.m_91118_((Entity)player);
            prevGimbal = null;
        }
        if (DSCClientInputs.isGimbalMode() && (isPilot || isCopilot || camYOffset == 0.0f) && plane.getGimbalForPilotCamera() != null) {
            EntityGimbal gimbal = plane.getGimbalForPilotCamera();
            if (!m.m_91288_().equals((Object)gimbal)) {
                m.m_91118_((Entity)gimbal);
            }
            gimbal.m_146926_(player.m_5686_(pt));
            gimbal.m_146922_(player.m_5675_(pt));
            prevGimbal = gimbal;
            camYOffset = -0.2f;
        }
        if (isPilot && DSCClientInputs.isCameraLockedForward()) {
            float xi = UtilAngles.lerpAngle((float)pt, (float)plane.f_19860_, (float)plane.m_146909_());
            float yi = UtilAngles.lerpAngle180((float)pt, (float)plane.f_19859_, (float)plane.m_146908_());
            player.m_146926_(xi);
            player.m_146922_(yi);
            player.f_19860_ = xi;
            player.f_19859_ = yi;
            if (mirrored) {
                xi *= -1.0f;
                yi += 180.0f;
            }
            event.setPitch(xi);
            event.setYaw(yi);
        } else if (isPilot && DSCClientInputs.isCameraFreeRelative()) {
            float planeYRotDiff;
            float ptDiff = ClientCameraEvents.ptDiff(pt, ptOld);
            float planeXRotDiff = plane.m_146909_() - plane.f_19860_;
            if (planeXRotDiff != 0.0f) {
                float dxi = Mth.m_14177_((float)planeXRotDiff) * ptDiff;
                float x = player.m_146909_() + dxi;
                player.m_146926_(x);
                player.f_19860_ = x;
                if (mirrored) {
                    x *= -1.0f;
                }
                event.setPitch(x);
            }
            if ((planeYRotDiff = plane.m_146908_() - plane.f_19859_) != 0.0f) {
                float dyi = Mth.m_14177_((float)planeYRotDiff) * ptDiff;
                float y = player.m_146908_() + dyi;
                player.m_146922_(y);
                player.f_19859_ = y;
                if (mirrored) {
                    y += 180.0f;
                }
                event.setYaw(y);
            }
        }
        float zi = UtilAngles.lerpAngle((float)pt, (float)plane.zRotO, (float)plane.zRot);
        if (detached && mirrored) {
            zi *= -1.0f;
        }
        event.setRoll(zi);
        double camDist = ((VehicleStats)plane.getStats()).cameraDistance;
        Camera camera = event.getCamera();
        if (detached && isPilot && camDist > 4.0) {
            double vehicleCamDist = Math.min(0.0, 4.0 - ClientCameraEvents.getMaxDist(camera, (Player)player, camDist));
            ((CameraAccess)camera).invokeSetRotation(event.getYaw(), event.getPitch());
            camera.m_90568_(vehicleCamDist, 0.0, 0.0);
        }
        Quaternion q = null;
        if (camYOffset != 0.0f) {
            q = UtilAngles.lerpQ((float)pt, (Quaternion)plane.getPrevQ(), (Quaternion)plane.getClientQ());
            Vec3 yawAxis = UtilAngles.getYawAxis((Quaternion)q);
            camera.m_90581_(camera.m_90583_().m_82549_(yawAxis.m_82490_((double)camYOffset)));
        }
        if (DSCClientInputs.getLeanAmount() != 0.0) {
            if (q == null) {
                q = UtilAngles.lerpQ((float)pt, (Quaternion)plane.getPrevQ(), (Quaternion)plane.getClientQ());
            }
            Vec3 pitchAxis = UtilAngles.getPitchAxis((Quaternion)q);
            camera.m_90581_(camera.m_90583_().m_82549_(pitchAxis.m_82490_(-DSCClientInputs.getLeanAmount())));
        }
        ptOld = pt;
    }

    private static float ptDiff(float pt, float ptOld) {
        if (pt == ptOld) {
            return 0.0f;
        }
        if (pt > ptOld) {
            return pt - ptOld;
        }
        return pt + 1.0f - ptOld;
    }

    public static double getMaxDist(Camera cam, Player player, double dist) {
        double d0;
        Vec3 from = cam.m_90583_();
        Vector3f d = cam.m_90596_().m_122281_();
        d.m_122261_((float)(-dist));
        Vec3 to = from.m_82520_((double)d.m_122239_(), (double)d.m_122260_(), (double)d.m_122269_());
        BlockHitResult hitresult = player.f_19853_.m_45547_(new ClipContext(from, to, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)player));
        if (hitresult.m_6662_() != HitResult.Type.MISS && (d0 = hitresult.m_82450_().m_82554_(from)) < dist) {
            dist = d0;
        }
        return dist;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void clientTickSetMouseCallback(TickEvent.ClientTickEvent event) {
        Minecraft m = Minecraft.m_91087_();
        if (m.f_91074_ == null || m.f_91074_.f_19797_ != 1) {
            return;
        }
        if (!((Boolean)Config.CLIENT.cameraTurnRelativeToVehicle.get()).booleanValue()) {
            return;
        }
        GLFW.glfwSetCursorPosCallback((long)m.m_91268_().m_85439_(), (GLFWCursorPosCallbackI)customMouseCallback);
    }

    static {
        customMouseCallback = (window, x, y) -> {
            Minecraft m = Minecraft.m_91087_();
            m.execute(() -> {
                Entity patt6718$temp;
                double xn = x;
                double yn = y;
                if (window != m.m_91268_().m_85439_()) {
                    return;
                }
                if (DSCClientInputs.isCameraFree() && m.f_91074_ != null && m.f_91080_ == null && (patt6718$temp = m.f_91074_.m_20201_()) instanceof EntityVehicle) {
                    EntityVehicle craft = (EntityVehicle)patt6718$temp;
                    double r = Math.toRadians(craft.zRot);
                    double dx = x - m.f_91067_.m_91589_();
                    double dy = y - m.f_91067_.m_91594_();
                    double cosR = Math.cos(r);
                    double sinR = Math.sin(r);
                    xn = dx * cosR - dy * sinR + m.f_91067_.m_91589_();
                    yn = dy * cosR + dx * sinR + m.f_91067_.m_91594_();
                    GLFW.glfwSetCursorPos((long)window, (double)xn, (double)yn);
                }
                m.f_91067_.m_91561_(window, xn, yn);
            });
        };
    }
}

