/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.event.forgebus;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.input.DSCKeys;
import com.onewhohears.dscombat.client.screen.VehicleMainScreen;
import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.common.network.VehicleSyncAction;
import com.onewhohears.dscombat.common.network.toserver.ToServerSeatPos;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.data.radar.RadarSystem;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.parts.EntityGimbal;
import com.onewhohears.dscombat.entity.parts.EntityRidablePart;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.ModSounds;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dscombat", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public final class ClientInputEvents {
    private static int leftTicks = 0;
    private static long radarModeUpdateTime = 0L;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void clientTickPilotControl(TickEvent.ClientTickEvent event) {
        int invertY;
        boolean throttleDown;
        boolean throttleUp;
        boolean pitchDown;
        boolean pitchUp;
        boolean rollRight;
        boolean rollLeft;
        boolean yawRight;
        boolean yawLeft;
        Entity entity;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (!player.m_20159_() || !((entity = player.m_20201_()) instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        Entity controller = vehicle.m_6688_();
        if (controller == null || !controller.equals((Object)player)) {
            return;
        }
        if (DSCKeys.mouseModeKey.m_90859_()) {
            DSCClientInputs.cycleMouseMode();
        }
        if (DSCKeys.resetMouseKey.m_90857_()) {
            DSCClientInputs.centerMousePos();
        } else if (mc.f_91080_ != null) {
            DSCClientInputs.centerMousePos();
        }
        double mouseX = mc.f_91067_.m_91589_() - DSCClientInputs.getMouseCenterX();
        double mouseY = -(mc.f_91067_.m_91594_() - DSCClientInputs.getMouseCenterY());
        boolean flare = DSCKeys.flareKey.m_90857_();
        boolean flip = DSCKeys.flipControlsKey.m_90857_();
        boolean special = DSCKeys.specialKey.m_90857_();
        boolean special2 = DSCKeys.special2Key.m_90857_();
        float pitch = 0.0f;
        float roll = 0.0f;
        float yaw = 0.0f;
        float throttle = 0.0f;
        if (flip) {
            yawLeft = DSCKeys.rollLeftKey.m_90857_();
            yawRight = DSCKeys.rollRightKey.m_90857_();
            rollLeft = DSCKeys.yawLeftKey.m_90857_();
            rollRight = DSCKeys.yawRightKey.m_90857_();
        } else {
            yawLeft = DSCKeys.yawLeftKey.m_90857_();
            yawRight = DSCKeys.yawRightKey.m_90857_();
            rollLeft = DSCKeys.rollLeftKey.m_90857_();
            rollRight = DSCKeys.rollRightKey.m_90857_();
        }
        boolean type_flip = ((VehicleStats)vehicle.getStats()).flipPitchThrottle();
        boolean mode = DSCClientInputs.isCameraLockedForward();
        if (!type_flip && flip ^ mode || type_flip && !flip) {
            pitchUp = DSCKeys.throttleUpKey.m_90857_();
            pitchDown = DSCKeys.throttleDownKey.m_90857_();
            throttleUp = DSCKeys.pitchUpKey.m_90857_();
            throttleDown = DSCKeys.pitchDownKey.m_90857_();
        } else {
            pitchUp = DSCKeys.pitchUpKey.m_90857_();
            pitchDown = DSCKeys.pitchDownKey.m_90857_();
            throttleUp = DSCKeys.throttleUpKey.m_90857_();
            throttleDown = DSCKeys.throttleDownKey.m_90857_();
        }
        int n = invertY = (Boolean)Config.CLIENT.invertY.get() != false ? -1 : 1;
        if (((VehicleStats)vehicle.getStats()).ignoreInvertY()) {
            invertY = -1;
        }
        if (DSCClientInputs.isCameraLockedForward()) {
            int step;
            double ya = Math.abs(mouseY);
            double xa = Math.abs(mouseX);
            float ys = (float)Math.signum(mouseY) * (float)(-invertY);
            float xs = (float)Math.signum(mouseX);
            double max = (Double)Config.CLIENT.mouseModeMaxRadius.get();
            float stickStepsY = ((Integer)Config.CLIENT.mouseYSteps.get()).intValue();
            float stickStepsX = ((Integer)Config.CLIENT.mouseXSteps.get()).intValue();
            if (ya >= max) {
                pitch = ys;
            } else {
                step = (int)(ya / max * (double)stickStepsY * (double)ys);
                pitch = (float)step / stickStepsY;
            }
            if (xa >= max) {
                roll = xs;
            } else {
                step = (int)(xa / max * (double)stickStepsX * (double)xs);
                roll = (float)step / stickStepsX;
            }
            if (mc.f_91067_.getYVelocity() == 0.0) {
                DSCClientInputs.setMouseCenterY((int)Mth.m_14121_((float)((float)DSCClientInputs.getMouseCenterY()), (float)((float)mc.f_91067_.m_91594_()), (float)((Double)Config.CLIENT.mouseYReturnRate.get()).floatValue()));
            }
            if (mc.f_91067_.getXVelocity() == 0.0) {
                DSCClientInputs.setMouseCenterX((int)Mth.m_14121_((float)((float)DSCClientInputs.getMouseCenterX()), (float)((float)mc.f_91067_.m_91589_()), (float)((Double)Config.CLIENT.mouseXReturnRate.get()).floatValue()));
            }
        }
        if (pitchUp && !pitchDown) {
            pitch = -invertY;
        }
        if (pitchDown && !pitchUp) {
            pitch = invertY;
        }
        if (yawLeft && !yawRight) {
            yaw = -1.0f;
        }
        if (yawRight && !yawLeft) {
            yaw = 1.0f;
        }
        if (rollLeft) {
            roll -= 1.0f;
        }
        if (rollRight) {
            roll += 1.0f;
        }
        if (throttleUp) {
            throttle += 1.0f;
        }
        if (throttleDown) {
            throttle -= 1.0f;
        }
        vehicle.inputs.clientPilotControlsToServer(vehicle, throttle, pitch, roll, yaw, flare, false, special, special2, rollLeft && rollRight, DSCClientInputs.isCameraLockedForward());
        if (!DSCClientInputs.isCameraLockedForward()) {
            DSCClientInputs.centerMousePos();
        }
        if (DSCKeys.landingGear.m_90859_()) {
            ClientInputEvents.sendSyncAction(new VehicleSyncAction.LandingGearAction(vehicle.toggleLandingGear()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void clientTickPassengerControl(TickEvent.ClientTickEvent event) {
        boolean cycleRadarMode;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Minecraft m = Minecraft.m_91087_();
        leftTicks = m.f_91067_.m_91560_() ? ++leftTicks : 0;
        LocalPlayer player = m.f_91074_;
        if (player == null || !player.m_20159_()) {
            return;
        }
        Entity entity = player.m_20202_();
        if (!(entity instanceof EntityRidablePart)) {
            return;
        }
        EntityRidablePart seat = (EntityRidablePart)entity;
        EntityVehicle vehicle = seat.getParentVehicle();
        if (vehicle == null) {
            return;
        }
        boolean isRadarController = player.equals((Object)vehicle.getControllingPlayerOrBot());
        if (DSCClientInputs.disable3rdPersonVehicle) {
            m.f_91066_.m_92157_(CameraType.FIRST_PERSON);
        }
        if (player.f_19797_ % (Integer)Config.CLIENT.syncSeatPosRate.get() == 0) {
            PacketHandler.INSTANCE.sendToServer((Object)new ToServerSeatPos(player.m_20202_().m_20182_()));
        }
        if (DSCKeys.changeSeat.m_90859_()) {
            ClientInputEvents.sendSyncAction(new VehicleSyncAction.SwitchSeatAction());
        }
        int selectNextWeapon = 0;
        if (DSCKeys.weaponSelect2Key.m_90859_()) {
            selectNextWeapon = -1;
        } else if (DSCKeys.weaponSelectKey.m_90859_()) {
            selectNextWeapon = 1;
        }
        vehicle.weaponSystem.selectNextWeapon(selectNextWeapon);
        RadarSystem radar = vehicle.radarSystem;
        if (DSCClientInputs.isRadarHovering() && leftTicks == 1) {
            List<RadarStats.RadarPing> pings = radar.getClientRadarPings();
            if (DSCClientInputs.getRadarHoverIndex() < pings.size()) {
                radar.clientSelectTarget(pings.get(DSCClientInputs.getRadarHoverIndex()));
            }
        }
        if (DSCKeys.pingCycleKey.m_90859_()) {
            radar.clientSelectNextTarget();
        }
        if (DSCKeys.shootKey.m_90857_() && ClientInputEvents.playerCanShoot((Player)player)) {
            ClientInputEvents.sendSyncAction(new VehicleSyncAction.ShootAction(vehicle.weaponSystem.getSelectedIndex(), radar.getClientSelectedPing(), ClientInputEvents.getShootPos((Player)player, vehicle)));
        }
        if (((Boolean)Config.CLIENT.customDismount.get()).booleanValue() && DSCKeys.dismount.m_90857_()) {
            ClientInputEvents.sendSyncAction(new VehicleSyncAction.DismountAction());
        }
        if (DSCKeys.eject.m_90859_()) {
            if (seat.canEject()) {
                seat.useEject();
                ClientInputEvents.sendSyncAction(new VehicleSyncAction.DismountAction(true));
                player.m_9236_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.EJECT_WIND, SoundSource.PLAYERS, 0.5f, 1.0f, false);
            } else {
                ClientInputEvents.sendSyncAction(new VehicleSyncAction.DismountAction(false));
            }
        }
        if (cycleRadarMode = DSCKeys.radarModeKey.m_90859_()) {
            DSCClientInputs.cyclePreferredRadarMode();
            if (!isRadarController) {
                player.m_5661_((Component)UtilMCText.translatable((String)"info.dscombat.not_radar_controller"), true);
            }
        }
        if (isRadarController && DSCClientInputs.getPreferredRadarMode() != vehicle.getRadarMode() && Util.m_137550_() - radarModeUpdateTime > 500L) {
            ClientInputEvents.sendSyncAction(new VehicleSyncAction.SetRadarModeAction(DSCClientInputs.getPreferredRadarMode()));
            radarModeUpdateTime = Util.m_137550_();
        }
        if (DSCKeys.gimbalKey.m_90859_()) {
            DSCClientInputs.toggleGimbalMode();
        }
        if (DSCKeys.vehicleMenuKey.m_90859_()) {
            m.m_91152_((Screen)new VehicleMainScreen());
        }
        boolean leanLeft = DSCKeys.leanLeftKey.m_90859_();
        boolean leanRight = DSCKeys.leanRightKey.m_90859_();
        if (leanLeft && leanRight) {
            DSCClientInputs.leanNot();
        } else if (leanLeft) {
            DSCClientInputs.leanLeft();
        } else if (leanRight) {
            DSCClientInputs.leanRight();
        }
    }

    public static Vec3 getShootPos(Player player, EntityVehicle vehicle) {
        switch (DSCClientInputs.getTargetMode()) {
            case LOOK: {
                return ClientInputEvents.getLookPos(player, vehicle);
            }
            case COORDS: {
                return Config.CLIENT.getTargetPos();
            }
            case INDICATOR: {
                return Vec3.f_82478_;
            }
        }
        return Vec3.f_82478_;
    }

    public static Vec3 getLookPos(Player player, EntityVehicle vehicle) {
        EntityGimbal gimbal;
        Object looker = player;
        if (DSCClientInputs.isGimbalMode() && (gimbal = vehicle.getGimbalForPilotCamera()) != null) {
            looker = gimbal;
            looker.m_146926_(player.m_146909_());
            looker.m_146922_(player.m_146908_());
        }
        return UtilEntity.getLookingAtBlockPos((Entity)looker, (int)300);
    }

    private static boolean playerCanShoot(Player player) {
        return System.currentTimeMillis() - DSCClientInputs.getClientMountTime() > 500L && (!player.m_6117_() || player.m_21120_(player.m_7655_()).m_150930_(Items.f_42740_));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void clientMoveInput(MovementInputUpdateEvent event) {
        Player player = event.getEntity();
        if (!(player.m_20202_() instanceof EntityRidablePart)) {
            return;
        }
        if (((Boolean)Config.CLIENT.customDismount.get()).booleanValue()) {
            event.getInput().f_108573_ = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void playerMountSeat(EntityMountEvent event) {
        if (!event.isMounting()) {
            return;
        }
        Entity mounting = event.getEntityMounting();
        if (!mounting.f_19853_.f_46443_) {
            return;
        }
        if (!(mounting instanceof Player)) {
            return;
        }
        Entity mounted = event.getEntityBeingMounted();
        if (!(mounted instanceof EntityRidablePart)) {
            return;
        }
        DSCClientInputs.setClientMountTime(System.currentTimeMillis());
        DSCClientInputs.leanNot();
    }

    @SubscribeEvent
    public static void clientLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        DSCClientInputs.setPreferredRadarMode((RadarStats.RadarMode)((Object)Config.CLIENT.defaultRadarMode.get()));
    }

    public static void sendSyncAction(VehicleSyncAction action) {
        VehicleSyncAction.sendSyncAction(action);
    }
}

