/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.model.obj.customanims;

import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import com.onewhohears.dscombat.client.model.obj.customanims.VehicleModelTransforms;
import com.onewhohears.onewholibs.client.model.obj.customanims.CustomAnimsBuilder;
import com.onewhohears.onewholibs.client.model.obj.customanims.EntityModelTransform;
import com.onewhohears.onewholibs.util.UtilParse;

public class VehicleAnimsBuilder
extends CustomAnimsBuilder {
    public static VehicleAnimsBuilder create() {
        return new VehicleAnimsBuilder();
    }

    protected VehicleAnimsBuilder() {
    }

    public VehicleAnimsBuilder addMotorRotPixelAnim(String model_part_key, float pivotX, float pivotY, float pivotZ, EntityModelTransform.RotationAxis rot_axis, float rot_rate) {
        JsonObject anim = this.createAnimJson(model_part_key);
        anim.addProperty("anim_id", "motor_rotation");
        this.fillAxisRotationPixelParams(anim, pivotX, pivotY, pivotZ, rot_axis);
        anim.addProperty("rot_rate", (Number)Float.valueOf(rot_rate));
        return this;
    }

    public VehicleAnimsBuilder addWheelRotPixelAnim(String model_part_key, float pivotX, float pivotY, float pivotZ, EntityModelTransform.RotationAxis rot_axis, float rot_rate) {
        JsonObject anim = this.createAnimJson(model_part_key);
        anim.addProperty("anim_id", "wheel_rotation");
        this.fillAxisRotationPixelParams(anim, pivotX, pivotY, pivotZ, rot_axis);
        anim.addProperty("rot_rate", (Number)Float.valueOf(rot_rate));
        return this;
    }

    public VehicleAnimsBuilder addInputBoundRotPixelAnim(String model_part_key, float pivotX, float pivotY, float pivotZ, EntityModelTransform.RotationAxis rot_axis, VehicleModelTransforms.InputAxis input_axis, float bound) {
        JsonObject anim = this.createAnimJson(model_part_key);
        anim.addProperty("anim_id", "input_bound_rotation");
        this.fillAxisRotationPixelParams(anim, pivotX, pivotY, pivotZ, rot_axis);
        UtilParse.writeEnum((JsonObject)anim, (String)"input_axis", (Enum)input_axis);
        anim.addProperty("bound", (Number)Float.valueOf(bound));
        return this;
    }

    public VehicleAnimsBuilder addPlaneFlapRotPixelAnim(String model_part_key, float pivotX, float pivotY, float pivotZ, EntityModelTransform.RotationAxis rot_axis, VehicleModelTransforms.InputAxis input_axis, float bound) {
        JsonObject anim = this.createAnimJson(model_part_key);
        anim.addProperty("anim_id", "plane_flap_rotation");
        this.fillAxisRotationPixelParams(anim, pivotX, pivotY, pivotZ, rot_axis);
        UtilParse.writeEnum((JsonObject)anim, (String)"input_axis", (Enum)input_axis);
        anim.addProperty("bound", (Number)Float.valueOf(bound));
        return this;
    }

    public VehicleAnimsBuilder addJoystickPixelAnim(String model_part_key, float pivotX, float pivotY, float pivotZ, float boundX, float boundZ) {
        this.addInputBoundRotPixelAnim(model_part_key, pivotX, pivotY, pivotZ, EntityModelTransform.RotationAxis.X, VehicleModelTransforms.InputAxis.PITCH, -boundX);
        this.addInputBoundRotPixelAnim(model_part_key, pivotX, pivotY, pivotZ, EntityModelTransform.RotationAxis.Z, VehicleModelTransforms.InputAxis.ROLL, boundZ);
        return this;
    }

    public VehicleAnimsBuilder addSpinningRadarPixelAnim(String model_part_key, float pivotX, float pivotY, float pivotZ, EntityModelTransform.RotationAxis rot_axis, float rot_rate, String radar_id) {
        JsonObject anim = this.createAnimJson(model_part_key);
        anim.addProperty("anim_id", "spinning_radar");
        this.fillAxisRotationPixelParams(anim, pivotX, pivotY, pivotZ, rot_axis);
        anim.addProperty("rot_rate", (Number)Float.valueOf(rot_rate));
        anim.addProperty("radar_id", radar_id);
        return this;
    }

    public VehicleAnimsBuilder addLandingGearPixelAnim(String model_part_key, float pivotX, float pivotY, float pivotZ, EntityModelTransform.RotationAxis rot_axis, float fold_angle) {
        JsonObject anim = this.createAnimJson(model_part_key);
        anim.addProperty("anim_id", "landing_gear");
        this.fillAxisRotationPixelParams(anim, pivotX, pivotY, pivotZ, rot_axis);
        anim.addProperty("fold_angle", (Number)Float.valueOf(fold_angle));
        return this;
    }

    public VehicleAnimsBuilder addHitboxDestroyPartAnim(String hitbox_name, String model_part_key) {
        JsonObject anim = this.createAnimJson(model_part_key);
        anim.addProperty("anim_id", "hitbox_destroy_part");
        anim.addProperty("hitbox_name", hitbox_name);
        return this;
    }

    public VehicleAnimsBuilder addHitboxDestroyPartsAnim(String hitbox_name, String ... model_part_keys) {
        for (int i = 0; i < model_part_keys.length; ++i) {
            this.addHitboxDestroyPartAnim(hitbox_name, model_part_keys[i]);
        }
        return this;
    }

    public VehicleAnimsBuilder addInputBoundTransAnim(String model_part_key, float boundX, float boundY, float boundZ, VehicleModelTransforms.InputAxis input_axis) {
        JsonObject anim = this.createAnimJson(model_part_key);
        anim.addProperty("anim_id", "input_bound_translation");
        UtilParse.writeEnum((JsonObject)anim, (String)"input_axis", (Enum)input_axis);
        UtilParse.writeVec3f((JsonObject)anim, (String)"bounds", (Vector3f)new Vector3f(boundX, boundY, boundZ));
        return this;
    }
}

