/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.model.obj.customanims;

import com.google.gson.JsonObject;
import com.mojang.math.Matrix4f;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.RotableHitbox;
import com.onewhohears.onewholibs.client.model.obj.customanims.EntityModelTransform;
import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import net.minecraft.util.Mth;

public class VehicleModelTransforms {

    public static class TurretRotation<T extends EntityTurret>
    extends EntityModelTransform.AxisRotation<T> {
        private final boolean rotPitch;

        public TurretRotation(JsonObject data) {
            super(data);
            this.rotPitch = UtilParse.getBooleanSafe((JsonObject)data, (String)"rotPitch", (boolean)true);
        }

        public float getRotDeg(T turret, float partialTicks) {
            if (this.rotPitch) {
                return UtilAngles.lerpAngle180((float)partialTicks, (float)((EntityTurret)((Object)turret)).xRotRelO, (float)((EntityTurret)((Object)turret)).getRelRotX());
            }
            return UtilAngles.lerpAngle180((float)partialTicks, (float)((EntityTurret)((Object)turret)).yRotRelO, (float)((EntityTurret)((Object)turret)).getRelRotY());
        }
    }

    public static class LandingGear<T extends EntityVehicle>
    extends EntityModelTransform.AxisRotation<T> {
        private final float fold_angle;

        public LandingGear(JsonObject data) {
            super(data);
            this.fold_angle = UtilParse.getFloatSafe((JsonObject)data, (String)"fold_angle", (float)0.0f);
        }

        public float getFoldAngle() {
            return this.fold_angle;
        }

        public float getRotDeg(T entity, float partialTicks) {
            float gear = ((EntityVehicle)entity).getLandingGearPos(partialTicks);
            return Mth.m_14179_((float)gear, (float)0.0f, (float)this.fold_angle);
        }

        public Matrix4f getTransform(T entity, float partialTicks) {
            if (((EntityVehicle)entity).getLandingGearPos(partialTicks) == 1.0f) {
                return INVISIBLE;
            }
            return super.getTransform(entity, partialTicks);
        }
    }

    public static class SpinningRadar<T extends EntityVehicle>
    extends EntityModelTransform.ContinuousRotation<T> {
        private final String radar_id;

        public SpinningRadar(JsonObject data) {
            super(data);
            this.radar_id = UtilParse.getStringSafe((JsonObject)data, (String)"radar_id", (String)"");
        }

        public String getRadarId() {
            return this.radar_id;
        }

        public Matrix4f getTransform(T entity, float partialTicks) {
            if (!((EntityVehicle)entity).radarSystem.hasRadar(this.radar_id)) {
                return INVISIBLE;
            }
            return super.getTransform(entity, partialTicks);
        }
    }

    public static class PlaneFlapRotation<T extends EntityVehicle>
    extends InputBoundRotation<T> {
        public PlaneFlapRotation(JsonObject data) {
            super(data);
        }

        @Override
        public float getInput(T entity) {
            if (((EntityVehicle)entity).isFlapsDown()) {
                return -1.0f * Math.signum(this.getBound());
            }
            return this.getInputAxis().getVehicleInput((EntityVehicle)entity);
        }
    }

    public static class InputBoundRotation<T extends EntityVehicle>
    extends EntityModelTransform.AxisRotation<T> {
        private final InputAxis input_axis;
        private final float bound;

        public InputBoundRotation(JsonObject data) {
            super(data);
            this.input_axis = (InputAxis)UtilParse.getEnumSafe((JsonObject)data, (String)"input_axis", InputAxis.class);
            this.bound = UtilParse.getFloatSafe((JsonObject)data, (String)"bound", (float)0.0f);
        }

        public InputAxis getInputAxis() {
            return this.input_axis;
        }

        public float getBound() {
            return this.bound;
        }

        public float getInput(T entity) {
            return this.getInputAxis().getVehicleInput((EntityVehicle)entity);
        }

        public float getRotDeg(T entity, float partialTicks) {
            return this.getInput(entity) * this.getBound();
        }
    }

    public static enum InputAxis {
        PITCH(entity -> entity.inputs.pitch),
        YAW(entity -> entity.inputs.yaw),
        ROLL(entity -> entity.inputs.roll),
        THROTTLE(EntityVehicle::getCurrentThrottle);

        private final InputFactory input;

        private InputAxis(InputFactory input) {
            this.input = input;
        }

        public float getVehicleInput(EntityVehicle entity) {
            return this.input.get(entity);
        }
    }

    private static interface InputFactory {
        public float get(EntityVehicle var1);
    }

    public static class WheelRotation<T extends EntityVehicle>
    extends EntityModelTransform.ContinuousRotation<T> {
        public WheelRotation(JsonObject data) {
            super(data);
        }

        public float getRotDeg(T entity, float partialTicks) {
            return ((EntityVehicle)entity).getWheelRotation(partialTicks, this.getRotRate());
        }
    }

    public static class MotorRotation<T extends EntityVehicle>
    extends EntityModelTransform.ContinuousRotation<T> {
        public MotorRotation(JsonObject data) {
            super(data);
        }

        public float getRotDeg(T entity, float partialTicks) {
            return ((EntityVehicle)entity).getMotorRotation(partialTicks, this.getRotRate());
        }
    }

    public static class HitboxDestroyPart<T extends EntityVehicle>
    extends EntityModelTransform<T> {
        private final String hitbox_name;

        public HitboxDestroyPart(JsonObject data) {
            super(data);
            this.hitbox_name = UtilParse.getStringSafe((JsonObject)data, (String)"hitbox_name", (String)"");
        }

        public String getHitboxName() {
            return this.hitbox_name;
        }

        public Matrix4f getTransform(T entity, float partialTicks) {
            RotableHitbox hitbox = ((EntityVehicle)entity).getHitboxByName(this.getHitboxName());
            if (hitbox == null) {
                return NOTHING;
            }
            return hitbox.isDestroyed() ? INVISIBLE : NOTHING;
        }
    }

    public static class InputBoundTranslation<T extends EntityVehicle>
    extends EntityModelTransform.Translation<T> {
        private final InputAxis input_axis;

        public InputBoundTranslation(JsonObject data) {
            super(data);
            this.input_axis = (InputAxis)UtilParse.getEnumSafe((JsonObject)data, (String)"input_axis", InputAxis.class);
        }

        public InputAxis getInputAxis() {
            return this.input_axis;
        }

        public float getTranslationProgress(T entity, float partialTicks) {
            return this.getInputAxis().getVehicleInput((EntityVehicle)entity);
        }
    }
}

