/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.client.overlay.components.AimAssistOverlay;
import com.onewhohears.dscombat.client.overlay.components.DebugOverlay;
import com.onewhohears.dscombat.client.overlay.components.HudOverlay;
import com.onewhohears.dscombat.client.overlay.components.KeyBindsOverlay;
import com.onewhohears.dscombat.client.overlay.components.PlaneDataOverlay;
import com.onewhohears.dscombat.client.overlay.components.PosRangeOverlay;
import com.onewhohears.dscombat.client.overlay.components.RadarOverlay;
import com.onewhohears.dscombat.client.overlay.components.VehicleCompassOverlay;
import com.onewhohears.dscombat.client.overlay.components.VehicleControlOverlay;
import com.onewhohears.dscombat.client.overlay.components.VehicleStatsOverlay;
import com.onewhohears.dscombat.client.overlay.components.VehicleThrottleOverlay;
import com.onewhohears.dscombat.client.overlay.components.VehicleWeaponsOverlay;
import java.lang.ref.WeakReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class VehicleOverlayComponent
extends GuiComponent {
    protected static boolean HIDE_GUI = Minecraft.m_91087_().f_91066_.f_92062_;
    protected static Font FONT = Minecraft.m_91087_().f_91062_;
    @Nullable
    protected static WeakReference<Entity> ROOT_VEHICLE;
    @Nullable
    protected static WeakReference<Entity> VEHICLE;
    protected static final int PADDING = 1;

    @Nullable
    protected static LocalPlayer getPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @Nullable
    protected static Entity getPlayerRootVehicle() {
        if (ROOT_VEHICLE != null) {
            return (Entity)ROOT_VEHICLE.get();
        }
        return null;
    }

    @Nullable
    protected static Entity getPlayerVehicle() {
        if (VEHICLE != null) {
            return (Entity)VEHICLE.get();
        }
        return null;
    }

    protected static boolean isInSpectator() {
        if (Minecraft.m_91087_().f_91072_ == null) {
            return true;
        }
        return Minecraft.m_91087_().f_91072_.m_105295_() == GameType.SPECTATOR;
    }

    protected static boolean defaultRenderConditions() {
        if (HIDE_GUI) {
            return true;
        }
        return VehicleOverlayComponent.isInSpectator();
    }

    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        VehicleOverlayComponent[] tempArray;
        for (VehicleOverlayComponent overlay : tempArray = new VehicleOverlayComponent[]{ManagerTicker.INSTANCE, new AimAssistOverlay(), new DebugOverlay(), new HudOverlay(), new KeyBindsOverlay(), new PlaneDataOverlay(), new RadarOverlay(), new VehicleCompassOverlay(), new VehicleControlOverlay(), new VehicleStatsOverlay(), new VehicleThrottleOverlay(), new VehicleWeaponsOverlay(), new PosRangeOverlay()}) {
            event.registerBelowAll(overlay.componentId(), overlay::register);
        }
    }

    final void register(ForgeGui gui, PoseStack stack, float partialTick, int screenWidth, int screenHeight) {
        if (!this.shouldRender(gui, stack, partialTick, screenWidth, screenHeight)) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.render(gui, stack, partialTick, screenWidth, screenHeight);
    }

    protected abstract boolean shouldRender(ForgeGui var1, PoseStack var2, float var3, int var4, int var5);

    protected abstract void render(ForgeGui var1, PoseStack var2, float var3, int var4, int var5);

    @NotNull
    protected abstract String componentId();

    static class ManagerTicker
    extends VehicleOverlayComponent {
        static VehicleOverlayComponent INSTANCE = new ManagerTicker();

        ManagerTicker() {
        }

        @Override
        protected boolean shouldRender(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
            ROOT_VEHICLE = ManagerTicker.getPlayer() != null ? new WeakReference<Entity>(ManagerTicker.getPlayer().m_20201_()) : null;
            VEHICLE = ManagerTicker.getPlayer() != null ? new WeakReference<Entity>(ManagerTicker.getPlayer().m_20202_()) : null;
            return false;
        }

        @Override
        protected void render(ForgeGui gui, PoseStack stack, float partialTick, int screenWidth, int screenHeight) {
        }

        @Override
        @NotNull
        protected String componentId() {
            return "dscombat_overlay_manager";
        }
    }
}

