/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.input.DSCKeys;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.parts.EntityRidablePart;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilMCText;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.jetbrains.annotations.NotNull;

public class KeyBindsOverlay
extends VehicleOverlayComponent {
    private static final int DEFAULT_KEY_COLOR = 65280;
    private static final int USE_KEY_COLOR = 0xFFFF00;
    private static final int MAPPING_NAME_WIDTH = 80;
    private static final int KEY_NAME_WIDTH = 40;

    public static Component fixKeyName(KeyMapping key) {
        return switch (key.getKey().m_84873_()) {
            case 345 -> UtilMCText.literal((String)"R-CTRL");
            case 341 -> UtilMCText.literal((String)"L-CTRL");
            case 342 -> UtilMCText.literal((String)"L-ALT");
            case 346 -> UtilMCText.literal((String)"R-ALT");
            default -> key.getKey().m_84875_();
        };
    }

    protected void displayMapping(PoseStack poseStack, int screenWidth, int screenHeight, int index, KeyMapping key, Component mapName, boolean isUsed, String setting) {
        int pY = 2 + 10 * index;
        int pX = 3;
        int pColor = 65280;
        if (isUsed) {
            pColor = 0xFFFF00;
        }
        KeyBindsOverlay.m_93243_((PoseStack)poseStack, (Font)FONT, (Component)mapName, (int)pX, (int)pY, (int)pColor);
        KeyBindsOverlay.m_93243_((PoseStack)poseStack, (Font)FONT, (Component)KeyBindsOverlay.fixKeyName(key), (int)(pX += 80), (int)pY, (int)pColor);
        if (setting == null || setting.isEmpty()) {
            return;
        }
        KeyBindsOverlay.m_93236_((PoseStack)poseStack, (Font)FONT, (String)setting, (int)(pX += 40), (int)pY, (int)pColor);
    }

    protected void displayMapping(PoseStack poseStack, int screenWidth, int screenHeight, int index, KeyMapping key, boolean isUsed, String setting) {
        this.displayMapping(poseStack, screenWidth, screenHeight, index, key, (Component)UtilMCText.translatable((String)key.m_90860_()), isUsed, setting);
    }

    protected void displayMapping(PoseStack poseStack, int screenWidth, int screenHeight, int index, KeyMapping key) {
        this.displayMapping(poseStack, screenWidth, screenHeight, index, key, key.m_90857_(), null);
    }

    protected void displayMapping(PoseStack poseStack, int screenWidth, int screenHeight, int index, KeyMapping key, String setting) {
        this.displayMapping(poseStack, screenWidth, screenHeight, index, key, key.m_90857_(), setting);
    }

    protected void displayMapping(PoseStack poseStack, int screenWidth, int screenHeight, int index, KeyMapping key, Component mapName, boolean isUsed) {
        this.displayMapping(poseStack, screenWidth, screenHeight, index, key, mapName, isUsed, null);
    }

    protected void displayMapping(PoseStack poseStack, int screenWidth, int screenHeight, int index, KeyMapping key, Component mapName) {
        this.displayMapping(poseStack, screenWidth, screenHeight, index, key, mapName, key.m_90857_(), null);
    }

    @Override
    protected boolean shouldRender(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (KeyBindsOverlay.defaultRenderConditions()) {
            return false;
        }
        Entity entity = KeyBindsOverlay.getPlayerVehicle();
        if (!(entity instanceof EntityRidablePart)) {
            return false;
        }
        EntityRidablePart seat = (EntityRidablePart)entity;
        EntityVehicle vehicle = seat.getParentVehicle();
        return vehicle != null;
    }

    @Override
    protected void render(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        EntityRidablePart seat = (EntityRidablePart)KeyBindsOverlay.getPlayerVehicle();
        assert (seat != null);
        EntityVehicle vehicle = seat.getParentVehicle();
        assert (vehicle != null);
        boolean isPilot = seat.isPilotSeat();
        boolean isCoPilot = seat.isCoPilotSeat();
        int index = 0;
        if (isPilot) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, DSCKeys.mouseModeKey, !DSCClientInputs.getMouseMode().isLockedForward(), DSCClientInputs.getMouseMode().name());
        }
        this.displayMapping(poseStack, screenWidth, screenHeight, index++, DSCKeys.vehicleMenuKey);
        if (((Boolean)Config.CLIENT.customDismount.get()).booleanValue()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, DSCKeys.dismount);
        }
        if (seat.canEject()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, DSCKeys.eject);
        }
        this.displayMapping(poseStack, screenWidth, screenHeight, index++, DSCKeys.changeSeat);
        if (isPilot && vehicle.canToggleLandingGear()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, DSCKeys.landingGear, vehicle.isLandingGear(), vehicle.isLandingGear() ? "OUT" : "IN");
        }
        if (isPilot && vehicle.canBrake()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, ((VehicleStats)vehicle.getStats()).isPlane() ? DSCKeys.special2Key : DSCKeys.specialKey, (Component)UtilMCText.translatable((String)"info.dscombat.breaks"), vehicle.isBraking());
        }
        if (isPilot && vehicle.canFlapsDown()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, DSCKeys.specialKey, (Component)UtilMCText.translatable((String)"info.dscombat.flaps_down"));
        }
        if (isPilot && vehicle.canAngleWeaponDown()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, DSCKeys.special2Key, (Component)UtilMCText.translatable((String)"info.dscombat.nose_down"));
        }
        if (isPilot && vehicle.canHover()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, DSCKeys.specialKey, (Component)UtilMCText.translatable((String)"info.dscombat.hover"));
        }
        if (isPilot && vehicle.hasFlares()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, DSCKeys.flareKey, "" + vehicle.getFlareNum());
        }
        if (isPilot || isCoPilot) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, DSCKeys.weaponSelectKey);
        }
        if (vehicle.radarSystem.hasRadar()) {
            boolean warning = DSCClientInputs.getPreferredRadarMode() != vehicle.getRadarMode();
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, DSCKeys.radarModeKey, warning, DSCClientInputs.getPreferredRadarMode().name());
        }
        if (vehicle.radarSystem.hasRadar()) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, DSCKeys.pingCycleKey);
        }
        if (vehicle.getGimbalForPilotCamera() != null || seat.getCameraYOffset() != 0.0f) {
            this.displayMapping(poseStack, screenWidth, screenHeight, index++, DSCKeys.gimbalKey, DSCClientInputs.isGimbalMode(), DSCClientInputs.isGimbalMode() ? "ON" : "OFF");
        }
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_key_binds";
    }
}

