/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.RotableHitbox;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;

public interface RotableHitboxRenderer {
    public static final int[] DEFAULT_COLOR = new int[]{188, 85, 41, 255};
    public static final int[] DESTROYED_COLOR = new int[]{120, 0, 0, 255};

    default public boolean shouldDrawRotableHitboxes(EntityVehicle entity) {
        if (entity.m_20145_() || entity.getHitboxes().size() == 0) {
            return false;
        }
        Minecraft m = Minecraft.m_91087_();
        return !m.m_91299_() && m.m_91290_().m_114377_();
    }

    default public void drawRotableHitboxeOutlines(EntityVehicle entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource) {
        VertexConsumer buff = bufferSource.m_6299_(RenderType.m_110504_());
        Quaternion q = UtilAngles.lerpQ((float)partialTicks, (Quaternion)entity.getPrevQ(), (Quaternion)entity.getClientQ());
        for (RotableHitbox hitbox : entity.getHitboxes()) {
            this.drawRotableHitboxOutline(hitbox, poseStack, buff, q);
        }
    }

    private void drawRotableHitboxOutline(RotableHitbox hitbox, PoseStack poseStack, VertexConsumer buff, Quaternion q) {
        poseStack.m_85836_();
        Vec3 trans = UtilAngles.rotateVector((Vec3)hitbox.getRelPos(), (Quaternion)q);
        poseStack.m_85837_(trans.f_82479_, trans.f_82480_, trans.f_82481_);
        Matrix4f m4 = poseStack.m_85850_().m_85861_();
        Matrix3f m3 = poseStack.m_85850_().m_85864_();
        Vector3f ext = UtilGeometry.convertVector((Vec3)hitbox.getHitbox().getExtents());
        Vector3f c0 = ext.m_122281_();
        c0.m_122251_(q);
        Vector3f c1 = ext.m_122281_();
        c1.m_122263_(-1.0f, 1.0f, 1.0f);
        c1.m_122251_(q);
        Vector3f c2 = ext.m_122281_();
        c2.m_122263_(1.0f, -1.0f, 1.0f);
        c2.m_122251_(q);
        Vector3f c3 = ext.m_122281_();
        c3.m_122263_(1.0f, 1.0f, -1.0f);
        c3.m_122251_(q);
        Vector3f c4 = c3.m_122281_();
        c4.m_122261_(-1.0f);
        Vector3f c5 = c2.m_122281_();
        c5.m_122261_(-1.0f);
        Vector3f c6 = c1.m_122281_();
        c6.m_122261_(-1.0f);
        Vector3f c7 = c0.m_122281_();
        c7.m_122261_(-1.0f);
        int[] color = hitbox.isDestroyed() ? DESTROYED_COLOR : DEFAULT_COLOR;
        this.addLine(c0, c1, buff, m4, m3, color);
        this.addLine(c0, c2, buff, m4, m3, color);
        this.addLine(c0, c3, buff, m4, m3, color);
        this.addLine(c1, c5, buff, m4, m3, color);
        this.addLine(c1, c4, buff, m4, m3, color);
        this.addLine(c2, c4, buff, m4, m3, color);
        this.addLine(c2, c6, buff, m4, m3, color);
        this.addLine(c3, c5, buff, m4, m3, color);
        this.addLine(c3, c6, buff, m4, m3, color);
        this.addLine(c4, c7, buff, m4, m3, color);
        this.addLine(c5, c7, buff, m4, m3, color);
        this.addLine(c6, c7, buff, m4, m3, color);
        poseStack.m_85849_();
    }

    private void addLine(Vector3f start, Vector3f end, VertexConsumer buff, Matrix4f m4, Matrix3f m3, int[] color) {
        Vector3f n = end.m_122281_();
        n.m_122267_(start);
        n.m_122278_();
        buff.m_85982_(m4, start.m_122239_(), start.m_122260_(), start.m_122269_()).m_6122_(color[0], color[1], color[2], color[3]).m_85977_(m3, n.m_122239_(), n.m_122260_(), n.m_122269_()).m_5752_();
        buff.m_85982_(m4, end.m_122239_(), end.m_122260_(), end.m_122269_()).m_6122_(color[0], color[1], color[2], color[3]).m_85977_(m3, n.m_122239_(), n.m_122260_(), n.m_122269_()).m_5752_();
    }
}

