/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.command;

import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.onewholibs.common.command.CustomGameRules;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public class DSCGameRules {
    public static GameRules.Key<GameRules.BooleanValue> CONSUME_FULE;
    public static GameRules.Key<GameRules.BooleanValue> CONSUME_AMMO;
    public static GameRules.Key<GameRules.BooleanValue> CONSUME_FLARES;
    public static GameRules.Key<GameRules.IntegerValue> FUEL_PER_OIL_BLOCK;
    public static GameRules.Key<GameRules.BooleanValue> DATA_LINK_ALWAYS_ON;
    public static GameRules.Key<GameRules.BooleanValue> DISABLE_ELYTRA_FLYING;
    public static GameRules.Key<GameRules.IntegerValue> ITEM_COOLDOWN_VEHICLE_FRESH;
    public static GameRules.Key<GameRules.IntegerValue> ITEM_COOLDOWN_VEHICLE_SHOOT;
    public static GameRules.Key<GameRules.BooleanValue> BROADCAST_MISSILE_HIT;
    public static GameRules.Key<GameRules.BooleanValue> BROADCAST_MISSILE_HIT_TEAM_ONLY;
    public static GameRules.Key<GameRules.BooleanValue> MOBS_USE_TURRETS;
    public static GameRules.Key<GameRules.IntegerValue> MOB_TURRET_VERTICAL_RANGE;
    public static GameRules.Key<GameRules.BooleanValue> MOBS_TICK_RADAR;
    public static GameRules.Key<GameRules.BooleanValue> MOBS_RIDE_VEHICLES;
    public static GameRules.Key<GameRules.IntegerValue> VEHICLE_ARMOR_PERCENT;
    public static GameRules.Key<GameRules.IntegerValue> BULLET_DAMAGE_VEHICLE_PER;
    public static GameRules.Key<GameRules.IntegerValue> EXPLO_DAMAGE_VEHICLE_PER;
    public static GameRules.Key<GameRules.IntegerValue> BULLET_DAMAGE_PLANE_PER;
    public static GameRules.Key<GameRules.IntegerValue> BULLET_DAMAGE_HELI_PER;
    public static GameRules.Key<GameRules.BooleanValue> DISABLE_3RD_PERSON_VEHICLE;
    public static GameRules.Key<GameRules.BooleanValue> PLANE_ARCADE_MODE;
    public static GameRules.Key<GameRules.IntegerValue> REMOVE_DEAD_VEHICLES_TIME;
    public static GameRules.Key<GameRules.BooleanValue> WEAPONS_BREAK_BLOCKS;
    public static GameRules.Key<GameRules.BooleanValue> VEHICLE_TRAMPLE;
    public static GameRules.Key<GameRules.BooleanValue> FORCE_PUBLIC_PERM;
    public static GameRules.Key<GameRules.BooleanValue> CAN_ITEM_WHILE_MOVING;

    public static void registerAll() {
        CONSUME_FULE = CustomGameRules.registerBoolean((String)"consumeFuel", (boolean)true, (GameRules.Category)GameRules.Category.PLAYER);
        CONSUME_AMMO = CustomGameRules.registerBoolean((String)"consumeAmmo", (boolean)true, (GameRules.Category)GameRules.Category.PLAYER);
        CONSUME_FLARES = CustomGameRules.registerBoolean((String)"consumeFlares", (boolean)true, (GameRules.Category)GameRules.Category.PLAYER);
        FUEL_PER_OIL_BLOCK = CustomGameRules.registerInteger((String)"fuelPerOilBlock", (int)50, (GameRules.Category)GameRules.Category.PLAYER);
        DATA_LINK_ALWAYS_ON = CustomGameRules.registerBoolean((String)"dataLinkAlwaysOn", (boolean)false, (GameRules.Category)GameRules.Category.PLAYER);
        DISABLE_ELYTRA_FLYING = CustomGameRules.registerBoolean((String)"disableElytraFlying", (boolean)false, (GameRules.Category)GameRules.Category.PLAYER);
        ITEM_COOLDOWN_VEHICLE_FRESH = CustomGameRules.registerInteger((String)"itemCooldownVehicleFresh", (int)0, (GameRules.Category)GameRules.Category.PLAYER);
        ITEM_COOLDOWN_VEHICLE_SHOOT = CustomGameRules.registerInteger((String)"itemCooldownVehicleShoot", (int)30, (GameRules.Category)GameRules.Category.PLAYER);
        BROADCAST_MISSILE_HIT = CustomGameRules.registerBoolean((String)"broadcastMissileHit", (boolean)true, (GameRules.Category)GameRules.Category.CHAT);
        BROADCAST_MISSILE_HIT_TEAM_ONLY = CustomGameRules.registerBoolean((String)"broadcastMissileHitTeamOnly", (boolean)false, (GameRules.Category)GameRules.Category.CHAT);
        MOBS_USE_TURRETS = CustomGameRules.registerBoolean((String)"mobsUseTurrets", (boolean)true, (GameRules.Category)GameRules.Category.MOBS);
        MOB_TURRET_VERTICAL_RANGE = CustomGameRules.registerInteger((String)"mobTurretVerticalRange", (int)500, (GameRules.Category)GameRules.Category.MOBS);
        MOBS_TICK_RADAR = CustomGameRules.registerBoolean((String)"mobsTickRadar", (boolean)true, (GameRules.Category)GameRules.Category.MOBS);
        MOBS_RIDE_VEHICLES = CustomGameRules.registerBoolean((String)"mobsRideVehicles", (boolean)true, (GameRules.Category)GameRules.Category.MOBS);
        VEHICLE_ARMOR_PERCENT = CustomGameRules.registerInteger((String)"vehicleArmorStrengthPercent", (int)100, (GameRules.Category)GameRules.Category.PLAYER);
        BULLET_DAMAGE_VEHICLE_PER = CustomGameRules.registerInteger((String)"bulletDamageVehiclePercent", (int)50, (GameRules.Category)GameRules.Category.PLAYER);
        EXPLO_DAMAGE_VEHICLE_PER = CustomGameRules.registerInteger((String)"explosionDamageVehiclePercent", (int)300, (GameRules.Category)GameRules.Category.PLAYER);
        BULLET_DAMAGE_PLANE_PER = CustomGameRules.registerInteger((String)"bulletDamagePlanePercent", (int)100, (GameRules.Category)GameRules.Category.PLAYER);
        BULLET_DAMAGE_HELI_PER = CustomGameRules.registerInteger((String)"bulletDamageHeliPercent", (int)100, (GameRules.Category)GameRules.Category.PLAYER);
        DISABLE_3RD_PERSON_VEHICLE = CustomGameRules.registerSyncBoolean((String)"disable3rdPersonVehicle", (boolean)false, (GameRules.Category)GameRules.Category.PLAYER);
        PLANE_ARCADE_MODE = CustomGameRules.registerSyncBoolean((String)"planeArcadeMode", (boolean)false, (GameRules.Category)GameRules.Category.PLAYER);
        REMOVE_DEAD_VEHICLES_TIME = CustomGameRules.registerInteger((String)"removeDeadVehiclesTime", (int)-1, (GameRules.Category)GameRules.Category.PLAYER);
        WEAPONS_BREAK_BLOCKS = CustomGameRules.registerSyncBoolean((String)"weaponsBreakBlocks", (boolean)true, (GameRules.Category)GameRules.Category.PLAYER);
        VEHICLE_TRAMPLE = CustomGameRules.registerSyncBoolean((String)"vehicleTrample", (boolean)true, (GameRules.Category)GameRules.Category.PLAYER);
        FORCE_PUBLIC_PERM = CustomGameRules.registerSyncBoolean((String)"vehicleForcePublicPerm", (boolean)false, (GameRules.Category)GameRules.Category.PLAYER);
        CAN_ITEM_WHILE_MOVING = CustomGameRules.registerBoolean((String)"canVehicleItemWhileMoving", (boolean)false, (GameRules.Category)GameRules.Category.PLAYER);
    }

    public static boolean isPlaneArcadeMode(Level level) {
        if (level.m_5776_()) {
            return DSCClientInputs.planeArcadePhysicsMode;
        }
        return level.m_46469_().m_46207_(PLANE_ARCADE_MODE);
    }

    public static float getVehicleArmorStrengthFactor(Level level) {
        return (float)level.m_46469_().m_46215_(VEHICLE_ARMOR_PERCENT) * 0.01f;
    }

    public static float getBulletDamageVehicleFactor(Level level) {
        return (float)level.m_46469_().m_46215_(BULLET_DAMAGE_VEHICLE_PER) * 0.01f;
    }

    public static float getExplodeDamagerVehicleFactor(Level level) {
        return (float)level.m_46469_().m_46215_(EXPLO_DAMAGE_VEHICLE_PER) * 0.01f;
    }

    public static float getBulletDamagePlaneFactor(Level level) {
        return (float)level.m_46469_().m_46215_(BULLET_DAMAGE_PLANE_PER) * 0.01f;
    }

    public static float getBulletDamageHeliFactor(Level level) {
        return (float)level.m_46469_().m_46215_(BULLET_DAMAGE_HELI_PER) * 0.01f;
    }

    public static int getFuelPerOilBlock(Level level) {
        return level.m_46469_().m_46215_(FUEL_PER_OIL_BLOCK);
    }

    public static boolean isForcePublicPerm(Level level) {
        return level.m_46469_().m_46207_(FORCE_PUBLIC_PERM);
    }
}

