/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.onewhohears.dscombat.command.argument.WeaponArgument;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.weapon.EntityMissile;
import com.onewhohears.dscombat.entity.weapon.EntityWeapon;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class MissileCommand {
    public MissileCommand(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"missile").requires(stack -> stack.m_6761_(2))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> this.testMissile((CommandContext<CommandSourceStack>)context, EntityArgument.m_91461_((CommandContext)context, (String)"target"), Vec3Argument.m_120844_((CommandContext)context, (String)"pos"), null, null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"weapon", (ArgumentType)WeaponArgument.weapon()).executes(context -> this.testMissile((CommandContext<CommandSourceStack>)context, EntityArgument.m_91461_((CommandContext)context, (String)"target"), Vec3Argument.m_120844_((CommandContext)context, (String)"pos"), WeaponArgument.getWeapon((CommandContext<CommandSourceStack>)context, "weapon"), null))).then(Commands.m_82129_((String)"owner", (ArgumentType)EntityArgument.m_91449_()).executes(context -> this.testMissile((CommandContext<CommandSourceStack>)context, EntityArgument.m_91461_((CommandContext)context, (String)"target"), Vec3Argument.m_120844_((CommandContext)context, (String)"pos"), WeaponArgument.getWeapon((CommandContext<CommandSourceStack>)context, "weapon"), EntityArgument.m_91452_((CommandContext)context, (String)"owner"))))))));
    }

    /*
     * WARNING - void declaration
     */
    private int testMissile(CommandContext<CommandSourceStack> context, Collection<? extends Entity> targets, Vec3 pos, WeaponStats weaponStats, Entity owner) throws CommandSyntaxException {
        String defaultId = "aim120b";
        if (weaponStats == null) {
            weaponStats = WeaponPresets.get().get(defaultId);
        }
        if (weaponStats == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)UtilMCText.translatable((String)"error.dscombat.default_weapon_not_exist", (Object[])new Object[]{defaultId}));
            return 0;
        }
        WeaponInstance<?> weapon = weaponStats.createWeaponInstance();
        int i = 0;
        for (Entity entity : targets) {
            void var10_10;
            Vec3 dp = entity.m_20182_().m_82546_(pos).m_82541_();
            EntityWeapon<?> ew = weapon.getEntity(entity.f_19853_);
            ew.m_5602_(owner);
            ew.m_146884_(pos);
            weapon.setDirection(ew, dp);
            if (ew instanceof EntityMissile) {
                EntityMissile missile = (EntityMissile)ew;
                Entity v = entity.m_20201_();
                if (v != null) {
                    Entity entity2 = v;
                }
                missile.target = var10_10;
                missile.targetPos = var10_10.m_20182_();
            }
            var10_10.f_19853_.m_7967_(ew);
            ++i;
        }
        if (i == 0) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)UtilMCText.translatable((String)"error.dscombat.no_targets_found"));
        } else if (i > 0) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)UtilMCText.translatable((String)"success.dscombat.launched_missile", (Object[])new Object[]{i}), true);
        }
        return 1;
    }
}

