/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toclient;

import com.onewhohears.dscombat.common.network.IPacket;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.dscombat.util.UtilClientPacket;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ToClientAddPart
extends IPacket {
    public final int id;
    public final String slotId;
    public final PartInstance<?> data;

    public ToClientAddPart(int id, String slotId, PartInstance<?> data) {
        this.id = id;
        this.slotId = slotId;
        this.data = data;
    }

    public ToClientAddPart(FriendlyByteBuf buffer) {
        super(buffer);
        this.id = buffer.readInt();
        this.slotId = buffer.m_130277_();
        this.data = (PartInstance)((Object)DataSerializers.PART_DATA.m_6709_(buffer));
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        buffer.m_130070_(this.slotId);
        DataSerializers.PART_DATA.m_6856_(buffer, this.data);
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            UtilClientPacket.addPartPacket(this.id, this.slotId, this.data);
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

