/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toclient;

import com.onewhohears.dscombat.common.network.IPacket;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.util.UtilClientPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ToClientRadarPings
extends IPacket {
    public final int id;
    public final List<RadarStats.RadarPing> pings;

    public ToClientRadarPings(int id, List<RadarStats.RadarPing> pings) {
        this.id = id;
        this.pings = pings;
    }

    public ToClientRadarPings(FriendlyByteBuf buffer) {
        this.id = buffer.readInt();
        this.pings = new ArrayList<RadarStats.RadarPing>();
        int num = buffer.readInt();
        for (int i = 0; i < num; ++i) {
            this.pings.add(new RadarStats.RadarPing(buffer));
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        buffer.writeInt(this.pings.size());
        for (int i = 0; i < this.pings.size(); ++i) {
            this.pings.get(i).write(buffer);
        }
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            UtilClientPacket.pingsPacket(this.id, this.pings);
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

