/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toclient;

import com.onewhohears.dscombat.common.network.IPacket;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.util.UtilClientPacket;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ToClientSyncPart
extends IPacket {
    private final int id;
    private final String slotId;
    private PartInstance<?> instance;
    private FriendlyByteBuf buffer;

    public ToClientSyncPart(EntityVehicle vehicle, PartInstance<?> instance) {
        this.id = vehicle.m_19879_();
        this.slotId = instance.getSlotId();
        this.instance = instance;
    }

    public ToClientSyncPart(FriendlyByteBuf buffer) {
        super(buffer);
        this.id = buffer.readInt();
        this.slotId = buffer.m_130277_();
        buffer.m_130277_();
        this.buffer = buffer;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        buffer.m_130070_(this.slotId);
        this.instance.writeBuffer(buffer);
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            UtilClientPacket.syncPartPacket(this.id, this.slotId, this.buffer);
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

