/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toclient;

import com.onewhohears.dscombat.common.network.IPacket;
import com.onewhohears.dscombat.data.vehicle.VehicleInputManager;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.util.UtilClientPacket;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ToClientVehicleControl
extends IPacket {
    public final int id;
    public final VehicleInputManager inputs;

    public ToClientVehicleControl(EntityVehicle plane) {
        this.id = plane.m_19879_();
        this.inputs = plane.inputs;
    }

    public ToClientVehicleControl(FriendlyByteBuf buffer) {
        this.id = buffer.readInt();
        this.inputs = new VehicleInputManager(buffer);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        this.inputs.write(buffer);
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            UtilClientPacket.aircraftInputsPacket(this.id, this.inputs);
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

