/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toserver;

import com.onewhohears.dscombat.common.network.IPacket;
import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.common.network.toclient.ToClientVehicleTexture;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ToServerVehicleTexture
extends IPacket {
    public final int id;
    private EntityVehicle vehicle;
    private ByteBuf buffer;

    public ToServerVehicleTexture(EntityVehicle vehicle) {
        this.id = vehicle.m_19879_();
        this.vehicle = vehicle;
    }

    public ToServerVehicleTexture(FriendlyByteBuf buffer) {
        this.id = buffer.readInt();
        this.buffer = buffer.copy().asReadOnly();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        this.vehicle.textureManager.write(buffer);
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            success.set(true);
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            ServerLevel level = player.m_9236_();
            Entity patt1527$temp = level.m_6815_(this.id);
            if (patt1527$temp instanceof EntityVehicle) {
                EntityVehicle vehicle = (EntityVehicle)patt1527$temp;
                vehicle.textureManager.read(this.buffer);
                PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> vehicle), (Object)new ToClientVehicleTexture((Player)player, vehicle));
            }
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

