/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.graph;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.graph.GraphType;
import com.onewhohears.dscombat.data.graph.MultiGraph;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import net.minecraft.resources.ResourceLocation;

public class FFMultiGraph
extends MultiGraph<Float, Float> {
    private final Float[] keys = new Float[this.getSize()];
    private final Float[][] values = new Float[this.getRows()][this.getSize()];

    public FFMultiGraph(ResourceLocation key, JsonObject json) {
        super(key, json);
        JsonArray keyJA = json.get("keys").getAsJsonArray();
        JsonArray valueJA = json.get("values").getAsJsonArray();
        for (int i = 0; i < this.getSize(); ++i) {
            this.keys[i] = Float.valueOf(keyJA.get(i).getAsFloat());
            for (int j = 0; j < this.getRows(); ++j) {
                this.values[j][i] = Float.valueOf(valueJA.get(j).getAsJsonArray().get(i).getAsFloat());
            }
        }
    }

    public Float[] getValues(int row) {
        if (row < 0) {
            row = 0;
        } else if (row >= this.values.length) {
            row = this.values.length - 1;
        }
        return this.values[row];
    }

    public Float[] getKeys() {
        return this.keys;
    }

    public Float[] getValues() {
        return this.getValues(0);
    }

    public float getLerpFloat(float key, int row) {
        return this.getLerpFloat(key, this.getValues(row));
    }

    @Override
    public boolean isFloatLessThan(float a, Float b) {
        return a < b.floatValue();
    }

    public JsonPresetType getType() {
        return GraphType.FLOATFLOAT_MULTI;
    }

    public JsonPresetInstance<?> createPresetInstance() {
        return null;
    }
}

