/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts.instance;

import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.stats.EngineStats;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;

public class EngineInstance<T extends EngineStats>
extends PartInstance<T> {
    public EngineInstance(T stats) {
        super(stats);
    }

    @Override
    public float getPushThrust(VehicleStats vehicleStats) {
        if (this.isDamaged()) {
            return 0.0f;
        }
        if (((EngineStats)this.getStats()).getEngineType() == EngineStats.EngineType.PUSH) {
            if (vehicleStats.max_push_thrust_per_engine != -1.0f) {
                return vehicleStats.max_push_thrust_per_engine;
            }
            return ((EngineStats)this.getStats()).getThrust();
        }
        return 0.0f;
    }

    @Override
    public float getSpinThrust(VehicleStats vehicleStats) {
        if (this.isDamaged()) {
            return 0.0f;
        }
        if (((EngineStats)this.getStats()).getEngineType() == EngineStats.EngineType.SPIN) {
            if (vehicleStats.max_spin_thrust_per_engine != -1.0f) {
                return vehicleStats.max_spin_thrust_per_engine;
            }
            return ((EngineStats)this.getStats()).getThrust();
        }
        return 0.0f;
    }

    @Override
    public float getEngineHeat(VehicleStats vehicleStats) {
        float heat = vehicleStats.heat_per_engine != -1.0f ? vehicleStats.heat_per_engine : ((EngineStats)this.getStats()).getHeat();
        if (this.isDamaged()) {
            return heat * 2.0f;
        }
        return heat;
    }

    @Override
    public float getFuelPerTick(VehicleStats vehicleStats) {
        if (this.isDamaged()) {
            return 0.0f;
        }
        if (vehicleStats.fuel_consume_per_engine != -1.0f) {
            return vehicleStats.fuel_consume_per_engine;
        }
        return ((EngineStats)this.getStats()).getFuelPerTick();
    }
}

