/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts.instance;

import com.onewhohears.dscombat.crafting.FlareDispenserLoadRecipe;
import com.onewhohears.dscombat.crafting.PartItemLoadRecipe;
import com.onewhohears.dscombat.crafting.PartItemUnloadRecipe;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.instance.ReloadablePartInstance;
import com.onewhohears.dscombat.data.parts.stats.FlareDispenserStats;
import com.onewhohears.dscombat.entity.weapon.EntityFlare;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class FlareDispenserInstance<T extends FlareDispenserStats>
extends PartInstance<T>
implements ReloadablePartInstance {
    private int flares = 0;
    private static final PartItemLoadRecipe<?> LOAD_RECIPE = new FlareDispenserLoadRecipe(new ResourceLocation("dscombat:flare_load_recipe"));

    public FlareDispenserInstance(T stats) {
        super(stats);
    }

    @Override
    public void setFilled(String param) {
        super.setFilled(param);
        this.flares = ((FlareDispenserStats)this.getStats()).getMaxFlares();
    }

    @Override
    public void readNBT(CompoundTag tag) {
        super.readNBT(tag);
        this.flares = tag.m_128451_("flares");
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag tag = super.writeNBT();
        tag.m_128405_("flares", this.flares);
        return tag;
    }

    @Override
    public void readBuffer(FriendlyByteBuf buffer) {
        super.readBuffer(buffer);
        this.flares = buffer.readInt();
    }

    @Override
    public void writeBuffer(FriendlyByteBuf buffer) {
        super.writeBuffer(buffer);
        buffer.writeInt(this.flares);
    }

    public int addFlares(int flares) {
        int max = ((FlareDispenserStats)this.getStats()).getMaxFlares();
        this.flares += flares;
        if (this.flares < 0) {
            int r = this.flares;
            this.flares = 0;
            return r;
        }
        if (this.flares > max) {
            int r = this.flares - max;
            this.flares = max;
            return r;
        }
        this.setDirty();
        return 0;
    }

    public void setFlares(int flares) {
        int max = ((FlareDispenserStats)this.getStats()).getMaxFlares();
        if (flares > max) {
            flares = max;
        } else if (flares < 0) {
            flares = 0;
        }
        this.flares = flares;
        this.setDirty();
    }

    @Override
    public int getFlares() {
        return this.flares;
    }

    public boolean flare(boolean consume) {
        if (this.isDamaged()) {
            return false;
        }
        if (this.getParent() == null) {
            return false;
        }
        if (this.getFlares() <= 0) {
            return false;
        }
        Level level = this.getParent().f_19853_;
        EntityFlare flare = new EntityFlare(level, ((FlareDispenserStats)this.getStats()).getInitHeat(), ((FlareDispenserStats)this.getStats()).getMaxAge(), 3.0f);
        flare.m_146884_(this.getParent().m_20182_().m_82549_(this.getRelPos()));
        flare.m_20256_(this.getParent().m_20184_());
        level.m_7967_((Entity)flare);
        if (consume) {
            this.addFlares(-1);
        }
        return true;
    }

    @Override
    public float getCurrentAmmo() {
        return this.getFlares();
    }

    @Override
    public float getMaxAmmo() {
        return ((FlareDispenserStats)this.getStats()).getMaxFlares();
    }

    @Override
    public void setCurrentAmmo(float ammo) {
        this.setFlares((int)ammo);
    }

    @Override
    public void setMaxAmmo(float max) {
    }

    @Override
    public boolean isCompatibleWithAmmoContinuity(String continuity) {
        return true;
    }

    @Override
    public boolean updateContinuityIfEmpty() {
        return false;
    }

    @Override
    public void setContinuity(String continuity) {
    }

    @Override
    public String getContinuity() {
        return "";
    }

    @Override
    public PartItemLoadRecipe<?> getLoadRecipe() {
        return LOAD_RECIPE;
    }

    @Override
    public PartItemUnloadRecipe<?> getUnloadRecipe() {
        return null;
    }

    @Override
    public void addToolTips(List<Component> tips, TooltipFlag isAdvanced) {
        super.addToolTips(tips, isAdvanced);
        tips.add((Component)UtilMCText.translatable((String)"info.dscombat.ammo").m_130946_(" " + (int)this.getCurrentAmmo() + "/" + (int)this.getMaxAmmo()).m_6270_(Style.f_131099_.m_178520_(0xAAAAAA)));
    }
}

