/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts.instance;

import com.onewhohears.dscombat.crafting.FuelTankLoadRecipe;
import com.onewhohears.dscombat.crafting.PartItemLoadRecipe;
import com.onewhohears.dscombat.crafting.PartItemUnloadRecipe;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.instance.ReloadablePartInstance;
import com.onewhohears.dscombat.data.parts.stats.FuelTankStats;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class FuelTankInstance<T extends FuelTankStats>
extends PartInstance<T>
implements ReloadablePartInstance {
    private float fuel = 0.0f;
    private static final PartItemLoadRecipe<?> LOAD_RECIPE = new FuelTankLoadRecipe(new ResourceLocation("dscombat:fuel_tank_load_recipe"));

    public FuelTankInstance(T stats) {
        super(stats);
    }

    @Override
    public void setFilled(String param) {
        super.setFilled(param);
        this.fuel = ((FuelTankStats)this.getStats()).getMaxFuel();
    }

    @Override
    public float getWeight() {
        float w = super.getWeight();
        return w * this.fuel / ((FuelTankStats)this.getStats()).getMaxFuel();
    }

    public float getFuel() {
        return this.fuel;
    }

    @Override
    public void readNBT(CompoundTag tag) {
        super.readNBT(tag);
        this.fuel = tag.m_128457_("fuel");
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag tag = super.writeNBT();
        tag.m_128350_("fuel", this.fuel);
        return tag;
    }

    @Override
    public void readBuffer(FriendlyByteBuf buffer) {
        super.readBuffer(buffer);
        this.fuel = buffer.readFloat();
    }

    @Override
    public void writeBuffer(FriendlyByteBuf buffer) {
        super.writeBuffer(buffer);
        buffer.writeFloat(this.fuel);
    }

    public float addFuel(float fuel) {
        float max = ((FuelTankStats)this.getStats()).getMaxFuel();
        this.fuel += fuel;
        if (this.fuel < 0.0f) {
            float r = this.fuel;
            this.fuel = 0.0f;
            return r;
        }
        if (this.fuel > max) {
            float r = this.fuel - max;
            this.fuel = max;
            return r;
        }
        this.setDirty();
        return 0.0f;
    }

    public void setFuel(float fuel) {
        float max = ((FuelTankStats)this.getStats()).getMaxFuel();
        if (fuel > max) {
            fuel = max;
        } else if (fuel < 0.0f) {
            fuel = 0.0f;
        }
        this.fuel = fuel;
        this.setDirty();
    }

    @Override
    public float getCurrentAmmo() {
        return this.getFuel();
    }

    @Override
    public float getMaxAmmo() {
        return this.getMaxFuel();
    }

    @Override
    public void setCurrentAmmo(float ammo) {
        this.setFuel(ammo);
    }

    @Override
    public void setMaxAmmo(float max) {
    }

    @Override
    public boolean isCompatibleWithAmmoContinuity(String continuity) {
        return true;
    }

    @Override
    public boolean updateContinuityIfEmpty() {
        return false;
    }

    @Override
    public void setContinuity(String continuity) {
    }

    @Override
    public String getContinuity() {
        return "";
    }

    @Override
    public PartItemLoadRecipe<?> getLoadRecipe() {
        return LOAD_RECIPE;
    }

    @Override
    @Nullable
    public PartItemUnloadRecipe<?> getUnloadRecipe() {
        return null;
    }

    @Override
    public void addToolTips(List<Component> tips, TooltipFlag isAdvanced) {
        tips.add((Component)UtilMCText.translatable((String)"info.dscombat.fuel").m_130946_(": " + (int)this.fuel + "/" + (int)((FuelTankStats)this.getStats()).getMaxFuel()).m_6270_(Style.f_131099_.m_178520_(0xAAAAAA)));
        super.addToolTips(tips, isAdvanced);
    }

    @Override
    public float getCurrentFuel() {
        return this.getFuel();
    }

    @Override
    public float getMaxFuel() {
        return ((FuelTankStats)this.getStats()).getMaxFuel();
    }

    @Override
    public void tick(String slotId) {
        super.tick(slotId);
        if (this.isDamaged()) {
            this.addFuel(-0.06f);
        }
    }
}

