/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts.instance;

import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.stats.SeatStats;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.TooltipFlag;

public class SeatInstance<T extends SeatStats>
extends PartInstance<T> {
    private boolean eject;

    public SeatInstance(T stats) {
        super(stats);
    }

    @Override
    public void readNBT(CompoundTag tag) {
        super.readNBT(tag);
        this.eject = tag.m_128471_("eject");
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag tag = super.writeNBT();
        tag.m_128379_("eject", this.eject);
        return tag;
    }

    @Override
    public void readBuffer(FriendlyByteBuf buffer) {
        super.readBuffer(buffer);
        this.eject = buffer.readBoolean();
    }

    @Override
    public void writeBuffer(FriendlyByteBuf buffer) {
        super.writeBuffer(buffer);
        buffer.writeBoolean(this.eject);
    }

    public boolean canEject() {
        return this.eject;
    }

    public void setCanEject(boolean eject) {
        this.eject = eject;
        this.setDirty();
    }

    @Override
    public void setFilled(String param) {
        if (param != null && param.contains("eject")) {
            this.setCanEject(true);
        }
    }

    @Override
    public void setParamNotFilled(String param) {
        if (param != null && param.contains("eject")) {
            this.setCanEject(true);
        }
    }

    @Override
    public void addToolTips(List<Component> tips, TooltipFlag isAdvanced) {
        super.addToolTips(tips, isAdvanced);
        if (this.canEject()) {
            tips.add((Component)UtilMCText.translatable((String)"info.dscombat.can_eject").m_6270_(Style.f_131099_.m_178520_(52224)));
        } else {
            tips.add((Component)UtilMCText.translatable((String)"info.dscombat.cant_eject").m_6270_(Style.f_131099_.m_178520_(0xCC0000)));
        }
    }
}

