/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts.instance;

import com.onewhohears.dscombat.crafting.PartItemLoadRecipe;
import com.onewhohears.dscombat.crafting.PartItemUnloadRecipe;
import com.onewhohears.dscombat.crafting.TurretLoadRecipe;
import com.onewhohears.dscombat.crafting.TurretUnloadRecipe;
import com.onewhohears.dscombat.data.parts.instance.ReloadablePartInstance;
import com.onewhohears.dscombat.data.parts.instance.SeatInstance;
import com.onewhohears.dscombat.data.parts.stats.TurretStats;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.entity.parts.EntityPart;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class TurretInstance<T extends TurretStats>
extends SeatInstance<T>
implements ReloadablePartInstance {
    @Nonnull
    private String weapon = "";
    private int ammo = 0;
    @Nullable
    private WeaponInstance<?> data;
    private static final PartItemLoadRecipe<?> LOAD_RECIPE = new TurretLoadRecipe(new ResourceLocation("dscombat:turret_load_recipe"));
    private static final PartItemUnloadRecipe<?> UNLOAD_RECIPE = new TurretUnloadRecipe(new ResourceLocation("dscombat:turret_unload_recipe"));

    public TurretInstance(T stats) {
        super(stats);
    }

    @Override
    public void setFilled(String param) {
        List<String> list;
        super.setFilled(param);
        if (param.isEmpty() && !(list = WeaponPresets.get().getCompatibleWeapons(this.getStatsId())).isEmpty()) {
            param = list.get(0);
        }
        this.weapon = param;
        this.ammo = ((TurretStats)this.getStats()).getMaxAmmo();
    }

    @Override
    public void setParamNotFilled(String param) {
        List<String> list;
        super.setParamNotFilled(param);
        if (param.isEmpty() && !(list = WeaponPresets.get().getCompatibleWeapons(this.getStatsId())).isEmpty()) {
            param = list.get(0);
        }
        this.weapon = param;
    }

    @Override
    public void readNBT(CompoundTag tag) {
        super.readNBT(tag);
        if (tag.m_128441_("weapon")) {
            this.weapon = tag.m_128461_("weapon");
        } else if (tag.m_128441_("weaponId")) {
            this.weapon = tag.m_128461_("weaponId");
        }
        if (!WeaponPresets.get().has(this.weapon)) {
            this.weapon = "";
        }
        this.ammo = tag.m_128451_("ammo");
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag tag = super.writeNBT();
        tag.m_128359_("weapon", this.weapon);
        tag.m_128405_("ammo", this.ammo);
        return tag;
    }

    @Override
    public void readBuffer(FriendlyByteBuf buffer) {
        super.readBuffer(buffer);
        this.weapon = buffer.m_130277_();
        this.ammo = buffer.readInt();
    }

    @Override
    public void writeBuffer(FriendlyByteBuf buffer) {
        super.writeBuffer(buffer);
        buffer.m_130070_(this.weapon);
        buffer.writeInt(this.ammo);
    }

    public String getWeaponId() {
        return this.weapon;
    }

    @Override
    public void setup(EntityVehicle craft, String slotId, Vec3 pos) {
        super.setup(craft, slotId, pos);
        if (this.data == null && WeaponPresets.get().has(this.getWeaponId())) {
            this.data = WeaponPresets.get().get(this.getWeaponId()).createWeaponInstance();
        }
        if (this.data != null) {
            this.data.setMaxAmmo((int)this.getMaxAmmo());
            this.data.setCurrentAmmo(this.ammo);
        }
    }

    @Nullable
    public EntityTurret getTurret(String slotId) {
        EntityVehicle craft = this.getParent();
        if (craft == null) {
            return null;
        }
        for (EntityPart part : craft.getPartEntities()) {
            if (!part.getPartType().is(((TurretStats)this.getStats()).getType()) || !part.getSlotId().equals(slotId) || !(part instanceof EntityTurret)) continue;
            EntityTurret turret = (EntityTurret)part;
            return turret;
        }
        return null;
    }

    @Override
    public float getCurrentAmmo() {
        return this.ammo;
    }

    @Override
    public float getMaxAmmo() {
        return ((TurretStats)this.getStats()).getMaxAmmo();
    }

    @Override
    public void setCurrentAmmo(float ammo) {
        this.ammo = (int)ammo;
        this.setDirty();
    }

    public void setWeaponAmmo(int ammo) {
        if (this.data != null) {
            this.data.setCurrentAmmo(ammo);
            this.setCurrentAmmo(this.data.getCurrentAmmo());
        }
    }

    public int addWeaponAmmo(int ammo) {
        if (this.data == null) {
            return 0;
        }
        int r = this.data.addAmmo(ammo);
        this.setCurrentAmmo(this.data.getCurrentAmmo());
        return r;
    }

    @Override
    public void setMaxAmmo(float max) {
    }

    @Override
    public boolean isCompatibleWithAmmoContinuity(String continuity) {
        return ((TurretStats)this.getStats()).isWeaponCompatible(continuity);
    }

    @Override
    public boolean updateContinuityIfEmpty() {
        return true;
    }

    @Override
    public void setContinuity(String continuity) {
        if (continuity == null) {
            continuity = "";
        }
        if (continuity.equals(this.weapon)) {
            return;
        }
        this.weapon = continuity;
        this.setDirty();
        if (!this.isSetup()) {
            return;
        }
        if (WeaponPresets.get().has(this.getWeaponId())) {
            this.data = WeaponPresets.get().get(this.getWeaponId()).createWeaponInstance();
            if (this.data != null) {
                this.data.setMaxAmmo((int)this.getMaxAmmo());
                this.data.setCurrentAmmo(this.ammo);
            }
        } else {
            this.data = null;
        }
    }

    @Override
    public String getContinuity() {
        return this.getWeaponId();
    }

    @Override
    public boolean isContinuityEmpty() {
        return this.getContinuity() == null || this.getContinuity().isEmpty() || this.getCurrentAmmo() == 0.0f;
    }

    @Override
    public PartItemLoadRecipe<?> getLoadRecipe() {
        return LOAD_RECIPE;
    }

    @Override
    @Nullable
    public PartItemUnloadRecipe<?> getUnloadRecipe() {
        return UNLOAD_RECIPE;
    }

    @Nullable
    public WeaponInstance<?> getWeaponData() {
        return this.data;
    }

    @Override
    public void onReceiveClientSync() {
        super.onReceiveClientSync();
        this.setContinuity(this.getWeaponId());
        if (this.data != null) {
            this.data.setCurrentAmmo(this.ammo);
        }
    }
}

