/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts.instance;

import com.onewhohears.dscombat.crafting.PartItemLoadRecipe;
import com.onewhohears.dscombat.crafting.PartItemUnloadRecipe;
import com.onewhohears.dscombat.crafting.WeaponPartLoadRecipe;
import com.onewhohears.dscombat.crafting.WeaponPartUnloadRecipe;
import com.onewhohears.dscombat.data.parts.PartSlot;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.instance.ReloadablePartInstance;
import com.onewhohears.dscombat.data.parts.stats.WeaponPartStats;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class WeaponPartInstance<T extends WeaponPartStats>
extends PartInstance<T>
implements ReloadablePartInstance {
    protected String weapon = "";
    private int ammo = 0;
    private static final PartItemLoadRecipe<?> LOAD_RECIPE = new WeaponPartLoadRecipe(new ResourceLocation("dscombat:weapon_part_load_recipe"));
    private static final PartItemUnloadRecipe<?> UNLOAD_RECIPE = new WeaponPartUnloadRecipe(new ResourceLocation("dscombat:weapon_part_unload_recipe"));

    public WeaponPartInstance(T stats) {
        super(stats);
    }

    @Override
    public void setFilled(String param) {
        List<String> list;
        super.setFilled(param);
        if (param.isEmpty() && !(list = WeaponPresets.get().getCompatibleWeapons(this.getStatsId())).isEmpty()) {
            param = list.get(0);
        }
        this.weapon = param;
        this.ammo = ((WeaponPartStats)this.getStats()).getMaxAmmo();
    }

    @Override
    public void setParamNotFilled(String param) {
        super.setParamNotFilled(param);
        this.weapon = param;
    }

    @Override
    public void readNBT(CompoundTag tag) {
        super.readNBT(tag);
        if (tag.m_128441_("weapon")) {
            this.weapon = tag.m_128461_("weapon");
        } else if (tag.m_128441_("weaponId")) {
            this.weapon = tag.m_128461_("weaponId");
        }
        if (!WeaponPresets.get().has(this.weapon)) {
            this.weapon = "";
        }
        this.ammo = tag.m_128451_("ammo");
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag tag = super.writeNBT();
        tag.m_128359_("weapon", this.weapon);
        tag.m_128405_("ammo", this.ammo);
        return tag;
    }

    @Override
    public void readBuffer(FriendlyByteBuf buffer) {
        super.readBuffer(buffer);
        this.weapon = buffer.m_130277_();
        this.ammo = buffer.readInt();
    }

    @Override
    public void writeBuffer(FriendlyByteBuf buffer) {
        super.writeBuffer(buffer);
        buffer.m_130070_(this.weapon);
        buffer.writeInt(this.ammo);
    }

    @Override
    public void setup(EntityVehicle craft, String slotId, Vec3 pos) {
        WeaponInstance<?> data = craft.weaponSystem.get(this.weapon, slotId);
        if (data == null && WeaponPresets.get().has(this.weapon)) {
            data = WeaponPresets.get().get(this.weapon).createWeaponInstance();
            data.setSlot(slotId);
            craft.weaponSystem.addWeapon(data);
        }
        super.setup(craft, slotId, pos);
        if (data != null) {
            data.setMaxAmmo(((WeaponPartStats)this.getStats()).getMaxAmmo());
            data.setCurrentAmmo(this.ammo);
            data.setLaunchPos(pos);
            if (!craft.f_19853_.f_46443_) {
                data.updateClientAmmo(craft);
            }
        }
    }

    @Override
    public void remove(EntityVehicle parent, String slotId) {
        super.remove(parent, slotId);
        parent.weaponSystem.removeWeapon(this.weapon, slotId);
    }

    @Override
    public void tick(String slotId) {
        super.tick(slotId);
        if (this.getParent() == null) {
            return;
        }
        WeaponInstance<?> data = this.getParent().weaponSystem.get(this.weapon, slotId);
        if (data != null) {
            this.ammo = data.getCurrentAmmo();
        }
    }

    @Override
    public void clientTick(String slotId) {
        super.clientTick(slotId);
        this.tick(slotId);
    }

    @Override
    public float getWeight() {
        int max = ((WeaponPartStats)this.getStats()).getMaxAmmo();
        if (max == 0) {
            return 0.0f;
        }
        float w = super.getWeight();
        return w * (float)this.ammo / (float)max;
    }

    @Override
    public float getCurrentAmmo() {
        return this.ammo;
    }

    @Override
    public float getMaxAmmo() {
        return ((WeaponPartStats)this.getStats()).getMaxAmmo();
    }

    @Override
    public void setCurrentAmmo(float ammo) {
        WeaponInstance<?> data;
        this.ammo = (int)ammo;
        if (this.getParent() != null && (data = this.getParent().weaponSystem.get(this.weapon, this.getSlotId())) != null) {
            data.setCurrentAmmo((int)ammo);
            if (!this.getParent().f_19853_.f_46443_) {
                data.updateClientAmmo(this.getParent());
            }
        }
    }

    @Override
    public void setMaxAmmo(float max) {
    }

    @Override
    public boolean isCompatibleWithAmmoContinuity(String continuity) {
        return ((WeaponPartStats)this.getStats()).isWeaponCompatible(continuity);
    }

    @Override
    public boolean updateContinuityIfEmpty() {
        return true;
    }

    @Override
    public void setContinuity(String continuity) {
        if (this.getParent() != null && !Objects.equals(this.weapon, continuity)) {
            PartSlot slot = this.getParent().partsManager.getSlot(this.getSlotId());
            if (slot == null) {
                return;
            }
            slot.removePartData(this.getParent());
            this.weapon = continuity;
            slot.addPartData(this, this.getParent());
        }
        this.weapon = continuity;
    }

    @Override
    public String getContinuity() {
        return this.getWeaponId();
    }

    @Override
    public boolean isContinuityEmpty() {
        return this.getContinuity() == null || this.getContinuity().isEmpty() || this.getCurrentAmmo() == 0.0f;
    }

    public String getWeaponId() {
        return this.weapon;
    }

    @Override
    public PartItemLoadRecipe<?> getLoadRecipe() {
        return LOAD_RECIPE;
    }

    @Override
    @Nullable
    public PartItemUnloadRecipe<?> getUnloadRecipe() {
        return UNLOAD_RECIPE;
    }
}

