/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts.stats;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.parts.PartType;
import com.onewhohears.dscombat.data.parts.SlotType;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.onewholibs.data.crafting.IngredientStackBuilder;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilItem;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;

public abstract class PartStats
extends JsonPresetStats {
    private final float weight;
    private final float hitbox_width;
    private final float hitbox_height;
    private final String itemId;
    private final String externalEntityId;
    private final SlotType compatibleSlotType;
    private Item item;
    private EntityType<?> externalEntityType;
    private NonNullList<Ingredient> repair_cost;
    private EntityDimensions dimensions;
    private NonNullList<Ingredient> ingredients;

    public PartStats(ResourceLocation key, JsonObject json) {
        super(key, json);
        this.weight = UtilParse.getFloatSafe((JsonObject)json, (String)"weight", (float)0.0f);
        this.itemId = UtilParse.getStringSafe((JsonObject)json, (String)"item", (String)"");
        this.externalEntityId = this.getExternalEntityId(json);
        this.compatibleSlotType = SlotType.getByName(UtilParse.getStringSafe((JsonObject)json, (String)"slotType", (String)""));
        this.hitbox_width = UtilParse.getFloatSafe((JsonObject)json, (String)"hitbox_width", (float)0.8f);
        this.hitbox_height = UtilParse.getFloatSafe((JsonObject)json, (String)"hitbox_height", (float)0.8f);
    }

    public boolean isCompatible(SlotType type) {
        if (type == null) {
            return false;
        }
        return this.compatibleSlotType.isCompatible(type);
    }

    public PartInstance<?> createPartInstance() {
        return (PartInstance)this.createPresetInstance();
    }

    public PartInstance<?> createFilledPartInstance(String param) {
        PartInstance filled = (PartInstance)this.createPresetInstance();
        filled.setFilled(param);
        return filled;
    }

    public float getWeight() {
        return this.weight;
    }

    public String getItemId() {
        return this.itemId;
    }

    public Item getItem() {
        if (this.item == null) {
            this.item = UtilItem.getItem((String)this.itemId);
        }
        return this.item;
    }

    public NonNullList<Ingredient> getRepairCost() {
        if (this.repair_cost == null) {
            this.repair_cost = IngredientStackBuilder.getIngredients((JsonObject)this.getJsonData(), (String)"repair_cost");
        }
        return this.repair_cost;
    }

    public boolean hasExternalEntity() {
        return !this.externalEntityId.isEmpty();
    }

    @Nullable
    public EntityType<?> getExernalEntityType() {
        if (!this.hasExternalEntity()) {
            return null;
        }
        if (this.externalEntityType == null) {
            this.externalEntityType = UtilEntity.getEntityType((String)this.externalEntityId, this.getDefaultExternalEntity());
        }
        return this.externalEntityType;
    }

    @Nullable
    public EntityType<?> getDefaultExternalEntity() {
        return null;
    }

    protected String getExternalEntityId(JsonObject json) {
        return UtilParse.getStringSafe((JsonObject)json, (String)"externalEntity", (String)"");
    }

    public void addToolTips(List<Component> tips, TooltipFlag isAdvanced) {
        tips.add((Component)UtilMCText.translatable((String)"info.dscombat.compatible").m_130946_(": ").m_6270_(Style.f_131099_.m_178520_(0xFFFF55)).m_7220_((Component)UtilMCText.translatable((String)this.compatibleSlotType.getTranslatableName())));
        tips.add((Component)UtilMCText.translatable((String)"info.dscombat.mass").m_130946_(": " + this.weight).m_6270_(Style.f_131099_.m_178520_(0xAAAAAA)));
    }

    public float getExternalEntityDefaultHealth() {
        return 100000.0f;
    }

    public boolean isFlareDispenser() {
        return this.getType().is((JsonPresetType)PartType.FLARE_DISPENSER);
    }

    public boolean isGimbal() {
        return this.getType().is((JsonPresetType)PartType.GIMBAL);
    }

    public boolean isChainHook() {
        return this.getType().is((JsonPresetType)PartType.CHAIN_HOOK);
    }

    public boolean isRadio() {
        return false;
    }

    public boolean isEngine() {
        return false;
    }

    public boolean isSeat() {
        return false;
    }

    public boolean isStorageBox() {
        return false;
    }

    public boolean isFuelTank() {
        return false;
    }

    public float getAdditionalArmor() {
        return 0.0f;
    }

    public EntityDimensions getEntityDimensions() {
        if (this.dimensions == null) {
            this.dimensions = EntityDimensions.m_20398_((float)this.hitbox_width, (float)this.hitbox_height);
        }
        return this.dimensions;
    }

    public NonNullList<Ingredient> getIngredients() {
        if (this.ingredients == null) {
            this.ingredients = IngredientStackBuilder.getIngredients((JsonObject)this.getJsonData());
        }
        return this.ingredients;
    }

    public boolean isCraftableWeaponPart() {
        return false;
    }
}

