/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.radar;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.data.weapon.NonTickingMissileManager;
import com.onewhohears.dscombat.data.weapon.RadarTargetTypes;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.weapon.EntityMissile;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RadarInstance<T extends RadarStats>
extends JsonPresetInstance<T> {
    private String slotId = "";
    private Vec3 pos = Vec3.f_82478_;
    private boolean freshTargets;
    private int scanTicks;
    private List<RadarStats.RadarPing> pings = new ArrayList<RadarStats.RadarPing>();
    private int maxCheckDist = 150;

    public RadarInstance(T stats) {
        super(stats);
    }

    public void readNBT(CompoundTag tag) {
        super.readNBT(tag);
        this.setSlot(tag.m_128461_("slotId"));
    }

    public CompoundTag writeNBT() {
        CompoundTag tag = super.writeNBT();
        tag.m_128359_("slotId", this.slotId);
        return tag;
    }

    public void resetPings(List<RadarStats.RadarPing> vehiclePings) {
        for (int i = 0; i < this.pings.size(); ++i) {
            vehiclePings.remove(this.pings.get(i));
        }
        this.pings.clear();
    }

    public void tickUpdateTargets(EntityVehicle radar, List<RadarStats.RadarPing> vehiclePings) {
        if (this.scanTicks <= ((RadarStats)this.getStats()).getScanRate()) {
            ++this.scanTicks;
            this.freshTargets = false;
            return;
        }
        this.scanTicks = 0;
        this.maxCheckDist = (Integer)Config.COMMON.maxBlockCheckDepth.get();
        this.resetPings(vehiclePings);
        this.freshTargets = true;
        Entity controller = radar.getControllingPlayerOrBot();
        RadarStats.RadarMode mode = radar.getRadarMode();
        if (mode.isOff()) {
            return;
        }
        AABB radarArea = this.getRadarBoundingBox((Entity)radar);
        if (((RadarStats)this.getStats()).isScanAircraft() && (mode.canScan(RadarStats.RadarMode.VEHICLES) || mode.isPlayersOrBots())) {
            this.scanAircraft(radar, controller, vehiclePings, radarArea, mode.isPlayersOnly(), mode.isPlayersOrBots());
        }
        if (((RadarStats)this.getStats()).isScanPlayers() && (mode.canScan(RadarStats.RadarMode.PLAYERS) || mode.isPlayersOrBots())) {
            this.scanPlayers(radar, controller, vehiclePings, radarArea);
        }
        if (((RadarStats)this.getStats()).isScanMobs() && mode.canScan(RadarStats.RadarMode.MOBS)) {
            this.scanMobs(radar, controller, vehiclePings, radarArea);
        }
        if (((RadarStats)this.getStats()).isScanMissiles() && mode.isOn()) {
            this.scanMissiles(radar, controller, vehiclePings, radarArea);
        }
    }

    private void scanAircraft(EntityVehicle radar, Entity controller, List<RadarStats.RadarPing> vehiclePings, AABB radarArea, boolean playersOnly, boolean isPlayersOrBots) {
        List list = radar.f_19853_.m_6249_((Entity)radar, radarArea, entity -> entity.m_6095_().m_204039_(ModTags.EntityTypes.VEHICLE));
        for (Entity e : list) {
            EntityVehicle ev = null;
            if (e instanceof EntityVehicle) {
                EntityVehicle vehicle;
                ev = vehicle = (EntityVehicle)e;
            }
            boolean isPlayer = false;
            boolean isPlayerOrBot = false;
            if (ev == null) {
                boolean bl = isPlayer = e.m_6688_() instanceof Player || e.m_146895_() instanceof Player;
                if (!isPlayer && (playersOnly || isPlayersOrBots)) {
                    continue;
                }
            } else {
                isPlayer = ev.isPlayerRiding();
                if (!isPlayer && playersOnly || !(isPlayerOrBot = ev.isPlayerOrBotRiding()) && isPlayersOrBots) continue;
            }
            double stealth = 1.0;
            if (ev != null) {
                stealth = ev.getStealth();
            }
            if (!this.basicCheck(radar, e, stealth)) continue;
            RadarStats.PingEntityType pingEntityType = isPlayer ? RadarStats.PingEntityType.VEHICLE_PLAYER : (isPlayerOrBot ? RadarStats.PingEntityType.VEHICLE_BOT : RadarStats.PingEntityType.VEHICLE);
            RadarStats.RadarPing p = new RadarStats.RadarPing(e, this.checkFriendly(controller, e), pingEntityType);
            vehiclePings.add(p);
            this.pings.add(p);
            if (ev == null || radar.m_7307_((Entity)ev)) continue;
            ev.lockedOnto((Entity)radar);
        }
    }

    private void scanPlayers(EntityVehicle radar, Entity controller, List<RadarStats.RadarPing> vehiclePings, AABB radarArea) {
        List list = radar.f_19853_.m_45976_(Player.class, radarArea);
        for (Player target : list) {
            if (target.m_20159_() && target.m_20201_().m_6095_().m_204039_(ModTags.EntityTypes.VEHICLE) || !this.basicCheck(radar, (Entity)target, 1.0)) continue;
            RadarStats.RadarPing p = new RadarStats.RadarPing((Entity)target, this.checkFriendly(controller, (Entity)target), RadarStats.PingEntityType.PLAYER);
            vehiclePings.add(p);
            this.pings.add(p);
        }
    }

    private void scanMobs(EntityVehicle radar, Entity controller, List<RadarStats.RadarPing> vehiclePings, AABB radarArea) {
        for (int j = 0; j < RadarTargetTypes.get().getRadarMobClasses().size(); ++j) {
            Class<? extends Entity> clazz = RadarTargetTypes.get().getRadarMobClasses().get(j);
            List list = radar.f_19853_.m_45976_(clazz, radarArea);
            for (Entity entity : list) {
                if (entity.m_20159_() || !this.basicCheck(radar, entity, 1.0)) continue;
                RadarStats.RadarPing p = new RadarStats.RadarPing(entity, this.checkFriendly(controller, entity), RadarStats.PingEntityType.FRIENDLY_MOB);
                vehiclePings.add(p);
                this.pings.add(p);
            }
        }
    }

    private void scanMissiles(EntityVehicle radar, Entity controller, List<RadarStats.RadarPing> vehiclePings, AABB radarArea) {
        RadarStats.RadarPing p;
        List list = radar.f_19853_.m_6249_((Entity)radar, radarArea, entity -> entity.m_6095_().m_204039_(ModTags.EntityTypes.MISSILE));
        for (Entity entity2 : list) {
            if (!this.basicCheck(radar, entity2, -1.0)) continue;
            p = new RadarStats.RadarPing(entity2, this.checkFriendly(controller, entity2), RadarStats.PingEntityType.MISSILE);
            vehiclePings.add(p);
            this.pings.add(p);
        }
        for (EntityMissile entityMissile : NonTickingMissileManager.getMissiles()) {
            if (!this.basicCheck(radar, (Entity)entityMissile, -1.0)) continue;
            p = new RadarStats.RadarPing((Entity)entityMissile, this.checkFriendly(controller, (Entity)entityMissile), RadarStats.PingEntityType.MISSILE);
            vehiclePings.add(p);
            this.pings.add(p);
        }
    }

    private boolean checkFriendly(Entity controller, Entity target) {
        if (target == null) {
            return false;
        }
        if (controller == null) {
            return false;
        }
        return UtilEntity.areEntitiesAllied((Entity)target, (Entity)controller);
    }

    private boolean basicCheck(EntityVehicle radar, Entity ping, double stealth) {
        if (radar.equals(ping)) {
            return false;
        }
        if (!this.groundCheck(ping)) {
            return false;
        }
        if (radar.isVehicleOf(ping)) {
            return false;
        }
        if (!this.checkTargetRange((Entity)radar, ping, stealth)) {
            return false;
        }
        return this.checkCanSee((Entity)radar, ping);
    }

    private boolean groundCheck(Entity ping) {
        if (((RadarStats)this.getStats()).getThroWaterRange() > 0.0 && ping.m_20069_()) {
            return true;
        }
        boolean groundWater = UtilVehicleEntity.isOnGroundOrWater(ping);
        if (((RadarStats)this.getStats()).isScanGround() && groundWater) {
            return true;
        }
        return ((RadarStats)this.getStats()).isScanAir() && !groundWater;
    }

    private boolean checkTargetRange(Entity radar, Entity target, double stealth) {
        double areaMin;
        float dist = radar.m_20270_(target);
        if (((RadarStats)this.getStats()).getFov() == -1.0 ? (double)dist > ((RadarStats)this.getStats()).getRange() : !UtilGeometry.isPointInsideCone((Vec3)target.m_20182_(), (Vec3)radar.m_20182_().m_82549_(this.pos), (Vec3)radar.m_20154_(), (double)((RadarStats)this.getStats()).getFov(), (double)((RadarStats)this.getStats()).getRange())) {
            return false;
        }
        if (stealth == -1.0) {
            return true;
        }
        double area = UtilVehicleEntity.getCrossSectionalArea(target) * stealth;
        return area >= (areaMin = (1.0 - Math.pow(((RadarStats)this.getStats()).getRange(), -2.0) * Math.pow((double)dist - ((RadarStats)this.getStats()).getRange(), 2.0)) * ((RadarStats)this.getStats()).getSensitivity());
    }

    private boolean checkCanSee(Entity radar, Entity target) {
        return UtilEntity.canPosSeeEntity((Vec3)radar.m_20182_().m_82549_(this.pos), (Entity)target, (int)this.maxCheckDist, (double)(((RadarStats)this.getStats()).getThroWaterRange() + 1.0), (double)((RadarStats)this.getStats()).getThroGroundRange());
    }

    private AABB getRadarBoundingBox(Entity radar) {
        double x = radar.m_20185_() + this.pos.f_82479_;
        double y = radar.m_20186_() + this.pos.f_82480_;
        double z = radar.m_20189_() + this.pos.f_82481_;
        double w = ((RadarStats)this.getStats()).getRange();
        return new AABB(x + w, y + w, z + w, x - w, y - w, z - w);
    }

    public boolean isFreshTargets() {
        return this.freshTargets;
    }

    public String getSlotId() {
        return this.slotId;
    }

    public boolean isInternal() {
        return this.slotId == "";
    }

    public void setSlot(String slotId) {
        this.slotId = slotId;
    }

    public void setInternal() {
        this.slotId = "";
    }

    public void setPos(Vec3 pos) {
        this.pos = pos;
    }

    public boolean idMatch(String id, String slotId) {
        if (slotId == null) {
            return false;
        }
        if (id == null) {
            return false;
        }
        return this.getStatsId().equals(id) && slotId.equals(slotId);
    }
}

