/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.sound;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.util.UtilClientSafeSounds;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.util.UtilParse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.Nullable;

public class PassengerSoundPack
extends JsonPresetStats {
    private static final Map<String, BiPredicate<EntityVehicle, PassengerSound>> soundTriggers = new HashMap<String, BiPredicate<EntityVehicle, PassengerSound>>();
    public static final JsonPresetType STANDARD = new JsonPresetType("standard", PassengerSoundPack::new){};
    private final List<PassengerSound> passengerSounds = new ArrayList<PassengerSound>();
    private int radarLockIndex = -1;
    private int radarFoundIndex = -1;
    private int flareIndex = -1;
    private int chaffIndex = -1;

    public static void registerPassengerSoundTrigger(String id, BiPredicate<EntityVehicle, PassengerSound> trigger) {
        soundTriggers.put(id, trigger);
    }

    public static boolean testTime(PassengerSound sound, int ticks) {
        if (sound.getGroupBurstSize() > 0 && sound.getGroupBurstRepeatRate() > -1) {
            int burstLength = sound.getRepeatRate() * sound.getGroupBurstSize();
            return ticks % sound.getGroupBurstRepeatRate() <= burstLength && ticks % sound.getRepeatRate() == 1;
        }
        if (sound.getGroupBurstSize() > 0) {
            int burstLength = sound.getRepeatRate() * sound.getGroupBurstSize();
            return ticks <= burstLength && ticks % sound.getRepeatRate() == 1;
        }
        return ticks % sound.getRepeatRate() == 1;
    }

    public static void registerBuiltInPassengerSoundTriggers() {
        PassengerSoundPack.registerPassengerSoundTrigger("always", (vehicle, sound) -> true);
        PassengerSoundPack.registerPassengerSoundTrigger("never", (vehicle, sound) -> false);
        PassengerSoundPack.registerPassengerSoundTrigger("rwr_missile_alert", (vehicle, sound) -> PassengerSoundPack.testTime(sound, vehicle.getMissileTicks()));
        PassengerSoundPack.registerPassengerSoundTrigger("rwr_tracked_alert", (vehicle, sound) -> !vehicle.radarSystem.isTrackedByMissile() && PassengerSoundPack.testTime(sound, vehicle.getTrackedTicks()));
        PassengerSoundPack.registerPassengerSoundTrigger("rwr_pinged_warning", (vehicle, sound) -> !vehicle.radarSystem.isTrackedByMissile() && !vehicle.radarSystem.isTrackedByRadar() && vehicle.radarSystem.clientConsumePingWarningSound());
        PassengerSoundPack.registerPassengerSoundTrigger("jammed_warning", (vehicle, sound) -> PassengerSoundPack.testTime(sound, vehicle.radarSystem.getJammedTicks()));
        PassengerSoundPack.registerPassengerSoundTrigger("ir_tone_low", (vehicle, sound) -> vehicle.shouldPlayLowIRTone() && !vehicle.shouldPlayHighIRTone() && PassengerSoundPack.testTime(sound, (int)(System.currentTimeMillis() / 50L)));
        PassengerSoundPack.registerPassengerSoundTrigger("ir_tone_high", (vehicle, sound) -> vehicle.shouldPlayHighIRTone() && PassengerSoundPack.testTime(sound, (int)(System.currentTimeMillis() / 50L)));
        PassengerSoundPack.registerPassengerSoundTrigger("stall_alert", (vehicle, sound) -> ((VehicleStats)vehicle.getStats()).isPlane() && vehicle.isStalling() && PassengerSoundPack.testTime(sound, vehicle.getStallTicks()));
        PassengerSoundPack.registerPassengerSoundTrigger("stall_warning", (vehicle, sound) -> ((VehicleStats)vehicle.getStats()).isPlane() && !vehicle.isStalling() && vehicle.isAboutToStall() && PassengerSoundPack.testTime(sound, vehicle.getAboutToStallTicks()));
        PassengerSoundPack.registerPassengerSoundTrigger("pull_up", (vehicle, sound) -> PassengerSoundPack.testTime(sound, vehicle.getPullUpWarningTicks()));
        PassengerSoundPack.registerPassengerSoundTrigger("altitude", (vehicle, sound) -> PassengerSoundPack.testTime(sound, vehicle.getAltitudeWarningTicks()));
        PassengerSoundPack.registerPassengerSoundTrigger("engine_fire", (vehicle, sound) -> ((VehicleStats)vehicle.getStats()).isAircraft() && PassengerSoundPack.testTime(sound, vehicle.getEngineFireTicks()));
        PassengerSoundPack.registerPassengerSoundTrigger("fuel_leak", (vehicle, sound) -> ((VehicleStats)vehicle.getStats()).isAircraft() && PassengerSoundPack.testTime(sound, vehicle.getFuelLeakTicks()));
        PassengerSoundPack.registerPassengerSoundTrigger("bingo", (vehicle, sound) -> ((VehicleStats)vehicle.getStats()).isAircraft() && PassengerSoundPack.testTime(sound, vehicle.getBingoTicks()));
        PassengerSoundPack.registerPassengerSoundTrigger("hydraulics_failure", (vehicle, sound) -> ((VehicleStats)vehicle.getStats()).isAircraft() && PassengerSoundPack.testTime(sound, vehicle.getHydraulicsFailureTicks()));
        PassengerSoundPack.registerPassengerSoundTrigger("radar_lock", (vehicle, sound) -> false);
        PassengerSoundPack.registerPassengerSoundTrigger("radar_found", (vehicle, sound) -> false);
        PassengerSoundPack.registerPassengerSoundTrigger("flare", (vehicle, sound) -> false);
        PassengerSoundPack.registerPassengerSoundTrigger("chaff", (vehicle, sound) -> false);
    }

    public PassengerSoundPack(ResourceLocation key, JsonObject json) {
        super(key, json);
        JsonArray sounds = json.has("sounds") && json.get("sounds").isJsonArray() ? json.get("sounds").getAsJsonArray() : new JsonArray();
        block12: for (int i = 0; i < sounds.size(); ++i) {
            if (!sounds.get(i).isJsonObject()) continue;
            JsonObject sound = sounds.get(i).getAsJsonObject();
            PassengerSound ps = new PassengerSound(sound);
            this.passengerSounds.add(ps);
            switch (ps.getTriggerId()) {
                case "radar_lock": {
                    this.radarLockIndex = i;
                    continue block12;
                }
                case "radar_found": {
                    this.radarFoundIndex = i;
                    continue block12;
                }
                case "flare": {
                    this.flareIndex = i;
                    continue block12;
                }
                case "chaff": {
                    this.chaffIndex = i;
                }
            }
        }
    }

    public void playRadarLockSound() {
        if (this.radarLockIndex > -1) {
            this.passengerSounds.get(this.radarLockIndex).playSound();
        }
    }

    public void playRadarFoundSound() {
        if (this.radarFoundIndex > -1) {
            this.passengerSounds.get(this.radarFoundIndex).playSound();
        }
    }

    public void playFlareSound() {
        if (this.flareIndex > -1) {
            this.passengerSounds.get(this.flareIndex).playSound();
        }
    }

    public void playChaffSound() {
        if (this.chaffIndex > -1) {
            this.passengerSounds.get(this.chaffIndex).playSound();
        }
    }

    public void clientTickPassengerSounds(EntityVehicle vehicle) {
        if (!vehicle.isOperational()) {
            return;
        }
        this.passengerSounds.forEach(sound -> sound.testPlaySound(vehicle));
    }

    public JsonPresetType getType() {
        return STANDARD;
    }

    @Nullable
    public JsonPresetInstance<?> createPresetInstance() {
        return null;
    }

    public static class PassengerSound {
        @Nullable
        final SoundEvent sound;
        private final float volume;
        private final float pitch;
        private final int tick_length;
        private final int repeat_rate;
        private final int group_burst_size;
        private final int group_burst_repeat_rate;
        private final boolean skip_queue;
        private final boolean allow_overlap;
        private final String triggerId;
        private final BiPredicate<EntityVehicle, PassengerSound> shouldPlaySound;
        private long lastPlay = 0L;

        public PassengerSound(JsonObject json) {
            String soundId = UtilParse.getStringSafe((JsonObject)json, (String)"sound", (String)"");
            this.sound = soundId.isEmpty() ? null : new SoundEvent(new ResourceLocation(soundId));
            this.volume = UtilParse.getFloatSafe((JsonObject)json, (String)"volume", (float)1.0f);
            this.pitch = UtilParse.getFloatSafe((JsonObject)json, (String)"pitch", (float)1.0f);
            this.repeat_rate = UtilParse.getIntSafe((JsonObject)json, (String)"repeat_rate", (int)20);
            this.tick_length = UtilParse.getIntSafe((JsonObject)json, (String)"tick_length", (int)this.repeat_rate);
            this.group_burst_size = UtilParse.getIntSafe((JsonObject)json, (String)"group_burst_size", (int)-1);
            this.group_burst_repeat_rate = UtilParse.getIntSafe((JsonObject)json, (String)"group_burst_repeat_rate", (int)-1);
            this.skip_queue = UtilParse.getBooleanSafe((JsonObject)json, (String)"skip_queue", (boolean)false);
            this.allow_overlap = UtilParse.getBooleanSafe((JsonObject)json, (String)"allow_overlap", (boolean)false);
            this.triggerId = UtilParse.getStringSafe((JsonObject)json, (String)"trigger", (String)"never");
            this.shouldPlaySound = soundTriggers.getOrDefault(this.triggerId, (vehicle, sound) -> false);
        }

        public boolean shouldPlaySound(EntityVehicle vehicle) {
            return this.shouldPlaySound.test(vehicle, this);
        }

        public void testPlaySound(EntityVehicle vehicle) {
            if (this.getSound() != null && this.shouldPlaySound(vehicle)) {
                this.playSound();
            }
        }

        public void playSound() {
            if (this.getSound() == null) {
                return;
            }
            if (!this.allow_overlap && this.wouldOverlap()) {
                return;
            }
            if (this.skipQueue()) {
                UtilClientSafeSounds.playCockpitSound(this.getSound(), this.getPitch(), this.getVolume());
            } else {
                UtilClientSafeSounds.queueCockpitSound(this.getSound(), this.getPitch(), this.getVolume(), this.getTickLength());
            }
            this.lastPlay = System.currentTimeMillis();
        }

        public boolean wouldOverlap() {
            return System.currentTimeMillis() - this.lastPlay <= (long)this.tick_length * 50L - 50L;
        }

        @Nullable
        public SoundEvent getSound() {
            return this.sound;
        }

        public float getVolume() {
            return this.volume;
        }

        public float getPitch() {
            return this.pitch;
        }

        public int getTickLength() {
            return this.tick_length;
        }

        public boolean skipQueue() {
            return this.skip_queue;
        }

        public int getRepeatRate() {
            return this.repeat_rate;
        }

        public int getGroupBurstSize() {
            return this.group_burst_size;
        }

        public int getGroupBurstRepeatRate() {
            return this.group_burst_repeat_rate;
        }

        public String getTriggerId() {
            return this.triggerId;
        }

        public boolean allowOverlap() {
            return this.allow_overlap;
        }
    }
}

