/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.vehicle;

import com.mojang.logging.LogUtils;
import com.onewhohears.dscombat.Config;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class SeaLevels {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, SeaLevelData> map = new HashMap<String, SeaLevelData>();

    public static double getAirPressure(ResourceKey<Level> dimension, double posY) {
        String dimId = dimension.m_135782_().toString();
        if (!map.containsKey(dimId)) {
            return 0.8;
        }
        return map.get(dimId).getAirPressure(posY);
    }

    public static void readConfig() {
        LOGGER.info("SeaLevels READ CONFIG");
        map.clear();
        List list = (List)Config.COMMON.dimensionSeaLevels.get();
        for (String level : list) {
            String[] data = level.split("!");
            String dimension = data[0];
            int sea_level = Integer.parseInt(data[1]);
            int space_level = Integer.parseInt(data[2]);
            map.put(dimension, new SeaLevelData(sea_level, space_level));
        }
    }

    public static class SeaLevelData {
        public final int sea_level;
        public final int space_level;

        public SeaLevelData(int sea_level, int space_level) {
            this.sea_level = sea_level;
            this.space_level = space_level;
        }

        public double getAirPressure(double posY) {
            double scale = 1.0;
            double exp = 2.0;
            if (posY <= (double)this.sea_level) {
                return scale;
            }
            if (posY > (double)this.space_level) {
                return 0.0;
            }
            return Math.pow(Math.abs((posY -= (double)this.sea_level) - (double)this.space_level), exp) * Math.pow(this.space_level, -exp);
        }
    }
}

