/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.vehicle;

import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.common.network.toserver.ToServerVehicleControl;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import net.minecraft.network.FriendlyByteBuf;

public class VehicleInputManager {
    public boolean flare;
    public boolean chaff;
    public boolean special;
    public boolean special2;
    public boolean bothRoll;
    public float throttle;
    public float pitch;
    public float roll;
    public float yaw;
    protected boolean isDriverCameraLocked;
    protected int weaponIndex;
    protected float currentThrottle;

    public VehicleInputManager() {
        this.reset();
    }

    public VehicleInputManager(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public void clientPilotControlsToServer(EntityVehicle parent, float throttle, float pitch, float roll, float yaw, boolean flare, boolean chaff, boolean special, boolean special2, boolean bothRoll, boolean isDriverCameraLocked) {
        this.throttle = throttle;
        this.pitch = pitch;
        this.roll = roll;
        this.yaw = yaw;
        this.flare = flare;
        this.chaff = chaff;
        this.special = special;
        this.special2 = special2;
        this.bothRoll = bothRoll;
        this.isDriverCameraLocked = isDriverCameraLocked;
        parent.setDriverCameraLocked(isDriverCameraLocked);
        this.weaponIndex = parent.weaponSystem.getSelectedIndex();
        this.currentThrottle = parent.getCurrentThrottle();
        PacketHandler.INSTANCE.sendToServer((Object)new ToServerVehicleControl(parent));
    }

    public void updateInputsFromPacket(VehicleInputManager other, EntityVehicle parent) {
        this.flare = other.flare;
        this.chaff = other.chaff;
        this.special = other.special;
        this.special2 = other.special2;
        this.throttle = other.throttle;
        this.pitch = other.pitch;
        this.roll = other.roll;
        this.yaw = other.yaw;
        this.bothRoll = other.bothRoll;
        this.weaponIndex = other.weaponIndex;
        this.currentThrottle = other.currentThrottle;
        this.isDriverCameraLocked = other.isDriverCameraLocked;
        parent.setCurrentThrottle(this.currentThrottle);
        parent.weaponSystem.setSelected(this.weaponIndex);
        parent.setDriverCameraLocked(this.isDriverCameraLocked);
    }

    public void reset() {
        this.throttle = 0.0f;
        this.pitch = 0.0f;
        this.roll = 0.0f;
        this.yaw = 0.0f;
        this.flare = false;
        this.chaff = false;
        this.special = false;
        this.special2 = false;
        this.bothRoll = false;
        this.isDriverCameraLocked = false;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.throttle);
        buffer.writeFloat(this.pitch);
        buffer.writeFloat(this.roll);
        buffer.writeFloat(this.yaw);
        buffer.writeBoolean(this.flare);
        buffer.writeBoolean(this.chaff);
        buffer.writeBoolean(this.special);
        buffer.writeBoolean(this.special2);
        buffer.writeBoolean(this.bothRoll);
        buffer.writeShort(this.weaponIndex);
        buffer.writeFloat(this.currentThrottle);
        buffer.writeBoolean(this.isDriverCameraLocked);
    }

    public void read(FriendlyByteBuf buffer) {
        this.throttle = buffer.readFloat();
        this.pitch = buffer.readFloat();
        this.roll = buffer.readFloat();
        this.yaw = buffer.readFloat();
        this.flare = buffer.readBoolean();
        this.chaff = buffer.readBoolean();
        this.special = buffer.readBoolean();
        this.special2 = buffer.readBoolean();
        this.bothRoll = buffer.readBoolean();
        this.weaponIndex = buffer.readShort();
        this.currentThrottle = buffer.readFloat();
        this.isDriverCameraLocked = buffer.readBoolean();
    }
}

