/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.vehicle;

import com.onewhohears.dscombat.data.vehicle.stats.BoatStats;
import com.onewhohears.dscombat.data.vehicle.stats.CarStats;
import com.onewhohears.dscombat.data.vehicle.stats.HeliStats;
import com.onewhohears.dscombat.data.vehicle.stats.PlaneStats;
import com.onewhohears.dscombat.data.vehicle.stats.StationaryStats;
import com.onewhohears.dscombat.data.vehicle.stats.SubmarineStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.ModEntities;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import net.minecraft.world.entity.EntityType;

public abstract class VehicleType
extends JsonPresetType {
    public static final Plane PLANE = Plane.INSTANCE;
    public static final Helicopter HELICOPTER = Helicopter.INSTANCE;
    public static final Car CAR = Car.INSTANCE;
    public static final Boat BOAT = Boat.INSTANCE;
    public static final Submarine SUBMARINE = Submarine.INSTANCE;
    public static final Stationary STATIONARY = Stationary.INSTANCE;

    public VehicleType(String id, JsonPresetType.JsonPresetStatsFactory<? extends JsonPresetStats> statsFactory) {
        super(id, statsFactory);
    }

    public abstract EntityType<? extends EntityVehicle> getEntityType();

    public static class Plane
    extends VehicleType {
        public static final String ID = "plane";
        public static final Plane INSTANCE = new Plane();

        public Plane() {
            super(ID, (JsonPresetType.JsonPresetStatsFactory<? extends JsonPresetStats>)((JsonPresetType.JsonPresetStatsFactory)PlaneStats::new));
        }

        @Override
        public EntityType<? extends EntityVehicle> getEntityType() {
            return (EntityType)ModEntities.PLANE.get();
        }
    }

    public static class Helicopter
    extends VehicleType {
        public static final String ID = "helicopter";
        public static final Helicopter INSTANCE = new Helicopter();

        public Helicopter() {
            super(ID, (JsonPresetType.JsonPresetStatsFactory<? extends JsonPresetStats>)((JsonPresetType.JsonPresetStatsFactory)HeliStats::new));
        }

        @Override
        public EntityType<? extends EntityVehicle> getEntityType() {
            return (EntityType)ModEntities.HELICOPTER.get();
        }
    }

    public static class Car
    extends VehicleType {
        public static final String ID = "car";
        public static final Car INSTANCE = new Car();

        public Car() {
            super(ID, (JsonPresetType.JsonPresetStatsFactory<? extends JsonPresetStats>)((JsonPresetType.JsonPresetStatsFactory)CarStats::new));
        }

        @Override
        public EntityType<? extends EntityVehicle> getEntityType() {
            return (EntityType)ModEntities.CAR.get();
        }
    }

    public static class Boat
    extends VehicleType {
        public static final String ID = "boat";
        public static final Boat INSTANCE = new Boat();

        public Boat() {
            super(ID, (JsonPresetType.JsonPresetStatsFactory<? extends JsonPresetStats>)((JsonPresetType.JsonPresetStatsFactory)BoatStats::new));
        }

        @Override
        public EntityType<? extends EntityVehicle> getEntityType() {
            return (EntityType)ModEntities.BOAT.get();
        }
    }

    public static class Submarine
    extends VehicleType {
        public static final String ID = "submarine";
        public static final Submarine INSTANCE = new Submarine();

        public Submarine() {
            super(ID, (JsonPresetType.JsonPresetStatsFactory<? extends JsonPresetStats>)((JsonPresetType.JsonPresetStatsFactory)SubmarineStats::new));
        }

        @Override
        public EntityType<? extends EntityVehicle> getEntityType() {
            return (EntityType)ModEntities.SUBMARINE.get();
        }
    }

    public static class Stationary
    extends VehicleType {
        public static final String ID = "stationary";
        public static final Stationary INSTANCE = new Stationary();

        public Stationary() {
            super(ID, (JsonPresetType.JsonPresetStatsFactory<? extends JsonPresetStats>)((JsonPresetType.JsonPresetStatsFactory)StationaryStats::new));
        }

        @Override
        public EntityType<? extends EntityVehicle> getEntityType() {
            return (EntityType)ModEntities.STATIONARY.get();
        }
    }
}

